	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	VIKBLIT.ASM
;
;    Accelerated blit for the Viking I.
;
;-----------------------------------------------------------------------;


;

incLogical	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include macros.mac
	include vikingi.inc
	include cursor.inc
	.list

	public	real_width
	externB	vik_busy

sBegin	Data
real_width	dw	32
pattern_buf	dw	16 dup(-1)
agcpy_buf	dw	8, VIKING_AMOVE, 0, 0, VIKING_AGCPY, 0, 0, 0, 0
cpy_buf		dw	5, VIKING_SCPY, 0, 0, 0, 0
apll_buf	dw	4, VIKING_APLL, 0, 0, 0
rpll_buf	dw	4, VIKING_RPLL, 0, 0, 0
rpll3_buf	dw	4, VIKING_RPLL + 3, -1, 0, 0
sEnd	Data

sBegin	Code
assumes cs,Code

	externW _cstods
	externB bus_width
	externB	X49EB
	externB mirror_byte
	externB mirror_invert
	externNP endbusy
	externNP busy_xflush
	externNP exclude
	externNP unexclude
	externNP viking_flush
page

	public viking_bitblt

lpDestDev	equ	dword ptr [bp+62h]
destxorg	equ	word ptr [bp+60h]
destyorg	equ	word ptr [bp+5Eh]
lpSrcDev	equ	dword ptr [bp+5Ah]
srcxorg		equ	word ptr [bp+58h]
srcyorg		equ	word ptr [bp+56h]
xext		equ	word ptr [bp+54h]
yext		equ	word ptr [bp+52h]
Rop		equ	word ptr [bp+50h]
lpPBrush	equ	dword ptr [bp+4Ah]

gl_srcxorg	equ	word ptr [bp-2]
gl_srcyorg	equ	word ptr [bp-4]
gl_destxorg	equ	word ptr [bp-6]
gl_destyorg	equ	word ptr [bp-8]
gl_xext		equ	word ptr [bp-0Ah]
gl_yext		equ	word ptr [bp-0Ch]
bp0e		equ	word ptr [bp-0Eh]
bp10		equ	word ptr [bp-10h]
gl_srcxorg2	equ	word ptr [bp-12h]
gl_srcyorg2	equ	word ptr [bp-14h]
gl_destxorg2	equ	word ptr [bp-16h]
gl_destyorg2	equ	word ptr [bp-18h]
gl_xext2	equ	word ptr [bp-1Ah]
gl_yext2	equ	word ptr [bp-1Ch]
pattern_row	equ	word ptr [bp-1Eh]
gl_destaddrh	equ	word ptr [bp-20h]
gl_destaddrl	equ	word ptr [bp-22h]
gl_srcwidth	equ	word ptr [bp-24h]
bp26		equ	word ptr [bp-26h]
gl_srcxorg3	equ	word ptr [bp-28h]
bp2a		equ	word ptr [bp-2Ah]
gl_lmask	equ	word ptr [bp-2Ch]
gl_mmask	equ	word ptr [bp-2Eh]
gl_rmask	equ	word ptr [bp-30h]
gl_ropflag	equ	word ptr [bp-32h]
gl_ropidx	equ	word ptr [bp-34h]
bp35		equ	byte ptr [bp-35h]
patinvert	equ	byte ptr [bp-36h]
bp37		equ	byte ptr [bp-37h]
bp3a		equ	word ptr [bp-3ah]
bp3c		equ	word ptr [bp-3ch]
bp3e		equ	word ptr [bp-3eh]
blitparams	equ	word ptr [bp-40h]
bp41		equ	byte ptr [bp-41h]

viking_bitblt	proc	near
	push	bp
	mov	bp, sp
	sub	sp, 42h
	cld
	mov	bp35, al
	call	copy_params	
	mov	patinvert, 0
	mov	bp37, 0
	mov	gl_ropidx, 0
	mov	blitparams, 0
	mov	bp41, 1
	mov	ax, gl_srcyorg
	mov	bp0e, ax
	mov	ax, gl_destyorg
	mov	bp10, ax
	mov	al, bp35
	call	calc_exclusion
	mov	bx, Rop
	mov	cl, 3
	shl	bx, cl
	add	bx, offset X49EB
	mov	gl_ropflag, bx
	call	busy_xflush
apply_rops:
	mov	bx, gl_ropflag
	mov	si, gl_ropidx
	mov	al, cs:[bx+si]
	mov	di, offset vik_rops
	xor	ah, ah
	add	di, ax
	add	di, ax
	mov	ah, bp35
	call	word ptr cs:[di]
	inc	gl_ropidx
	jmp	short apply_rops

viking_bitblt	endp

;
; This has got to be a 'can't happen' case
;
vik_rop1:
	jmp	short vik_rop1

vik_rop0:
	pop	ax
	call	endbusy
	mov	sp, bp
	pop	bp
	ret
;
; Not sure what this is - orphaned code to abort BitBlt?
;
	mov	sp, bp
	pop	bp
	retn	62h
;
vik_rops label	word
	dw	offset	vik_rop0
	dw	offset	vik_rop1
	dw	offset	vik_rop2
	dw	offset	vik_rop3
	dw	offset	vik_rop4
	dw	offset	vik_rop5
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop16	
	dw	offset	vik_rop16	
	dw	offset	vik_rop16	
	dw	offset	vik_rop16	
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop24
	dw	offset	vik_rop25
	dw	offset	vik_rop26
	dw	offset	vik_rop27
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1
	dw	offset	vik_rop1

calc_exclusion	proc	near
	push	dx
	mov	si, gl_xext
	mov	di, gl_yext
	dec	si
	dec	di
	mov	cx, gl_destxorg
	mov	dx, gl_destyorg
	cmp	al, 3
	jnz	calc_exclusion_3
	mov	ax, cx
	mov	bx, dx
	mov	cx, gl_srcxorg
	mov	dx, gl_srcyorg
	cmp	cx, ax
	jle	calc_exclusion_1
	xchg	ax, cx
calc_exclusion_1:
	cmp	dx, bx
	jle	calc_exclusion_2
	xchg	dx, bx
calc_exclusion_2:
	add	si, ax
	add	di, bx
	jmp	short calc_exclusion_4
;
calc_exclusion_3:	
	add	si, cx
	add	di, dx
calc_exclusion_4:
	call	exclude
	pop	dx
	ret
calc_exclusion	endp

vik_rop16:
	and	al, 3
	mov	blitparams, ax
	and	blitparams, word ptr 3
	sub	ah, 1
	jc	vik_rop16c
	jz	vik_rop16d
;
; Check for, and flag, overlaps.
;
	mov	bp41, 1
	mov	ax, gl_srcxorg
	cmp	ax, gl_destxorg
	jge	vik_rop16a
	add	ax, gl_xext
	cmp	ax, gl_destxorg
	jle	vik_rop16a
	mov	bp41, 3
vik_rop16a:
	mov	ax, gl_srcyorg
	cmp	ax, gl_destyorg
	jge	vik_rop16b
	add	ax, gl_yext
	cmp	ax, gl_destyorg
	jle	vik_rop16b
	and	bp41, 2
vik_rop16b:
	jmp	vik_sscopy

vik_rop16c:
	jmp	vik_rop1
;
vik_rop16d:
	mov	ah, al
	mov	cl, 0
	cmp	al, 1
	jz	vik_rop16e
	cmp	al, 2
	jz	vik_rop16e
	cmp	cs:byte ptr[bx+si+1], 3
	jnz	vik_rop16e
	mov	cl, 1
	inc	gl_ropidx
vik_rop16e:
	mov	al, cl
	jmp	vik_rop16f	;Which is right here?
vik_rop16f:
	push	ax
	call	dup_params
	mov	si, gl_srcxorg2
	mov	di, gl_destxorg2
	mov	cx, gl_xext2
	test	di, 0Fh		;Destination word-aligned?
	jz	vik_rop16g
	jmp	vik_rop16q
vik_rop16g:
	test	si, 0Fh		;Source word-aligned?
	jz	vik_rop16h
	jmp	vik_rop16ad
vik_rop16h:
	test	cx, 0Fh		;Count word-aligned?
	jz	vik_rop16i
	jmp	vik_rop16m

vik_rop16i:
	mov	ax, 0FFFFh
vik_rop16j:
	push	ax
	xor	bx, bx	
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	pop	ax
	call	calc_destaddr
	pop	ax
	call	vik_makemod	;ES becomes MOD command
	mov	cx, gl_xext2
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	jnz	vik_rop16k
	inc	cx
vik_rop16k:
	push	cx
	call	viking_flush
	call	vik_copyline
	pop	cx
	dec	gl_yext2
	jz	vik_rop16l
	call	vik_nextline
	jmp	short vik_rop16k
;
vik_rop16l:
	ret

vik_rop16m:
	cmp	cx, 10h		;Copying fewer than 16 pixels?
	jg	vik_rop16n	;If so they'll all fit in a word
	mov	ax, 0FFFFh
	shr	ax, cl		;Let AX be the mask necessary to access 
	xor	ax, 0FFFFh	;those pixels
	jmp	short vik_rop16j
;
vik_rop16n:
	add	cx, di
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shl	ax, cl
	xor	ax, 0FFFFh
	mov	gl_lmask, ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	mov	ax, 0FFFFh
	mov	gl_rmask, ax
	call	calc_destaddr
	pop	ax
	call	vik_makemod	;ES becomes MOD command
	mov	cx, gl_xext2
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
vik_rop16o:
	push	cx
	call	viking_flush
	call	vik_copyline
	call	viking_flush
	call	vik_lrmask
	pop	cx
	dec	gl_yext2
	jz	vik_rop16p
	call	vik_nextline
	jmp	short vik_rop16o
;
vik_rop16p:
	ret
;	
vik_rop16q:
	mov	ax, 0Fh
	mov	bx, ax
	and	ax, di
	and	bx, si
	cmp	ax, bx
	jz	vik_rop16r
	jmp	vik_rop16ad
;
vik_rop16r:
	cmp	cx, 10h
	jg	vik_rop16w
	add	ax, cx
	dec	ax
	test	ax, 0FFF0h
	jnz	vik_rop16s
	mov	ax, 0FFFFh
	and	si, wptr 0Fh
	xchg	cx, si
	shl	ax, cl
	xchg	cx, si
	rol	ax, cl
	add	si, cx
	mov	cx, 10h
	sub	cx, si
	shl	ax, cl
	jmp	vik_rop16j
;
vik_rop16s:
	and	si, wptr 0Fh
	xchg	cx, si
	mov	ax, 0FFFFh
	shl	ax, cl
	mov	gl_lmask, ax
	add	si, di
	mov	cx, si
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shl	ax, cl
	xor	ax, 0FFFFh
	mov	gl_rmask, ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	call	calc_destaddr
	pop	ax
	call	vik_makemod	;ES becomes MOD command
vik_rop16t:
	mov	cx, gl_yext2
vik_rop16u:
	call	viking_flush
	call	vik_lrmask2
	dec	cx
	jz	vik_rop16v
	call	vik_nextline
	jmp	short vik_rop16u
;
vik_rop16v:
	ret
;
vik_rop16w:
	mov	ax, di
	add	ax, cx
	test	ax, 0Fh
	jnz	vik_rop16z
	mov	cl, 0Fh
	and	cx, si
	mov	ax, 0FFFFh
	shl	ax, cl
	mov	gl_lmask, ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	mov	ax, 0FFFFh
	mov	gl_rmask, ax
	call	calc_destaddr
	pop	ax
	call	vik_makemod	;ES becomes MOD command
	mov	cx, gl_xext2
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	jnz	vik_rop16x
	inc	cx
vik_rop16x:
	push	cx
	call	viking_flush
	call	vik_lrmask
	call	viking_flush
	call	vik_copyline
	pop	cx
	dec	gl_yext2
	jz	vik_rop16y
	call	vik_nextline
	jmp	short vik_rop16x
;
vik_rop16y:
	ret
;
vik_rop16z:
	and	si, wptr 0Fh
	xchg	cx, si
	mov	ax, 0FFFFh
	shl	ax, cl
	mov	gl_lmask, ax
	add	si, di
	mov	cx, si
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shl	ax, cl
	xor	ax, 0FFFFh
	mov	gl_mmask, ax
	mov	gl_rmask, 0FFFFh
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	call	calc_destaddr
	pop	ax
	call	vik_makemod	;ES becomes MOD command
	mov	cx, gl_destxorg2
	and	cx, wptr 0Fh
	mov	ax, 10h
	sub	ax, cx
	mov	cx, gl_xext2
	sub	cx, ax
	jc	vik_rop16aa
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1
	jnz	vik_rop16ab
vik_rop16aa:
	mov	ax, gl_mmask
	mov	gl_rmask, ax
	jmp	vik_rop16t
;
vik_rop16ab:
	push	cx
	call	viking_flush
	call	vik_lrmask
	call	viking_flush
	call	vik_copyline
	call	viking_flush
	call	vik_mmask
	pop	cx
	dec	gl_yext2
	jz	vik_rop16ac
	call	vik_nextline
	jmp	short vik_rop16ab
;
vik_rop16ac:
	ret

vik_rop16ad:
	test	cx, 0FFF0h
	jz	vik_rop16ae
	jmp	vik_rop16ak
;
vik_rop16ae:
	mov	ax, di
	and	ax, 0Fh
	add	ax, cx
	dec	ax
	test	ax, 0FFF0h
	jnz	vik_rop16ah
	mov	ax, 0FFFFh
	mov	bx, di
	and	bx, wptr 0Fh
	xchg	cx, bx
	shl	ax, cl
	xchg	cx, bx
	rol	ax, cl
	add	bx, cx
	mov	cx, 10h
	sub	cx, bx
	shl	ax, cl
	push	ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	pop	ax
	call	calc_destaddr
	pop	ax
	call	vik_makemod
	call	calc_phase
vik_rop16af:	
	push	ax
	add	si, ax
	call	viking_flush
	call	masked_write
	dec	gl_yext2
	jz	vik_rop16ag
	call	vik_nextline
	pop	ax
	jmp	short vik_rop16af
;
vik_rop16ag:
	add	sp, 2
	ret
;
vik_rop16ah:
	and	di, wptr 0Fh
	xchg	cx, di
	mov	ax, 0FFFFh
	shl	ax, cl
	mov	gl_lmask, ax
	mov	al, 10h
	sub	al, cl
	mov	cx, di
	sub	cl, al
	mov	ax, 0FFFFh
	shl	ax, cl
	xor	ax, 0FFFFh
	mov	gl_rmask, ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	call	viking_flush
	call	calc_destaddr
	pop	ax
	call	vik_makemod
	call	calc_phase
vik_rop16ai:
	push	ax
	add	si, ax
	call	viking_flush
	call	X3E01
	dec	gl_yext2
	jz	vik_rop16aj
	call	vik_nextline
	pop	ax
	jmp	short vik_rop16ai
;
vik_rop16aj:
	add	sp, 2
	ret
;
vik_rop16ak:
	mov	si, di
	and	si, wptr 0Fh
	xchg	cx, si
	mov	ax, 0FFFFh
	shl	ax, cl
	mov	gl_lmask, ax
	add	si, di
	mov	cx, si
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shl	ax, cl
	xor	ax, 0FFFFh
	mov	gl_rmask, ax
	xor	bx, bx
	xor	cx, cx
	call	calc_srcaddr
	mov	bp26, di
	call	viking_flush
	call	calc_destaddr
	pop	ax
	call	vik_makemod
	call	calc_phase
	push	ax
	mov	di, gl_destxorg2
	and	di, wptr 0Fh
	mov	ax, 10h
	sub	ax, di
	mov	di, gl_xext2
	sub	di, ax
	jc	vik_rop16al
	shr	di, 1
	shr	di, 1
	shr	di, 1
	shr	di, 1
	jnz	vik_rop16am
vik_rop16al:
	mov	di, bp26
	pop	ax
	jmp	short vik_rop16ai
;
vik_rop16am:
	pop	ax
	add	si, ax
	push	ax
	push	cx
	push	di
	call	viking_flush
	call	shifted_write
	pop	di
	pop	cx
	dec	gl_yext2
	jz	vik_rop16an
	xchg	di, bp26
	call	vik_nextline
	xchg	di, bp26
	jmp	short vik_rop16am
;
vik_rop16an:
	add	sp, 2
	ret	

vik_makemod	proc near
	mov	bx, offset mirror_byte
	cmp	al, 1
	jnz	vik_makemod1
	mov	bx, offset mirror_invert
vik_makemod1:
	mov	al, ah
	xor	ah, ah
	or	ax, VIKING_MOD
	mov	es, ax		;Using ES as a data register!
	ret
vik_makemod	endp

calc_phase	proc	near
	push	bx
	mov	ax, gl_destxorg2
	and	ax, 0Fh
	mov	bx, gl_srcxorg2
	and	bx, wptr 0Fh
	sub	bx, ax
	add	bx, offset phasetbl
	mov	al, cs:[bx]
	xor	ah, ah
	mov	cl, al
	and	cl, 7
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	ch, al
	and	ch, 1
	shr	ax, 1
	add	ax, 0FFFEh
	pop	bx
	ret

calc_phase	endp

	db	     01h, 02h, 03h, 0Ch, 0Bh, 0Ah, 09h
	db	10h, 11h, 12h, 13h, 1Ch, 1Bh, 1Ah, 19h
phasetbl db	20h, 21h, 22h, 23h, 24h, 2Bh, 2Ah, 29h
	db	30h, 31h, 32h, 33h, 34h, 3Bh, 3Ah, 39h	


copy_params	proc	near
	push	ax
	mov	ax, srcxorg
	mov	gl_srcxorg, ax
	mov	ax, srcyorg
	mov	gl_srcyorg, ax
	mov	ax, destxorg
	mov	gl_destxorg, ax
	mov	ax, destyorg
	mov	gl_destyorg, ax
	mov	ax, xext
	mov	gl_xext, ax
	mov	ax, yext
	mov	gl_yext, ax
	pop	ax
	ret

copy_params	endp

dup_params	proc	near
	push	ax
	mov	ax, gl_srcxorg
	mov	gl_srcxorg2, ax
	mov	ax, gl_srcyorg
	mov	gl_srcyorg2, ax
	mov	ax, gl_destxorg
	mov	gl_destxorg2, ax
	mov	ax, gl_destyorg
	mov	gl_destyorg2, ax
	mov	ax, gl_xext
	mov	gl_xext2, ax
	mov	ax, gl_yext
	mov	gl_yext2, ax
	pop	ax
	ret
dup_params	endp

calc_srcaddr	proc	near
	push	dx
	les	di, lpSrcDev
	lds	si, es:[di].bmBits
	mov	di, es:[di].bmWidthBytes
	mov	gl_srcwidth, di	
	push	bx
	mov	ax, gl_srcyorg2
	add	ax, cx
	mul	di
	mov	cx, ds
	rol	cx, 1
	rol	cx, 1
	rol	cx, 1
	rol	cx, 1
	mov	bx, cx
	and	bx, wptr 0Fh
; 	and	cx, wptr 0FFF0h
	dw	0E181h
	dw	0FFF0h
	add	si, cx
	adc	bx, 0
	add	ax, si
	adc	dx, bx
	pop	bx
	add	bx, gl_srcxorg2
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	and	bx, 1FFEh
	add	ax, bx
	adc	dx, 0
	mov	cl, 4
	ror	dx, cl
	and	dx, 0F000h
	mov	bx, ax
	shr	bx, cl
	and	bx, 0FFFh
	or	dx, bx
	and	ax, 0Fh
	mov	ds, dx
	mov	si, ax
	mov	di, si
	pop	dx
	ret
calc_srcaddr	endp

calc_destaddr	proc	near
	push	ax
	mov	bx, gl_destxorg2
	mov	cx, gl_destyorg2
	shl	cx, 1
	shl	cx, 1
	shl	cx, 1
	mov	ah, cl
	xor	al, al
	add	ax, bx
	adc	ch, 0
	mov	bx, ax
	mov	cl, ch
	xor	ch, ch
	mov	gl_destaddrh, cx
	mov	gl_destaddrl, bx
	test	cs:bus_width, 1
	jz	calc_destaddr8
	WPR16	VIKING_RWP0, cx
	WPR16	VIKING_RWP1, bx
	mov	ax,VIKING_WPR OR VIKING_MASK
	out	dx, ax
	mov	bx, offset mirror_byte
	pop	ax
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, ax
	ret	

calc_destaddr8:
	mov	ax, VIKING_WPR OR VIKING_RWP0
	OUT_DX_AHAL
	OUT_DX_CHCL
	mov	ax, VIKING_WPR OR VIKING_RWP1
	OUT_DX_AHAL
	OUT_DX_BHBL
	mov	ax,VIKING_WPR OR VIKING_MASK
	OUT_DX_AHAL
	mov	bx, offset mirror_byte
	pop	ax
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	ret

calc_destaddr	endp

calc_srcoffset	proc	near
	mov	ax, gl_srcyorg2
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	mov	ch, al
	xor	cl, cl
	add	cx, gl_srcxorg2
	adc	ah, 0
	mov	al, ah
	xor	ah, ah
	ret
calc_srcoffset	endp

vik_copyline	proc near
	test	cs:bus_width, 1
	jz	vik_copyline8
	cmp	cx, 4
	jl	vik_copyline5
;
; This looks like an unrolled loop to me
;
vik_copyline1:
	mov	ax, es	;The payoff for ES being used as a general data register
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
vik_copyline2:
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
vik_copyline3:
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
vik_copyline4:
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	sub	cx, 4
	jz	vik_copyline7
vik_copyline5:
	cmp	cx, 4
	jge	vik_copyline6
	call	viking_flush
	mov	ax, cx
	mov	cx, 4
	dec	ax
	jz	vik_copyline4
	dec	ax
	jz	vik_copyline3
	jmp	short vik_copyline2
;
vik_copyline6:
	sub	dx, 2
	in 	al, dx
	add	dx, 2
	rcr	al, 1
	jc	vik_copyline1
	mov	ax, offset vik_copyline1	;Seems an odd way of doing
	push	ax				;CALL viking_flush 
	jmp	viking_flush			;then JMP vik_copyline1 
;
vik_copyline7:
	jmp	viking_flush

vik_copyline8:
	cmp	cx, 4
	jl	vik_copyline13
vik_copyline9:
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
vik_copyline10:
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
vik_copyline11:
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
vik_copyline12:
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	sub	cx, 4
	jz	vik_copyline7
vik_copyline13:
	cmp	cx, 4
	jge	vik_copyline14
	call	viking_flush
	mov	ax, cx
	mov	cx, 4
	dec	ax
	jz	vik_copyline12
	dec	ax
	jz	vik_copyline11
	jmp	short vik_copyline10
;
vik_copyline14:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jc	vik_copyline9
	mov	ax, offset vik_copyline9
	push	ax
	jmp	viking_flush
vik_copyline endp

shifted_write	proc	near
	test	cs:bus_width, 1
	jz	shifted_write_8
	WPR16	VIKING_MASK, gl_lmask
	call	masked_write
	WPR16	VIKING_MASK, 0FFFFh
	test	ch, 1
	jnz	shift_r_16
shift_l_16:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	shift_l_16
	mov	ax, es
	out	dx, ax
	lodsw
	xchg	al, ah
	mov	ch, al
	shl	ax, cl
	xchg	ch, ah
	mov	al, [si]
	shl	ax, cl
	mov	al, ah
	mov	ah, ch
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, ax
	dec	di
	jnz	shift_l_16
	xor	ch, ch
	jmp	shift_fringe_16
;
shift_r_16:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	shift_r_16
	mov	ax, es
	out	dx, ax
	lodsw
	xchg	al, ah
	mov	ch, al
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	xlat	byte ptr cs:[bx]
	mov	ah, al
	mov	al, ch	
	xlat	byte ptr cs:[bx]
	out	dx, ax
	dec	di
	jnz	shift_r_16
	mov	ch, 1
shift_fringe_16:
	WPR16	VIKING_MASK, gl_rmask
	jmp	masked_write	
;
shifted_write_8:
	WPR8	VIKING_MASK, gl_lmask
	call	masked_write
	mov	ax, VIKING_WPR OR VIKING_MASK
	OUT_DX_AHAL
	mov	al, 0FFh
	out	dx, al
	out	dx, al
	test	ch, 1
	jnz	shift_r_8
shift_l_8:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	shift_l_8
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	mov	ch, al
	shl	ax, cl
	xchg	ah, ch
	mov	al, [si]
	shl	ax, cl
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ch	
	xlat	byte ptr cs:[bx]
	out	dx, al
	dec	di
	jnz	shift_l_8
	xor	ch, ch
	jmp	shift_fringe_8

shift_r_8:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	shift_r_8
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	mov	ch, al
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ch	
	xlat	byte ptr cs:[bx]
	out	dx, al
	dec	di
	jnz	shift_r_8
	mov	ch, 1
shift_fringe_8:
	WPR8	VIKING_MASK, gl_rmask
	jmp	masked_write	
	
shifted_write	endp

vik_lrmask	proc	near
	test	cs:bus_width,1
	jz	vik_lrmask8
	WPR16	VIKING_MASK, gl_lmask
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	WPR16	VIKING_MASK, gl_rmask
	ret
;
vik_lrmask8:
	WPR8	VIKING_MASK, gl_lmask
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	WPR8	VIKING_MASK, gl_rmask
	ret

vik_lrmask	endp

vik_mmask	proc	near
	test	cs:bus_width,1
	jz	vik_mmask8
	WPR16	VIKING_MASK, gl_mmask
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	ret
;
vik_mmask8:
	WPR8	VIKING_MASK, gl_mmask
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	ret

vik_mmask	endp

masked_write	proc	near
	test	cs:bus_width, 1
	jz	masked_write_8
	test	ch, 1
	jnz	masked_write_r16
	mov	ax, es
	out	dx, ax
	mov	ah, [si]
	inc	si
	mov	al, [si]
	inc	si
	mov	ch, al
	shl	ax, cl
	xchg	ch, ah
	mov	al, [si]
	shl	ax, cl
	mov	al, ch
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	xor	ch, ch
	ret
;
masked_write_r16:
	mov	ax, es
	out	dx, ax
	mov	ah, [si]
	inc	si
	mov	al, [si]
	inc	si
	mov	ch, al
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	xlat	byte ptr cs:[bx]
	mov	ah, al
	mov	al, ch
	xlat	byte ptr cs:[bx]
	out	dx, ax
	mov	ch, 1
	ret
;
masked_write_8:	
	test	ch, 1
	jnz	masked_write_r8
	mov	ax, es
	OUT_DX_AHAL
	mov	ah, [si]
	inc	si
	mov	al, [si]
	inc	si
	mov	ch, al
	shl	ax, cl
	xchg	ch, ah
	mov	al, [si]
	shl	ax, cl
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ch
	xlat	byte ptr cs:[bx]
	out	dx, al
	xor	ch, ch
	ret

masked_write_r8:	
	mov	ax, es
	OUT_DX_AHAL
	mov	ah, [si]
	inc	si
	mov	al, [si]
	inc	si
	mov	ch, al
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ch
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	ch, 1
	ret

masked_write	endp

vik_lrmask2 proc	near
	test	cs:bus_width,1
	jz	vik_lrmask28
	WPR16	VIKING_MASK, gl_lmask
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	WPR16	VIKING_MASK, gl_rmask
	mov	ax, es
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	ret
;
vik_lrmask28:
	WPR8	VIKING_MASK, gl_lmask
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	WPR8	VIKING_MASK, gl_rmask
	mov	ax, es
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	ret

vik_lrmask2	endp

X3E01	proc	near
	test	ch, 1
	jnz	X3E39
	mov	ah, [si]
	inc	si
	mov	al, [si]
	mov	ch, al
	inc	si
	shl	ax, cl
	xchg	ch, ah
	mov	al, [si]
	shl	ax, cl
	mov	al, ah
	mov	ah, ch
	mov	bp3a, ax
	mov	ah, [si]
	inc	si
	mov	al, [si]
	mov	ch, al
	inc	si
	shl	ax, cl
	xchg	ch, ah
	mov	al, [si]
	shl	ax, cl
	mov	al, ah
	mov	ah, ch
	mov	bp3c, ax
	xor	ch, ch
	jmp	X3E69

X3E39:	mov	ah, [si]
	inc	si
	mov	al, [si]
	mov	ch, al
	inc	si
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	mov	ah, ch
	mov	bp3a, ax
	mov	ah, [si]
	inc	si
	mov	al, [si]
	mov	ch, al
	inc	si
	shr	ax, cl
	mov	ah, ch
	mov	ch, al
	mov	al, [si]
	shr	ax, cl
	mov	ah, ch
	mov	bp3c, ax
	mov	ch, 1

X3E69:	test	cs:bus_width, 1
	jz	X3E9C
	WPR16	VIKING_MASK, gl_lmask
	mov	ax, es
	out	dx, ax
	mov	ax, bp3a
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, ax
	WPR16	VIKING_MASK, gl_rmask
	mov	ax, es
	out	dx, ax
	mov	ax, bp3c
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, ax
	ret
;	
X3E9C:	WPR8	VIKING_MASK, gl_lmask
	mov	ax, es
	OUT_DX_AHAL
	mov	ax, bp3a
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	WPR8	VIKING_MASK, gl_rmask
	mov	ax, es
	OUT_DX_AHAL
	mov	ax, bp3c
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	ret
;	
X3E01	endp


vik_nextline	proc	near
	call	viking_flush
	mov	si, di
	add	si, gl_srcwidth
	mov	di, si
	jnc	vik_nextline_1
	mov	ax, ds
	add	ax, 1000h
	mov	ds, ax
vik_nextline_1:
	test	cs:bus_width, 1
	jz	vik_nextline_8
	add	gl_destaddrl, 800h
	WPR16	VIKING_RWP1, gl_destaddrl
	jc	vik_nextline_2
	ret
;
vik_nextline_2:
	inc	gl_destaddrh
	WPR16	VIKING_RWP0, gl_destaddrh
	ret	

vik_nextline_8:
	add	gl_destaddrl, 800h
	WPR8	VIKING_RWP1, gl_destaddrl
	jc	vik_nextline_9
	ret
;
vik_nextline_9:
	inc	gl_destaddrh
	WPR8	VIKING_RWP0, gl_destaddrh
	ret

vik_nextline	endp

; Orphan code?
X3F4E:	mov	ax, offset rpll3_buf
	push	ax
	push	ax
	push	ax
	mov	ax, gl_srcxorg
	mov	gl_srcxorg3, ax
	mov	ax, gl_srcyorg
	mov	gl_destyorg2, ax
	mov	bp3e, 0FFFFh
	mov	blitparams, 3
	jmp	vik_rop4c
;
vik_rop3:
	mov	ax, offset rpll3_buf
	push	ax
	push	ax
	push	ax
	mov	bp3e, 0FFFFh
	mov	blitparams, 3
	jmp	vik_rop4b
;
vik_rop2xa:
	mov	bp3e, bx
	mov	blitparams, ax
	mov	ax, 74h
	push	ax
	push	ax
	push	ax
	jmp	vik_rop4b
;
vik_rop5:
	mov	bp3e, 0FFFFh
	mov	blitparams, 0
	jmp	vik_rop4a
;	
vik_rop4:
	mov	bp3e, 0
	mov	blitparams, 0
vik_rop4a:
	mov	ax, offset rpll_buf
	push	ax
	mov	ax, offset apll_buf
	push	ax
	mov	ax, offset rpll_buf
	push	ax
vik_rop4b:
	mov	ax, gl_destxorg
	mov	gl_srcxorg3, ax
	mov	ax, gl_destyorg
	mov	gl_destyorg2, ax
vik_rop4c:
	mov	ds, cs:_cstods
	mov	ax,gl_yext
	dec	ax
	neg	ax
	mov	gl_yext2, ax
	mov	ax, gl_srcxorg3
	mov	gl_destxorg2, ax
	mov	cx, gl_srcxorg3
	and	cx, wptr 0Fh
	mov	ax, gl_xext
	add	ax, cx
	dec	ax
	test	ax, 0FFF0h
	jnz	vik_rop4d
	add	sp, 2
	jmp	vik_rop4g
;
vik_rop4d:
	test	gl_srcxorg3, 0Fh
	jnz	vik_rop4e
	add	sp, 2
	jmp	vik_rop4f
;
vik_rop4e:
	call	viking_flush
	mov	ax, 0FFFFh
	shr	ax, cl
	call	calc_destaddr
	pop	bx
	mov	word ptr [bx+6], 0
	mov	ax, gl_yext2
	mov	[bx+8], ax
	mov	ax, bp3e
	mov	[bx+4], ax
	mov	ax, [bx+2]
	and	ax, 0FFFCh
	or	ax, blitparams
	mov	[bx+2], ax
	call	viking_flush
	call	writeblk
	mov	ax, gl_srcxorg3
	and	ax, 0FFF0h
	add	ax, 10h
	mov	gl_destxorg2, ax
vik_rop4f:
	mov	cx, gl_srcxorg3
	and	cx, wptr 0Fh
	mov	bx, 10h
	sub	bx, cx
	and	bx, wptr 0Fh
	mov	ax, gl_xext
	sub	ax, bx
	mov	cl, 4
	shr	ax, cl
	jnz	vik_rop4h
	add	sp, 2
	mov	cx, gl_srcxorg3
	add	cx, gl_xext
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shr	ax, cl
	xor	ax, 0FFFFh
	jmp	vik_rop4i
;
vik_rop4g:
	add	sp, 2
	mov	ax, 0FFFFh
	mov	cx, gl_srcxorg3
	and	cl, 0Fh
	mov	bl, cl
	shl	ax, cl
	mov	cx, gl_xext
	rol	ax, cl
	add	bl, cl
	mov	cl, 10h
	sub	cl, bl
	shl	ax, cl
	jmp	vik_rop4i
;
vik_rop4h:
	pop	bx
	dec	ax
	mov	[bx+6], ax
	mov	ax, gl_yext2
	mov	[bx+8], ax
	mov	ax, bp3e
	mov	[bx+4], ax
	mov	ax, [bx+2]
	and	ax, 0FFFCh
	or	ax, blitparams
	mov	[bx+2], ax
	call	viking_flush
	push	bx
	mov	ax, 0FFFFh
	call	calc_destaddr
	pop	bx
	call	viking_flush
	call	writeblk
	mov	cx, gl_srcxorg3
	add	cx, gl_xext
	mov	bx, cx
;;;	and	bx, wptr 0FFF0h
	dw	0E381h
	dw	0FFF0h
	mov	gl_destxorg2, bx
	and	cl, 0Fh
	jz	vik_rop4j
	mov	ax, 0FFFFh
	shr	ax, cl
	xor	ax, 0FFFFh
vik_rop4i:
	push	ax
	call	viking_flush
	pop	ax
	call	calc_destaddr
	pop	bx
	mov	word ptr [bx+6], 0
	mov	ax, gl_yext2
	mov	[bx+8], ax
	mov	ax, bp3e
	mov	[bx+4], ax
	mov	ax, [bx+2]
	and	ax, 0FFFCh
	or	ax, [bp-40h]
	mov	[bx+2], ax
	call	viking_flush
	call	writeblk
	ret
;
vik_rop4j:
	pop	bx
	ret
;
expand_pattern	proc	near
	push	dx
	lds	si, lpPBrush
	mov	bx, offset mirror_byte
	cmp	patinvert, 0
	jz	expand_pattern_1
	mov	bx, offset mirror_invert
expand_pattern_1:
	mov	es, cs:_cstods
	assumes es,Data
	mov	di, offset pattern_buf
	mov	al, [si]
	xlat	byte ptr cs:[bx]
	mov	dl, al
	mov	dh, 1
	mov	cx, 8
expand_pattern_2:
	lodsb
	xlat	byte ptr cs:[bx]
	mov	ah, al
	stosw
	cmp	al, dl
	jz	expand_pattern_3
	xor	dh, dh
expand_pattern_3:
	loop	expand_pattern_2
	mov	cx, 8
	mov	ax, es
	mov	ds, ax
	assumes ds,Data
	mov	si, offset pattern_buf
	rep	movsw
	mov	al, dh
	mov	bl, dl
	mov	bh, bl
	mov	ah, al
	xor	ah, 1
	mov	bp37, ah
	pop	dx
	ret
expand_pattern	endp

vik_rop2:
	xor	patinvert, 1
	mov	bp37, 0
	ret
;
write_pattern:
	mov	ds, cs:_cstods
	mov	si, offset pattern_buf
	mov	bp37, 2
	mov	cx, 4
	call	viking_flush
	test	cs:bus_width, 1
	jz	write_pattern_8
	mov	ax, VIKING_WPTN
	out	dx, ax
	mov	ax, 16
	out	dx, ax
write_pattern_1:
	sub	dx, 2
write_pattern_2:
	in	al, dx
	rcr	al, 1
	jnc	write_pattern_2
	add	dx, 2
	lodsw
	out	dx, ax
	lodsw
	out	dx, ax
	lodsw
	out	dx, ax
	lodsw
	out	dx, ax
	loop	write_pattern_1
	ret
;
write_pattern_8:
	mov	ax, VIKING_WPTN
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	mov	al, 16
	out	dx, al
write_pattern_9:
	sub	dx, 2
write_pattern_10:	
	in	al, dx
	rcr	al, 1
	jnc	write_pattern_10
	add	dx, 2
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	lodsb
	out	dx, al
	loop	write_pattern_9
	ret
;
	ret	;Orphan code?

writeblk:
	push	di
	mov	di, [bx]
	dec	di
	add	bx, 2
	xor	ah, ah
	mov	al, cs:bus_width
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	add	di, ax
	shl	di, 1
	add	di, offset writetab
	jmp	word ptr cs:[di]
;
write8w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write7w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write6w:	
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write5w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write4w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write3w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write2w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
write1w:
	mov	ax, [bx]
	out	dx, ax
	add	bx, 2
	pop	di
	ret	
;
write8b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write7b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write6b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write5b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write4b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write3b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write2b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
write1b:
	mov	al, [bx+1]
	out	dx, al
	mov	al, [bx]
	out	dx, al
	add	bx, 2
	pop	di
	ret

writetab label word
	dw	write1b
	dw	write2b
	dw	write3b
	dw	write4b
	dw	write5b
	dw	write6b
	dw	write7b
	dw	write8b
	dw	write1w
	dw	write2w
	dw	write3w
	dw	write4w
	dw	write5w
	dw	write6w
	dw	write7w
	dw	write8w
;
; These appear to be orphaned handlers 
;
X427B:	mov	bp2a, 0
	jmp	X4298
;
X4283:	mov	bp2a, 1
	jmp	X4298
;
X428B:	mov	bp2a, 2
	jmp	X4298
;
X4293:	mov	bp2a, 3
X4298:	mov	ax, gl_srcxorg
	mov	gl_srcxorg3, ax
	mov	ax, gl_srcyorg
	mov	gl_destyorg2, ax
	mov	ax, bp0e
	mov	pattern_row, ax
	jmp	vik_rop2y

vik_rop24:
	mov	bp2a, 0
	jmp	vik_rop2x

vik_rop25:
	mov	bp2a, 1
	jmp	vik_rop2x

vik_rop26:
	mov	bp2a, 2
	jmp	vik_rop2x

vik_rop27:
	mov	bp2a, 3
vik_rop2x:
	mov	ax, gl_destxorg
	mov	gl_srcxorg3, ax
	mov	ax, gl_destyorg
	mov	gl_destyorg2, ax
	mov	ax, bp10
	mov	pattern_row, ax
vik_rop2y:
	cmp	bp37, 0
	jnz	vik_rop2z
	call	expand_pattern
	dec	al
	js	vik_rop2z
	mov	ax, bp2a
	jmp	vik_rop2xa
;
vik_rop2z:
	mov	ax, gl_srcxorg3
	mov	gl_destxorg2, ax
	mov	ax, gl_yext
	mov	gl_yext2, ax
	mov	ax, gl_xext
	mov	gl_xext2, ax
	test	cs:bus_width, 1
	jnz	vik_rop2za
	cmp	ax, 20h
	jg	vik_rop2zc
	jmp	vik_rop2zb
;
vik_rop2za:
	cmp	ax, 10h
	jg	vik_rop2zc
vik_rop2zb:
	mov	ax, gl_srcxorg3
	and	ax, 0Fh
	xor	ch, ch
	mov	cl, 0Fh
	call	vik_rectfill
	jmp	vik_rop2zm
;
vik_rop2zc:
	test	gl_srcxorg3, 0Fh
	jz	vik_rop2zd
	mov	ax, gl_srcxorg3
	and	ax, 0Fh
	mov	ch, al
	mov	cl, 0Fh
	neg	ax
	and	ax, 0Fh
	mov	gl_xext2, ax
	mov	al, ch
	call	vik_rectfill
	mov	ax, gl_srcxorg3
	and	ax, 0FFF0h
	add	ax, 10h
	mov	gl_destxorg2, ax
vik_rop2zd:
	mov	cx, gl_srcxorg3
	and	cx, wptr 0Fh
	mov	ax, 10h
	sub	ax, cx
	and	ax, 0Fh
	neg	ax
	add	ax, gl_xext
	mov	cl, 4
	shr	ax, cl
	jnz	vik_rop2ze
	jmp	vik_rop2zl
;
vik_rop2ze:
	dec	ax
	push	ax
	call	viking_flush
	mov	ax, 0FFFFh
	call	calc_destaddr
	pop	cx
	mov	ax, VIKING_APLL 
	cmp	bp2a, 0
	jz	vik_rop2zf
	mov	ax, VIKING_RPLL
	add	ax, bp2a
vik_rop2zf:
	mov	es, ax
	push	bp
	mov	ds, cs:_cstods
	mov	bx, offset pattern_buf
	mov	si, pattern_row
	and	si, wptr 7
	add	si, si
	call	viking_flush
	sub	dx, 2
	mov	ax, gl_yext2
	mov	di, gl_destaddrh
	mov	bp, gl_destaddrl
	test	cs:bus_width, 1
	jz	vik_rop2zi
vik_rop2zg:
	push	ax
	add	dx, 2
	mov	ax, es
	out	dx, ax
	mov	ax, [bx+si]
	out	dx, ax
	mov	ax, cx
	out	dx, ax
	xor	ax, ax
	out	dx, ax
	add	bp, 800h
	adc	di, 0
	WPR16	VIKING_RWP0, di
	WPR16	VIKING_RWP1, bp
	add	si, 2
	and	si, wptr 1Fh
	sub	dx, 2
vik_rop2zh:
	in	al, dx
	rcr	al, 1
	jnc	vik_rop2zh
	pop	ax
	dec	ax
	jnz	vik_rop2zg
	jmp	vik_rop2zk
;
vik_rop2zi:
	push	ax
	add	dx, 2
	mov	ax, es
	OUT_DX_AHAL
	mov	al, [bx+si+1]
	out	dx, al
	mov	al, [bx+si]
	out	dx, al
	OUT_DX_CHCL
	xor	ax, ax
	out	dx, al
	mov	al, ah
	out	dx, al
	add	bp, 800h
	adc	di, 0
	WPR8	VIKING_RWP0, di
	WPR8	VIKING_RWP1, bp
	add	si, 2
	and	si, wptr 1Fh
	sub	dx, 2
vik_rop2zj:
	in	al, dx
	rcr	al, 1
	jnc	vik_rop2zj
	pop	ax
	dec	ax
	jnz	vik_rop2zi
vik_rop2zk:
	pop	bp
	add	dx, 2
vik_rop2zl:
	mov	cx, gl_srcxorg3
	add	cx, gl_xext
	test	cx, 0Fh
	jz	vik_rop2zm
	mov	bx, cx
;;;	and	bx, wptr 0FFF0h
	dw	0E381h	;and bx, 
	dw	0FFF0h
	mov	gl_destxorg2, bx
	and	cl, 0Fh
	xor	ch, ch
	mov	gl_xext2, cx
	mov	al, ch
	call	vik_rectfill	
vik_rop2zm:
	ret
;
vik_rectfill	proc	near
	cmp	bp37, 2
	jz	vik_rectfill_1
	push	ax
	push	cx
	call	write_pattern
	pop	cx
	pop	ax
vik_rectfill_1:	
	mov	bx, cx
	mov	cl, 4
	shl	bx, cl
	mov	ch, al
	shl	ch, cl
	call	viking_flush
	test	cs:bus_width, 1
	jz	vik_rectfill_8
	mov	ax, VIKING_WPR OR VIKING_PRC1
	out	dx, ax
	xor	ah, ah
	mov	al, bh
	out	dx, ax
	mov	ax, VIKING_WPR OR VIKING_PRC2
	out	dx, ax
	mov	ah, 0F0h
	mov	al, bl
	out	dx, ax
	call	viking_flush
	mov	ax, VIKING_WPR OR VIKING_PRC0
	out	dx, ax
	mov	ax, pattern_row
	and	ax, 0Fh
	ror	ax, cl
	mov	al, ch
	out	dx, ax
	AMOVE16	gl_destxorg2, gl_destyorg2
	mov	ax, bp2a
	or	ax, VIKING_RFRCT
	out	dx, ax
	mov	ax, gl_xext2
	dec	ax
	out	dx, ax
	mov	ax, gl_yext2
	dec	ax
	neg	ax
	out	dx, ax
	ret

vik_rectfill_8:
	mov	ax, VIKING_WPR OR VIKING_PRC1
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	mov	al, bh
	out	dx, al
	mov	ax, VIKING_WPR OR VIKING_PRC2
	OUT_DX_AHAL
	mov	al, 0F0h
	out	dx, al
	mov	al, bl
	out	dx, al
	call	viking_flush
	mov	ax, VIKING_WPR OR VIKING_PRC0
	OUT_DX_AHAL
	mov	ax, pattern_row
	and	al, 0Fh
	shl	al, cl
	out	dx, al
	mov	al, ch
	out	dx, al
	mov	ax, VIKING_AMOVE
	OUT_DX_AHAL
	mov	ax, gl_destxorg2
	OUT_DX_AHAL
	mov	bx, SCREEN_HEIGHT-1
	sub	bx, gl_destyorg2
	OUT_DX_BHBL
	mov	bx, bp2a
	or	bx, VIKING_RFRCT
	OUT_DX_BHBL
	mov	ax, gl_xext2
	dec	ax
	OUT_DX_AHAL
	mov	ax, gl_yext2
	dec	ax
	neg	ax
	OUT_DX_AHAL
	ret

vik_rectfill	endp

vik_sscopy:
	mov	ds, cs:_cstods
	mov	bx, gl_srcxorg
	mov	cx, gl_destxorg
	and	bl, 0Fh
	and	cl, 0Fh
	cmp	bl, cl
	jnz	vik_sscopy_2
	push	dx
	mov	dx, gl_xext
	mov	ax, gl_yext
	mul	dx
	mov	bx, dx
	pop	dx
	sub	bx, 1
	jnc	vik_sscopy_1
	cmp	ax, 32h
	jle	vik_sscopy_2
vik_sscopy_1:
	jmp	vik_sscopy_10
;
vik_sscopy_2:
	mov	bx, offset agcpy_buf
	mov	al, bp41
	sub	al, 1
	jnc	vik_sscopy_3
	jmp	vik_sscopy_6
;
vik_sscopy_3:
	jnz	vik_sscopy_4
	jmp	vik_sscopy_7
;
vik_sscopy_4:
	dec	al
	jnz	vik_sscopy_5
	jmp	vik_sscopy_8
;
vik_sscopy_5:
	mov	ax, VIKING_AGCPY + 300h
	or	ax, blitparams
	mov	[bx+8], ax
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, gl_destyorg
	mov	[bx+6], ax
	mov	ax, gl_destxorg
	add	ax, gl_xext
	dec	ax
	mov	[bx+4], ax
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, gl_srcyorg
	mov	[bx+0Ch], ax
	mov	ax, gl_srcxorg
	add	ax, gl_xext
	dec	ax
	mov	[bx+0Ah], ax
	mov	ax, gl_yext
	dec	ax
	neg	ax
	mov	[bx+10h], ax
	mov	ax, gl_xext
	dec	ax
	neg	ax
	mov	[bx+0Eh], ax
	jmp	vik_sscopy_9
;
vik_sscopy_6:
	mov	ax, VIKING_AGCPY
	or	ax, blitparams
	mov	[bx+8], ax
	mov	ax, SCREEN_HEIGHT-1
	mov	cx, gl_destyorg
	add	cx, gl_yext
	dec	cx
	sub	ax, cx
	mov	[bx+6], ax
	mov	ax, gl_destxorg
	mov	[bx+4], ax
	mov	ax, SCREEN_HEIGHT-1
	mov	cx, gl_srcyorg
	add	cx, gl_yext
	dec	cx
	sub	ax, cx
	mov	[bx+0Ch], ax
	mov	ax, gl_srcxorg
	mov	[bx+0Ah], ax
	mov	ax, gl_yext
	dec	ax
	mov	[bx+10h], ax
	mov	ax, gl_xext
	dec	ax
	mov	[bx+0Eh], ax
	jmp	vik_sscopy_9  
;
vik_sscopy_7:	
	mov	ax, VIKING_AGCPY + 100h
	or	ax, blitparams
	mov	[bx+8], ax
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, gl_destyorg
	mov	[bx+6], ax
	mov	ax, gl_destxorg
	mov	[bx+4], ax
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, gl_srcyorg
	mov	[bx+12], ax
	mov	ax, gl_srcxorg
	mov	[bx+10], ax
	mov	ax, gl_yext
	dec	ax
	neg	ax
	mov	[bx+16], ax
	mov	ax, gl_xext
	dec	ax
	mov	[bx+14], ax
	jmp	vik_sscopy_9
;
vik_sscopy_8:
	mov	ax, VIKING_AGCPY + 200h
	or	ax, blitparams
	mov	[bx+8], ax
	mov	ax, SCREEN_HEIGHT - 1
	mov	cx, gl_destyorg
	add	cx, gl_yext
	dec	cx
	sub	ax, cx
	mov	[bx+6], ax
	mov	ax, gl_destxorg
	add	ax, gl_xext
	dec	ax
	mov	[bx+4], ax
	mov	ax, SCREEN_HEIGHT - 1
	mov	cx, gl_srcyorg
	add	cx, gl_yext
	dec	cx
	sub	ax, cx
	mov	[bx+12], ax
	mov	ax, gl_srcxorg
	add	ax, gl_xext
	dec	ax
	mov	[bx+10], ax
	mov	ax, gl_yext
	dec	ax
	mov	[bx+16], ax
	mov	ax, gl_xext
	dec	ax
	neg	ax
	mov	[bx+14], ax
vik_sscopy_9:
	call	viking_flush
	call	writeblk
	ret
;
vik_sscopy_10:	
	mov	bx, offset cpy_buf
	mov	ax, gl_yext
	dec	ax
	test	bp41, 1
	jz	vik_sscopy_11
	neg	ax
vik_sscopy_11:
	mov	[bx+0Ah], ax
	mov	ax, gl_destyorg
	test	bp41, 1
	jnz	vik_sscopy_13
vik_sscopy_12:
	add	ax, gl_yext
	dec	ax
vik_sscopy_13:
	mov	gl_destyorg2, ax
	mov	ax, gl_srcyorg
	test	bp41, 1
	jnz	vik_sscopy_14
	add	ax, gl_yext
	dec	ax
vik_sscopy_14:
	mov	gl_srcyorg2, ax
	mov	ax, gl_destxorg
	mov	gl_destxorg2, ax
	mov	ax, gl_srcxorg
	mov	gl_srcxorg2, ax
	test	bp41, 2
	jz	vik_sscopy_15
	jmp	vik_sscopy_22
;
vik_sscopy_15:
	mov	ax, VIKING_SCPY + 100h
	test	bp41, 1
	jnz	vik_sscopy_16
	mov	ax, VIKING_SCPY
vik_sscopy_16:
	or	ax, blitparams
	mov	[bx+2], ax
	mov	cx, gl_destxorg
	and	cx, wptr 0Fh
	mov	ax, gl_xext
	add	ax, cx
	dec	ax
	test	ax, 0FFF0h
	jnz	vik_sscopy_17
	mov	ax, 0FFFFh
	mov	bl, cl
	shl	ax, cl
	mov	cx, gl_xext
	and	cl, 0Fh
	rol	ax, cl
	add	cl, bl
	neg	cl
	and	cl, wptr 0Fh
	shl	ax, cl
	jmp	vik_sscopy_20
;
vik_sscopy_17:
	test	gl_destxorg, 0Fh
	jz	vik_sscopy_18
	call	viking_flush
	mov	ax, 0FFFFh
	shr	ax, cl
	call	calc_destaddr
	mov	bx, offset cpy_buf
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	mov	word ptr [bx+8], 0
	call	viking_flush
	call	writeblk
	mov	ax, gl_destxorg
	and	ax, 0FFF0h
	add	ax, 10h
	mov	gl_destxorg2, ax
	mov	ax, gl_srcxorg
	and	ax, 0FFF0h
	add	ax, 10h
	mov	gl_srcxorg2, ax
vik_sscopy_18:
	mov	cx, gl_destxorg
	and	cx, wptr 0Fh
	mov	ax, 10h
	sub	ax, cx
	and	ax, 0Fh
	neg	ax
	add	ax, gl_xext
	mov	cl, 4
	shr	ax, cl
	jz	vik_sscopy_19
	mov	bx, offset cpy_buf
	dec	ax
	mov	[bx+8], ax
	call	viking_flush
	push	bx
	mov	ax, 0FFFFh
	call	calc_destaddr
	pop	bx
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	call	viking_flush
	call	writeblk
	mov	ax, gl_srcxorg
	add	ax, gl_xext
	and	ax, 0FFF0h
	mov	gl_srcxorg2, ax
	mov	cx, gl_destxorg
	add	cx, gl_xext
;;;	and	cx, 0FFF0h
	dw	0E181h
	dw	0FFF0h
	mov	gl_destxorg2, cx
vik_sscopy_19:
	mov	cx, gl_destxorg
	add	cx, gl_xext
	and	cl, 0Fh
	jz	vik_sscopy_21
	mov	ax, 0FFFFh
	shr	ax, cl
	xor	ax, 0FFFFh
vik_sscopy_20:
	push	ax
	call	viking_flush
	pop	ax
	call	calc_destaddr
	mov	bx, offset cpy_buf
	mov	word ptr [bx+8],0
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	call	viking_flush
	call	writeblk
vik_sscopy_21:
	ret
;
vik_sscopy_22:
	mov	ax, VIKING_SCPY + 300h
	test	bp41, 1
	jnz	vik_sscopy_23
	mov	ax, VIKING_SCPY + 200h
vik_sscopy_23:
	or	ax, blitparams
	mov	[bx+2], ax
	mov	cx, gl_destxorg
	and	cx, wptr 0Fh
	mov	ax, gl_xext
	add	ax, cx
	dec	ax
	test	ax, 0FFF0h
	jnz	vik_sscopy_24
	mov	ax, 0FFFFh
	mov	bl, cl
	shl	ax, cl
	mov	cx, gl_xext
	and	cl, 0Fh
	rol	ax, cl
	add	cl, bl
	neg	cl
	and	cl, 0Fh
	shl	ax, cl
	jmp	vik_sscopy_27
;
vik_sscopy_24:
	mov	ax, gl_srcxorg
	add	ax, gl_xext
	dec	ax
	mov	gl_srcxorg2, ax
	mov	cx, gl_destxorg
	add	cx, gl_xext
	mov	gl_destxorg2, cx
	dec	cx
	test	cx, 0Fh
	jz	vik_sscopy_25
	call	viking_flush
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shr	ax, cl
	xor	ax, 0FFFFh
	call	calc_destaddr
	mov	bx, offset cpy_buf
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	mov	word ptr [bx+8], 0
	call	viking_flush
	call	writeblk
	sub	gl_destxorg2, 10h
	sub	gl_srcxorg2, 10h	
vik_sscopy_25:
	mov	ax, gl_destxorg
	add	ax, gl_xext
	and	ax, 0Fh
	neg	ax
	add	ax, gl_xext
	mov	cl, 4
	shr	ax, cl
	jz	vik_sscopy_26
	mov	bx, offset cpy_buf
	dec	ax
	neg	ax
	mov	[bx+8], ax
	call	viking_flush	
	push	bx
	mov	ax, 0FFFFh
	call	calc_destaddr
	pop	bx
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	call	viking_flush
	call	writeblk
	test	gl_destxorg, 0Fh
	jnz	vik_sscopy_26
	ret
;
vik_sscopy_26:
	mov	ax, gl_destxorg
	mov	gl_destxorg2, ax
	mov	ax, gl_srcxorg
	mov	gl_srcxorg2, ax
	mov	cx, gl_destxorg
	and	cl, 0Fh
	mov	ax, 0FFFFh
	shr	ax, cl
vik_sscopy_27:
	push	ax
	call	viking_flush
	pop	ax
	call	calc_destaddr
	mov	bx, offset cpy_buf
	mov	word ptr [bx+8], 0
	call	calc_srcoffset
	mov	[bx+4], ax
	mov	[bx+6], cx
	call	viking_flush
	call	writeblk
	ret

sEnd	Code
	end
