	
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	STRBLT.ASM
;
;   This module contains the strblt function and the ExtendedTextOut
;   function.
;
; Created: 17-Mar-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Strblt
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


FIXED_PITCH_ON = 1			;en/disables smartfix code


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.	?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.


?CHKSTK = 1
?CHKSTKPROC	macro
		endm


	.xlist
	include cmacros.inc
incFont 	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include control for gdidefs.inc
	include gdidefs.inc
	include display.inc
	include vikingi.inc
	include macros.mac
	include strblt.inc
	include fontseg.inc
	.list


	??_out	strblt


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_WIDTH		;Screen width in pixels
	externA COLOR_FORMAT		;Color format (0103h or 0104h)

	externNP busy_xflush
	externB	bus_width
	externB	mirror_byte
	externNP viking_flush
	externNP viking_xflush
	externNP mkbusy
	externNP endbusy

;	Other functions required for strblt.

ifdef	 EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


sBegin	Code
assumes cs,Code
page
;--------------------------Exported-Routine-----------------------------;
; Strblt
;
; This is the old strblt entry point.  Null parameters are pushed
; for the ExtTextOut's extra parameters, and control given to
; ExtTextOut.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX = Y extent of string if extent call
;	AX = X extent of string if extent call
;	EGA registers in default state
; Error Returns:
;	DX:AX = 8000:0000H
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	See ExtTextOut
; History:
;	Thu 09-Apr-1987 13:36:08 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing
;
; WIN1 In Windows 1, STRBLT now becomes live!
;
cProc	Strblt,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;[bp+20h] Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

;	ExtTextOut parameters we have to dummy up.
;
;	parmD	lp_dx			;Widths for the characters
;	parmD	lp_opaque_rect		;Opaquing rectangle
;	parmW	eto_options		;ExtTextOut options

	localW	bp4
	localW	abs_count		;[bp-6] WIN1
	localW 	local_str		;[bp-8] WIN1
	localW	next_scan		;[bp-0a] Index to get to next scan line
	localW	y_step			;[bp-0c] Y step
	localW  gl_bitmap_type		;[bp-0e] Bitmap type
	localW	gl_bitmap_h		;[bp-10] Bitmap height -1
	localW	colors			;[bp-12] Text/background colors
	localW	draw_func		;[bp-14]
	localW	opaque_routine		;[bp-16] Routine which does actual opaquing
	localW	draw_func2		;[bp-18]
	localW	next_plane		;[bp-1a] Index to get to next plane
	localW	fontw_bytes		;[bp-1c] Source font width (bytes)
	localW	opaque_height		;[bp-1e] Height of opaque box (sometimes)
	localW	clip_left		;[bp-20] WIN1
	localW	clip_right		;[bp-22] WIN1
	localW	temp_off_lp_bits	;[bp-24] Intermediate pointer to dev surface
	localW	scan_start		;[bp-26] Delta from start of scan
	localW	clipped_font_height	;[bp-28] Actual height of bits to be drawn
	localW	df_pixel_w		;[bp-2a] WIN1 font pixel width
	localW	brk_extra		;[bp-2c] # extra pixels to add each break char
	localW	brk_err 		;[bp-2e] Justification DDA error term
	localW	brk_rem 		;[bp-30] extra pixels are distributed
	localW	brk_count		;[bp-32] DDA - # breaks into which BrkRem
	localW	char_xtra		;[bp-34]# extra pixels to add each char
	localW	bp36
	localW	gl_device
	localV	gl_code,102h

cBegin
	if	???			;Do test only if locals
	jc	j_exit_strblt		;No room for locals, return now
	endif

	mov	ax, count
	cwd
	xor	ax,dx			;Force positive
	shl	ax, 1			;Check that there's room on the stack
	shl	ax, 1			;for the string
	add	ax, 20h			;at 4 bytes / character + 32 overhead
	mov	cx, ax
	call	my_check_stack
	jnc	strblt_01
j_exit_strblt:
	jmp	exit_strblt
;
strblt_01:
	add	sp, cx
	mov	local_str, sp	
	lds	si, lp_clip_rect
	les	di, lp_font
	
;;;	mov	al,enabled_flag 	;Save enabled_flag incase we need it
;;;	mov	local_enabled_flag,al

;;;	call	get_mode		;Get data from drawmode, set flags
;;;	call	get_font		;Get font data (aborts if invalid)


;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	xor	dx,dx
	mov	ax,count
	or	ax,ax
	jz	j_only_draw		;No chars, might have opaque rect
	jg	strblt_02		;Positive count, output string
	neg	ax
	xor	bx, bx
	mov	word ptr lp_clip_rect, bx
strblt_02:
	mov	abs_count, ax
	mov	cx, es:[di].dfWidthBytes
	mov	fontw_bytes, cx
	mov	ax, es:[di].dfPixWidth
	mov	df_pixel_w, ax
	or	si, si			;Clip rectangle present?
	jz	strblt_05
	mov	ax, [si].top
	mov	dx, ax
	sub	ax, y
	mov	bx, ax
	jge	strblt_03
	sub	dx, bx
	xor	bx, bx
strblt_03:
	mov	temp_off_lp_bits,dx
	mov	scan_start,dx
	mov	dx, es:[di].dfPixHeight
	cmp	bx, dx
	jge	j_only_draw
	mov	ax, [si].bottom
	sub	ax, y
	cmp	ax, dx
	jl	strblt_04
	mov	ax, dx
strblt_04:
	or	ax, ax
	jle	j_only_draw
	cmp	ax, bx
	jle	j_only_draw
	jmp	short strblt_06
	nop

j_only_draw:
	jmp	only_draw


strblt_05:
	mov	bx, y
	mov	temp_off_lp_bits,bx
	mov	scan_start,bx
	xor	bx, bx
	mov	ax, es:[di].dfPixHeight
strblt_06:
	sub	ax, bx
	mov	clipped_font_height,ax
	add	scan_start, ax
	add	ax, bx
	mul	cx
	mov	dx,wptr es:[di].dfBitsPointer
	add	ax, dx
	dec	ax
	mov	opaque_height, ax
	mov	ax, bx
	mov	si, bx
	mov	bx, dx
	mul	cx
	add	ax, bx
	dec	ax
	mov	next_plane,ax
	mov	ax, si
	lds	si, lp_draw_mode
	mov	brk_err, 0
	cmp	word ptr es:[di].dfPixWidth, 0
	jz	strblt_08
	mov	dx, offset X152D
	mov	wptr opaque_routine,dx		
	cmp	[si].TBreakExtra,0
	jz	strblt_07
	mov	dx, offset X1553
	mov	wptr opaque_routine,dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_07:
	mov	dx, [si].CharExtra
	mov	si, offset X1511
	or	dx, dx
	jz	strblt_10
	mov	si, offset X150B
	mov	char_xtra,dx
	xor	dx, dx
	mov	df_pixel_w, dx
	jmp	short strblt_10
	nop
;
strblt_08:
	mov	dx, offset X158E
	mov	wptr opaque_routine, dx
	cmp	[si].TBreakExtra, 0
	jz	strblt_09
	mov	dx, offset X153F
	mov	wptr opaque_routine, dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_09:	
	mov	dx, [si].CharExtra
	mov	si, offset X1576
	or	dx, dx
	jz	strblt_10
	mov	si, offset X1570
	mov	char_xtra, dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_10:
	mov	draw_func, si
	xor	si, offset X15AF
	mov	draw_func2, si		;XXX
	lds	si, lp_device
	mov	dx, [si].bmHeight
	dec	dx
	mov	gl_bitmap_h, dx
	mov	dx, [si].bmType
	mov	gl_bitmap_type, dx
	mov	dx, [si].bmWidthBytes
	mov	y_step, dx
	add	ax, y
	mul	dx
	cmp	gl_bitmap_type, 0
	jnz	strblt_101
	push	cx
	push	si
	push	ds
	lds	si, lp_device
	lds	si, [si].bmBits
	mov	cx, ds
	rol	cx, 1
	rol	cx, 1
	rol	cx, 1
	rol	cx, 1
	mov	bx, cx
	and	bx, wptr 0Fh	;Segment offset
;;	and	cx, wptr 0FFF0h	;Byte offset
	dw	0E181h		;AND CX, word
	dw	0FFF0h
	add	si, cx
	adc	bx, 0
	add	ax, si
	adc	dx, bx
	mov	cl, 4
	ror	dx, cl
	and	dx, 0F000h
	mov	bx, ax
	shr	bx, cl
	and	bx, 0FFFh
	or	dx, bx
	and	ax, 0Fh
	mov	bp36, dx
	pop	ds
	pop	si
	pop	cx

strblt_101:
	lds	si, lp_clip_rect
	mov	bx, x
	or	si, si
	jz	strblt_15
	mov	cx, [si].left
	mov	clip_left, cx
	mov	di, bx
	mov	dx, [si].right
	mov	clip_right, dx
	sub	dx, cx
	sub	bx, cx
	jl	strblt_11
	mov	clip_left, di
	mov	cx, di
	sub	dx, bx
	xor	bx, bx
strblt_11:
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di		;XXX
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	add	ax, cx
	mov	next_scan, ax	;XXX
	cmp	bx, dx
	jge	j2_only_draw
	lds	si, lp_string
	les	di, lp_font
strblt_12:
	call	word ptr draw_func
	jle	strblt_12
	or	ax, ax
	jz	strblt_14
	add	ax, cx
	sub	ax, bx
	mov	cx, bx
	sub	bx, dx
strblt_13:
	jge	strblt_21
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	call	word ptr draw_func
	jmp	short strblt_13
;
strblt_14:
	add	ax, cx
	sub	ax, bx
	and	ax, 7
	mov	cx, bx
	sub	bx, dx
	jmp	short strblt_13
;
strblt_15:
	mov	clip_left, bx
	mov	clip_right, bx
	mov	cx, bx
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	;XXX
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	add	ax, bx
	mov	next_scan, ax	;XXX
	lds	si, lp_string
	les	di, lp_font
	xor	bx, bx
strblt_16:
	call	word ptr draw_func
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	jmp	short strblt_16
;
j2_only_draw:	
	jmp	only_draw

strblt_20:
	pop	dx
	pop	si
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	push	si
	push	dx
	jmp	short strblt_23
	nop
;
strblt_21:
	sub	cx, bx
	jle	strblt_22
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
strblt_22:
	cmp	sp, local_str
	jz	j2_only_draw
	cmp	df_pixel_w, 8
	jz	strblt_20
strblt_23:
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
;;;	mov	cx, count
;;;	or	cx, cx
;;;	jg	strblt_25
;;;	mov	cx, brk_err
;;;	jcxz	strblt_24
;;;	lds	si, lp_draw_mode
;;;	mov	[si].BreakErr, ax
strblt_24:
;;;	mov	ax, clip_right
;;;	sub	ax, clip_left
;;;	mov	dx, scan_start
;;;	sub	dx, temp_off_lp_bits
;;;	jmp	only_draw
;
strblt_25:
	cmp	gl_bitmap_type, 0
	jz	strblt_27
	mov	cx, count
	or	cx, cx
	jl	strblt_27
	mov	cx, clip_left
	mov	dx, temp_off_lp_bits
	mov	si, clip_right
	mov	di, scan_start
	call	exclude
strblt_26:	
strblt_27:
;;;	mov	ax, [si].BreakExtra
;;;	cmp	word ptr [si].TextColor, 103h
	lds	si, lp_draw_mode
	mov	ax, count
	or	ax, ax
	jg	strblt_29
	mov	ax, brk_err
	or	ax, ax
	jz	strblt_28
	mov	[si].BreakErr, ax
;
strblt_28:
	mov	ax, clip_right
	sub	ax, clip_left
	mov	dx, scan_start
	sub	dx, temp_off_lp_bits
	jmp	only_draw

strblt_29:
	cmp	gl_bitmap_type, 0
	jnz	strblt_129
	jmp	strblt_229
;
; Screen version 
;
strblt_129:
	cmp	word ptr [si].bkMode, 1
	jnz	strblt_130
	mov	al,[si].TextColor
	and	ax, 1
	add	ax, 1
	xor	ax, 3
	mov	colors, ax
	jmp	strblt_38
;
strblt_130:
	mov	al,[si].bkColor
	cmp	al,[si].TextColor
	jz	strblt_131
	mov	colors, 0
	jmp	strblt_38 
;
strblt_131:
	xor	bx, bx
	cmp	al, 1
	sbb	bx, bx
; 	xor	bx, wptr 0FFFFh
	dw	0F381h
	dw	-1
	call	busy_xflush
	test	cs:bus_width, 1
	jz	strblt_132
	mov	ax, VIKING_WPR + VIKING_CL1
	out	dx, ax
	mov	ax, bx	;Write BX to colour 1
	out	dx, ax	
	mov	ax, VIKING_AMOVE
	out	dx, ax
	mov	ax, clip_left	
	out	dx, ax
	mov	ax, gl_bitmap_h
	sub	ax, temp_off_lp_bits
	out	dx, ax
	call	viking_flush
	mov	ax, VIKING_AFRCT
	out	dx, ax
	mov	ax, clip_right	
	out	dx, ax
	mov	ax, gl_bitmap_h
	sub	ax, scan_start
	out	dx, ax
	mov	ax, VIKING_WPR + VIKING_CL1
	out	dx, ax
	mov	ax, -1
	out	dx, ax
	call	endbusy
	jmp	only_draw
;
strblt_132:
	mov	ax, VIKING_WPR + VIKING_CL1
	OUT_DX_AHAL
	mov	al, bh	;Write BX to colour 1
	out	dx, al
	mov	al, bl	;Write BX to colour 1
	out	dx, al
	mov	ax, VIKING_AMOVE
	OUT_DX_AHAL
	mov	ax, clip_left	
	OUT_DX_AHAL
	mov	ax, gl_bitmap_h
	sub	ax, temp_off_lp_bits
	OUT_DX_AHAL
	call	viking_flush
	mov	ax, VIKING_AFRCT
	OUT_DX_AHAL
	mov	ax, clip_right	
	OUT_DX_AHAL
	mov	ax, gl_bitmap_h
	sub	ax, scan_start
	OUT_DX_AHAL
	mov	ax, VIKING_WPR + VIKING_CL1
	OUT_DX_AHAL
	mov	al, -1
	out	dx, al
	out	dx, al
	call	endbusy
	jmp	only_draw
;
; Memory bitmap version of strblt_129
;
strblt_229:
	cmp	word ptr [si].bkMode, 1
	jnz	strblt_30
	jmp	strblt_38
strblt_30:
	mov	al,[si].bkColor
	xor	ah,ah
	mov	si,ax
	mov	cx, clip_left
	mov	ax, cx
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	dl, 0FFh
	and	cx, word ptr 7
	shr	dl, cl		;Left fringe
	mov	cx, clip_right
	dec	cx
	mov	bx, cx
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	mov	dh, 0FFh
	and	cx, word ptr 7
	sub	cx, 7
	neg	cx
	shl	dh, cl		;Right fringe
	inc	ax
	sub	bx, ax
	jge	strblt_31
	and	dl, dh	;Left fringe = right fringe
strblt_31:	
	mov	cx, bx
	mov	clip_left, cx
	les	di, dword ptr gl_device
;;; but this doesn't happen?	les	di, es:[di].bmBits
	mov	di, next_scan	
	mov	bx, y_step
	mov	al, 0FFh
	or	si, si
	jnz	strblt_35
	not	al
	not	dx
strblt_32:
	mov	si, di
	and	es:[di], dl
	inc	di
	or	cx, cx
	jl	strblt_34
	jz	strblt_33
	rep	stosb
strblt_33:
	and	es:[di],dh
strblt_34:
	mov	di,si
	add	di,bx
	jnc	strblt_34a
	mov	cx, es
	add	cx, 1000h
	mov	es, cx
strblt_34a:
	mov	cx, clip_left
	dec	wptr clipped_font_height
	jg	strblt_32
	jmp 	short strblt_38
	nop
;
strblt_35:
	mov	si, di
	or	es:[di], dl
	inc	di
	or	cx,cx
	jl	strblt_37
	jz	strblt_36
	rep	stosb
strblt_36:
	or	es:[di],dh
strblt_37:
	mov	di,si
	add	di,bx
	jnc	strblt_37a
	mov	cx, es
	add	cx, 1000h
	mov	es, cx
strblt_37a:
	mov	cx,clip_left
	dec	wptr clipped_font_height
	jg	strblt_35
strblt_38:
	xor	dx,dx
	lds	si, lp_draw_mode
	cmp	bptr [si].TextColor,1
	sbb	dl, dl
	cmp	gl_bitmap_type, 0
	jz	strblt_38a
	jmp	strblt_138

strblt_38a:
	lds	si, lp_font
	lds	si, [si].dfBitsPointer
	les	di, dword ptr gl_device	
; XXX	les	di, es:[di].bmBits
	mov	di, next_scan
	jmp	strblt_52
;
strblt_39:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	mov	dh, es:[di]
	xor	dh, dl
	or	ah, dh
	xor	ah, dl
	xchg	ah, al
	stosb
	xchg	ah, al
	mov	dh, 8
	neg	cl
	jz	strblt_45
strblt_44:
	sub	dh, cl
	jle	strblt_39
	shl	ax, cl
strblt_45:
	cmp	ch, 8
	ja	strblt_47
	or	ch, ch
	jz	strblt_49
	xor	al, al
	or	si, si
	jz	strblt_46
	lodsb
strblt_46:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_47:
	xor	al, al
	or	si, si
	jz	strblt_48
	lodsb
strblt_48:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_44
strblt_49:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al, al
	or	si, si
	jz	strblt_50
	add	si, next_plane
	lodsb
strblt_50:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_44
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_51:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	mov	al, es:[di]
	xor	al, dl
	or	al, ah
	xor	al, dl
	stosb
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_53
	mov	next_plane, si
	mov	di, next_scan
	add	di, y_step
	mov	next_scan, di
	jnc	strblt_52
	mov	bx, es
	add	bx, 1000h
	mov	es, bx
strblt_52:
	mov	bx, local_str
	xor	ax, ax
	mov	dh, bptr bp4	;XXX
	cmp	df_pixel_w, 8
	jz	strblt_54
	jmp	short strblt_49
;
strblt_53:
	jmp	only_draw

strblt_54:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl		;Right fringe
	cmp	dh, cl
	jg	strblt_55
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_59
	mov	cl, 8
	jmp	short strblt_57
	nop
;
strblt_55:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_60
	nop

strblt_56:
;;	add	si, next_plane
	lodsb
strblt_57:
	mov	dh, es:[di]
	xor	dh, dl
	or	al, dh
	xor	al, dl
	stosb
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	jmp	short strblt_56
;
strblt_58:
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_59:
	neg	cl
	mov	dh, es:[di]
	xor	dh, dl
	or	al, dh
	xor	al, dl
	stosb
	rol	ax, cl
	sub	cl, 8
strblt_60:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si,next_plane
	jmp	short strblt_58

strblt_61:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_49
;
strblt_138:
	call	mkbusy
	mov	y_step, 0
	lds	si,lp_font
	lds	si, [si].dfBitsPointer
	mov	ax, ss
	mov	es, ax
	lea	di, [bp-13Ah]
	inc	di
;;;	and	di, wptr 0FFFEh	;Word-align the code we're about to generate
	dw	0E781h
	dw	0FFFEh
	mov	next_scan, di
	jmp	strblt_154	
;
strblt_139:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	xchg	ah, al
	xor	al, dl
	stosb
	xchg	ah, al
	mov	dh, 8
	neg	cl
	jz	strblt_141
strblt_140:
	sub	dh, cl
	jle	strblt_139
	shl	ax, cl
strblt_141:
	cmp	ch, 8
	ja	strblt_143
	or	ch, ch
	jz	strblt_145
	xor	al, al
	or	si, si
	jz	strblt_142
	lodsb
strblt_142:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_140
;
strblt_143:
	xor	al, al
	or	si, si
	jz	strblt_144
	lodsb
strblt_144:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_140
;
strblt_145:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_147
	xor	al, al
	or	si, si
	jz	strblt_146
	add	si, next_plane
	lodsb
strblt_146:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_140
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_140
;
strblt_147:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	mov	al, ah
	xor	al, dl
	stosb
	push	dx
	mov	ax, ds
	mov	es, ax
	mov	ax, ss
	mov	ds, ax
	mov	si, next_scan
	mov	cx, di
	sub	cx, si
	inc	cx
	shr	cx, 1
	call	viking_xflush
	test	cs:bus_width, 1
	jz	strblt_150
	WPR16	VIKING_RWP0, 1Fh
	WPR16	VIKING_RWP1, 4000h
	call	viking_flush
	mov	bx, offset mirror_byte
	mov	di, VIKING_WT
	jmp	short strblt_149
;
	nop
strblt_148:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	strblt_148
strblt_149:
	mov	ax, di
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	loop	strblt_148
	mov	ax, VIKING_AMOVE
	out	dx, ax
	mov	ax, clip_left
	out	dx, ax
	mov	ax, gl_bitmap_h
	sub	ax, temp_off_lp_bits
	sub	ax, y_step
	out	dx, ax
	call	viking_flush
	mov	ax, colors
	or	ax, VIKING_AGCPY
	out	dx, ax
	mov	ax, 8
	sub	ax, bp4
	out	dx, ax
	mov	ax, 0FFD7h
	out	dx, ax
	mov	ax, clip_right
	sub	ax, clip_left
	out	dx, ax
	xor	ax, ax	
	out	dx, ax
	jmp	strblt_153
;
strblt_150:
	WPR8	VIKING_RWP0, 1Fh
	WPR8	VIKING_RWP1, 4000h
	call	viking_flush
	mov	bx, offset mirror_byte
	mov	di, VIKING_WT
	jmp	short strblt_152
;
	nop
strblt_151:
	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	strblt_151
strblt_152:
	mov	ax, di
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	loop	strblt_151
	mov	ax, VIKING_AMOVE
	OUT_DX_AHAL
	mov	ax, clip_left
	OUT_DX_AHAL
	mov	ax, gl_bitmap_h
	sub	ax, temp_off_lp_bits
	sub	ax, y_step
	OUT_DX_AHAL
	call	viking_flush
	mov	ax, colors
	or	ax, VIKING_AGCPY
	OUT_DX_AHAL
	mov	ax, 8
	sub	ax, bp4
	OUT_DX_AHAL
	mov	ax, 0FFD7h
	OUT_DX_AHAL
	mov	ax, clip_right
	sub	ax, clip_left
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
strblt_153:
	mov	ax, es
	mov	ds, ax
	mov	ax, ss
	mov	es, ax
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_155
	mov	next_plane, si
	inc	y_step
	mov	di, next_scan
	pop	dx
strblt_154:
	mov	bx, local_str
	xor	ax, ax
	mov	dh, bp4
	cmp	df_pixel_w, 8
	jz	strblt_156
	jmp	strblt_145
;
strblt_155:
	call	endbusy
	jmp	short	only_draw
	nop
;
strblt_156:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_163
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl
	cmp	dh, cl
	jg	strblt_157
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_161
	mov	cl, 8
	jmp	short strblt_159
;
	nop
strblt_157:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_162
;
	nop
strblt_158:
	lodsb
strblt_159:
	xor	al, dl
	stosb
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_163
	add	si, next_plane
	jmp	short strblt_158
;
strblt_160:
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_161:
	neg	cl
	xor	al, dl
	stosb
	rol	ax, cl
	sub	cl, 8
strblt_162:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_163
	add	si, next_plane
	jmp	short strblt_160
;
strblt_163:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_145
;
only_draw:
	mov	sp, local_str
	call	unexclude
exit_strblt:

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Eh
	page
;

X1505:	mov	al, es:[di].dfDefaultChar
	jmp	short X1523
	nop
;
X150B:	mov	cx,draw_func2
	xor	draw_func,cx
X1511:	lodsb
	dec	abs_count
	jl	X1535
	cmp	al, es:[di].dfLastChar
	ja	X1505
	sub	al, es:[di].dfFirstChar
	jb	X1505
X1523:	mov	cx, es:[di].dfPixWidth
	cmp	al, es:[di].dfBreakChar
	jz	X153C
X152D:	mul	cl
	add	ax, 8
	add	bx, cx
	ret
;
X1535:	add	clip_right, bx
	pop	ax
	jmp	strblt_22
;
X153C:	jmp	wptr opaque_routine
;
X153F:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	pop	bx
	jz	X1576
X1553:	add	cx, brk_extra
	mov	ax, brk_err
	sub	ax, brk_rem
	jg	X1562
	add	ax, brk_count
	inc	cx
X1562:	mov	brk_err, ax
	xor	ax, ax
	add	bx, cx
	ret
;
X156A:	mov	al, es:[di].dfDefaultChar
	jmp	short X1588
	nop

X1570:	mov	cx, draw_func2
	xor	draw_func, cx
X1576:	lodsb
	dec	abs_count
	jl	X15A8
	cmp	al, es:[di].dfLastChar
	ja	X156A
	sub	al, es:[di].dfFirstChar
	jc	X156A
X1588:	cmp	al, es:[di].dfBreakChar
	jz	X153C
X158E:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	add	ax, 8
	pop	bx
	jz	X1576
	add	bx, cx
	ret

X15A8:
	add	clip_right, bx
	pop	ax
	jmp	strblt_22

X15AF:
	mov	cx, draw_func2
	xor	draw_func, cx
	mov	cx, char_xtra
	xor	ax, ax
	add	bx, cx
	ret

sEnd	Code
	end
