        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	SCANLR.ASM
;
;   This module contains the ScanLR routine.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	ScanLR
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   ScanLR is used to search a scanline for a pixel of the given
;   color or one which isn't of the given color.  This is usually
;   used by the floodfill simulation.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDrawMode	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include vikingi.inc
	include macros.mac
	.list


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_WIDTH		;Screen width in pixels
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_HEIGHT		;Screen height in scans
	externA COLOR_FORMAT		;Color format (0103h or 0104h)


ifdef	EXCLUSION
	externNP  exclude		;Exclude area from screen
	externNP  unexclude		;Clear excluded area
endif
	externNP	endbusy
	externNP	busy_xflush
	externNP	flush_0_abort
	externNP	viking_waitread
	externB		bus_width
	externNP	viking_flush

;	Define the flag values which control the direction
;	and type of the scan.

STEP_LEFT	equ	00000010b	;Flag values for DirStyle
STEP_RIGHT	equ	00000000b
FIND_COLOR	equ	00000001b
FIND_NOT_COLOR	equ	00000000b


;	Define the type flags used to determine which type
;	of scan needs to be performed (color or mono).

COLOR_OP	equ	NUMBER_PLANES
MONO_OP 	equ	1


;	Define the error conditions which will be returned

ERROR_CLIPPED	equ	8000h		;Cooridnate was clipped
ERROR_NOT_FOUND equ	-1		;Stop condition not reached

sBegin	Code
assumes cs,Code

	externB rot_bit_tbl
page

;--------------------------Exported-Routine-----------------------------;
; ScanLR
;
;   ScanLR - Scan left or right
;
;   Starting at the given pixel and proceeding in the choosen direction,
;   the pixels are examined for the given color until one is found that
;   matches (or doesn't match depending on the style).  The X coordinate
;   is returned for the pixel that matched (or didn't match).
;
;   The physical device may be the screen, a monochrome bitmap, or a
;   bitmap in our color format.
;
;   There will be no error checking to see if the bitmap is in our
;   color format.  If it isn't, it will be treated as if it were a
;   monochrome bitmap.
;
; Entry:
;	EGA registers in default state
; Returns:
;	AX = x location of sought pixel
; Error Returns:
;	AX = -1 if nothing found
;	AX = 8000h if clipped
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude
;	unexclude
; History:
;	Fri 01-May-1987 12:30:45 -by-  **** ***** [*****]
;	Output to GRAF_CDC for Win386 support.
;
;	Sun 22-Feb-1987 16:29:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing

cProc	ScanLR,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;ptr to a physical device
	parmW	x			;x coordinate of search start
	parmW	y			;y coordinate of search start
	parmD	color			;color for the search
	parmW	dir_style		;control and search style

	localW	gl_bitmap_type
	localW	gl_direction
;;;	localB	planes			;#Planes
;;;	localW	next_plane		;*[bp-6] index to next plane if color

cBegin
;;;	mov	al,enabled_flag 	;Load this before trashing DS
	lds	si,lp_device		;--> physical device
	assumes ds,nothing
	mov	cx,[si].bmType		;Get bitmap type
	mov	gl_bitmap_type, cx
	jcxz	scan_20 		;Device is a memory bitmap
;
;	This is the screen.  Compute and set the exclusion rectangle
;	based on the direction of the search.

ifdef	EXCLUSION
	mov	dx,y			;Set top of exclude area
	mov	di,dx			;Set bottom of exclude area
	mov	si,[si].bmWidth
	dec	si			;Set right
	mov	cx,x			;Assume scanning left to right
	mov	gl_direction, 0
	test	bptr dir_style,STEP_LEFT
	jz	scan_10 		;Scanning left to right
	mov	si,cx
	xor	cx,cx			;Scanning right to left
	mov	gl_direction, 1

scan_10:
	call	exclude			;Exclude the scan from the screen
endif

scan_20:
	cmp	gl_bitmap_type, 0
	jz	scan_30
	jmp	scan_400

scan_30:
	les	di, lp_device
	lds	si, es:[di].bmBits		;Get device bitmap
	mov	ax, y
scan_40:
	mov	di, es:[di].bmWidthBytes	;Get width in bytes
	mul	di
	add	si, ax				;Address of row
	mov	cx, x
scan_80:
	mov	bx,cx
	shiftr	cx,3			;Compute byte offset in scan
	add	si,cx			;DS:SI --> byte with start pixel
	mov	ax,ds			;Will be working off both DS: and ES:
	mov	es,ax
	assumes es,nothing


;	Set cx to be the byte count for searching left.  Must adjust it
;	to include the byte pixel is in.

	inc	cx			;Adjust for partial byte

	mov	ax,wptr color
	mov	dx,wptr dir_style
	shr	dx, 1
	jnc	scan_85
	not	ax
scan_85:

;	Compute the mask for the first byte (the partial byte).  Since
;	the defaults being set up are for searching left, this can be done
;	by getting the rotating bitmask for the pixel and decrementing it,
;	then using the logical NOT of the mask.  The mask will be used
;	for masking the bits to test in the partial (first) byte.
;
;		Bitmask 	  Mask		NotMask
;
;		10000000	01111111	10000000
;		01000000	00111111	11000000
;		00100000	00011111	11100000
;		00010000	00001111	11110000
;		00001000	00000111	11111000
;		00000100	00000011	11111100
;		00000010	00000001	11111110
;		00000001	00000000	11111111


	and	bx,word ptr 00000111B	;Get bit mask for bit
	mov	bl,rot_bit_tbl[bx]	;Assume we're going left.
	dec	bl			;Create mask

;	The assumption has been made that the scan will be right to left.
;	If the scan is left to right, then the first byte mask and the
;	byte count must be adjusted.
;
;	Also set up the correct bias for getting back to the interesting
;	byte for the rep scasb instruction (DI is always updated by one
;	byte too many).


	std				;Assume search left
	shl	dx,1
	dec	dx
	jg	scan_100		;It is left



	page
;	Compute the first byte mask for the first byte for stepping right.
;
;		Current 	  SHL		  INC		  NOT
;
;		01111111	11111110	11111111	00000000
;		00111111	01111110	01111111	10000000
;		00011111	00111110	00111111	11000000
;		00001111	00011110	00011111	11100000
;		00000111	00001110	00001111	11110000
;		00000011	00000110	00000111	11111000
;		00000001	00000010	00000011	11111100
;		00000000	00000000	00000001	11111110


	cld				;Going right, fix up dir flag
	shl	bl,1			;Fix up first bit mask per above
	inc	bl
	not	bl

;	Compute the number of bytes from current position to end of scanline
;	and set adjustment to counter the rep's post increment

	sub	cx,di			;Fix up byte count
	neg	cx
	inc	cx




;	Set the pixel count for the entire scan.  The scanning will actually
;	continue until the end of the scan as given in bmWidthBytes, and
;	the result clipped to bmWidth.

scan_100:
	not	bl			;Need inverse of the first byte mask
	shiftl	di,3			;Set DI = pixel count of entire scan



;	The desired action of the scan is to be able to do a rep scasb
;	over the scanline until either the color is found or not found.
;	Once the stopping condition is found, it has to be possible to
;	determine which bit was the bit that stopped the scan.
;
;	Monochrome notes:
;
;	    The color will be used as an XOR mask.  If the result of
;	    the XOR is zero, then the byte did not contain any bits of
;	    importance, otherwise we made a hit and need to return the
;	    location of it.
;
;	    If searching for the color, the color must be complemented
;	    so that the XOR will set all bits not of the color to zero,
;	    and leave all bits of the color 1's.  If searching for NOT
;	    the color, then the color can be left as is so that all bits
;	    of the color will be set to zero.  The complement also gives
;	    the compare value for the scasb instruction.
;
;
;	Currently:	DS:SI --> bitmap or display
;			ES:SI --> bitmap or display
;			BL = first byte mask
;			CX = byte count
;			DX = direction bias
;			DI = bits/scanline


scan_200:

;	Check the first byte for a hit or miss.

scan_210:
	lodsb				;Get the first byte
	xor	al,ah			;Adjust the color
	and	al,bl			;Mask out the bits that don't count
	jnz	scan_230		;  Hit.  Check it out

	mov	al,ah			;Otherwise restore register for scan
	dec	cx			;Any bytes left to check?
	jz	scan_300		;  No, show not found

	xchg	si,di			;scasb uses ES:DI
	repe	scasb			;Try for a hit or miss
	jz	scan_300		;Scanned off the end, it's a miss
	inc	cx			;Decremented one time too many
	xchg	si,di
	add	si,dx			;Adjust from post increment/decrement
	lodsb				;Get the byte which we hit on
	xor	al,ah			;Adjust to look for a set bit



;	Had a hit.  Find which pixel it was really in.
;
;	Currently:	CX = byte index pixel is in
;			DI = # pixels in the scan line
;			AL = byte hit was in

scan_230:
	shiftl	cx,3			;Convert byte index to pixel index
	or	dx,dx			;Scanning Right to left?
	jg	scan_260		;  yes

scan_240:
	sub	cx,di			;Compute index of first pixel in byte
	neg	cx			;  where hit occured
	dec	cx			;Prepare for loop
;;;	not	cx

scan_250:
	inc	cx			;Show next pixel
	shl	al,1			;Was this the hit?
	jnc	scan_250		;  No, try next
	lds	si, lp_device
	cmp	cx,[si].bmWidth		;Is final x value in range?
	jge	scan_300		;  No, show not found
	jmp	short scan_270		;  Yes, return it

scan_260:
	dec	cx			;Show next pixel
	shr	ax,1			;Was this the hit?
	jnc	scan_260		;  No, try next

scan_270:
	mov	ax,cx			;Return position to caller

scan_280:
	cld


;	If this was for the device, the color read mode must be
;	cleared, both in the register and in the shadow location.
;	The exclusion rectangle must also be cleared.


ifdef	EXCLUSION			;If exclusion
	call	unexclude		;Clear any exclude rectangle
endif


scan_290:

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	0Eh

scan_300:
	mov	ax,ERROR_NOT_FOUND
	jmp	scan_280

scan_400:
	call	busy_xflush
	mov	bx, wptr color
	mov	ax, dir_style
	and	ax, 1
	dec	ax
	xor	bx, ax
	test	cs:bus_width, 1
	jnz	scan_410
	jmp	scan_460
;
scan_410:
	WPR16	VIKING_CL0, bx
	WPR16	VIKING_CL1, bx
	WPR16	VIKING_EDG, bx
	call	viking_flush
	mov	ax, VIKING_WPTN
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	mov	ax, -1
	out	dx, ax
	cmp	gl_direction, 0
	jz	scan_420
	jmp	short scan_440
	nop
;
scan_420:
	call	viking_flush
	WPR16	VIKING_ADR0, x
;	WPR16	VIKING_ADR1, y
	mov	ax, VIKING_WPR OR VIKING_ADR1
	out	dx, ax
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	out	dx, ax
	WPR16	VIKING_ADR2, SCREEN_WIDTH
	mov	ax, VIKING_WPR OR VIKING_ADR3
	out	dx, ax
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	out	dx, ax
	call	viking_flush
	AMOVE16	x, y
	mov	ax, VIKING_WPR OR VIKING_PRC0
	out	dx, ax
	xor	ax, ax
	out	dx, ax
	mov	ax, 0C870h	;XXX
	out	dx, ax
	call	flush_0_abort
	mov	ax, VIKING_RPR OR VIKING_CPX
	out	dx, ax
	call	viking_waitread
	in	ax, dx
	cmp	ax, SCREEN_WIDTH
	jl	scan_430
	mov	ax, -1
scan_430:
	jmp	scan_510

scan_440:
	mov	ax,VIKING_AMOVE
	out	dx, ax
	mov	ax, x
	out	dx, ax
	mov	ax, -41
	out	dx, ax
	call	viking_flush
	mov	ax, VIKING_AGCPY + 200h
	out	dx, ax
	mov	ax, 0
	out	dx, ax		;Is this a rectangle fill by any chance?
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, y
	out	dx, ax
	mov	ax, x
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	call	viking_flush
	WPR16	VIKING_ADR0, 0
	WPR16	VIKING_ADR1, -41
	mov	ax, VIKING_WPR OR VIKING_ADR2
	out	dx, ax
	mov	ax, x
	inc	ax
	out	dx, ax
	WPR16	VIKING_ADR3, -41
	call	viking_flush
	mov	ax,VIKING_AMOVE
	out	dx, ax
	mov	ax, 0
	out	dx, ax
	mov	ax, -41
	out	dx, ax
	mov	ax, VIKING_WPR OR VIKING_PRC0
	out	dx, ax
	xor	ax, ax
	out	dx, ax
	mov	ax, 0C870h	;XXX
	out	dx, ax
	call	flush_0_abort
	mov	ax, 0C12h	;XXX
	out	dx, ax
	call	viking_waitread
	in	ax, dx
	cmp	ax, x
	jle	scan_450
	mov	ax, -1
	jmp	scan_510
;
scan_450:
	mov	bx, x
	sub	bx, ax
	mov	ax, bx
	jmp	scan_510
;
scan_460:
	mov	ax, VIKING_WPR OR VIKING_CL0
	OUT_DX_AHAL
	OUT_DX_BHBL
	mov	ax, VIKING_WPR OR VIKING_CL1
	OUT_DX_AHAL
	OUT_DX_BHBL
	mov	ax, VIKING_WPR OR VIKING_EDG
	OUT_DX_AHAL
	OUT_DX_BHBL
	call	viking_flush
	mov	ax, VIKING_WPTN
	OUT_DX_AHAL
	xor	al,al
	out	dx,al
	inc	al
	out	dx,al
	mov	al, -1
	out	dx, al
	out	dx, al
	cmp	gl_direction, 0
	jz	scan_470
	jmp	scan_490
;
scan_470:
	call	viking_flush
	WPR8	VIKING_ADR0, x
;	WPR8	VIKING_ADR1, y
	mov	ax, VIKING_WPR OR VIKING_ADR1
	OUT_DX_AHAL
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	OUT_DX_AHAL
	WPR8	VIKING_ADR2, SCREEN_WIDTH
	mov	ax, VIKING_WPR OR VIKING_ADR3
	OUT_DX_AHAL
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	OUT_DX_AHAL
	call	viking_flush
	AMOVE8	x, y
	mov	ax, VIKING_WPR OR VIKING_PRC0
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	mov	ax, VIKING_PAINT + 70h	
	OUT_DX_AHAL
	call	flush_0_abort
	mov	ax, 0C12h	;XXX
	OUT_DX_AHAL
	call	viking_waitread
	in	al, dx
	mov	ah, al
	in	al, dx
	cmp	ax, SCREEN_WIDTH
	jl	scan_480
	mov	ax, -1
scan_480:
	jmp	scan_510

scan_490:
	mov	ax,VIKING_AMOVE
	OUT_DX_AHAL
	mov	ax, x
	OUT_DX_AHAL
	mov	ax, -41
	OUT_DX_AHAL
	call	viking_flush
	mov	ax, 0E200h	;XXX
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al		;Is this a rectangle fill by any chance?
	mov	ax, SCREEN_HEIGHT - 1
	sub	ax, y
	OUT_DX_AHAL
	mov	ax, x
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	inc	al
	out	dx, al
	call	viking_flush
	mov	ax, VIKING_WPR OR VIKING_ADR0
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	WPR8	VIKING_ADR1, -41
	mov	ax, VIKING_WPR OR VIKING_ADR2
	OUT_DX_AHAL
	mov	ax, x
	inc	ax
	OUT_DX_AHAL
	WPR8	VIKING_ADR3, -41
	call	viking_flush
	mov	ax,VIKING_AMOVE
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	mov	ax, -41
	OUT_DX_AHAL
	mov	ax, VIKING_WPR OR VIKING_PRC0
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	mov	ax, VIKING_PAINT + 70h
	OUT_DX_AHAL
	call	flush_0_abort
	mov	ax, VIKING_RPR OR VIKING_CPX
	OUT_DX_AHAL
	call	viking_waitread
	in	al, dx
	mov	ah, al
	in	al, dx
	cmp	ax, x
	jle	scan_500
	mov	ax, -1
	jmp	scan_510
;
scan_500:
	mov	bx, x
	sub	bx, ax
	mov	ax, bx

scan_510:
	mov	bx, ax
	call	viking_flush
	test	cs:bus_width, 1
	jz	scan_520
	WPR16	VIKING_ADR0, 0
	WPR16	VIKING_ADR1, 0
	WPR16	VIKING_ADR2, SCREEN_WIDTH-1
	WPR16	VIKING_ADR3, SCREEN_HEIGHT-1
	call	viking_flush
	WPR16	VIKING_CL0, 0
	WPR16	VIKING_CL1, -1
	call	endbusy
	mov	ax, bx
	jmp	scan_280
;
scan_520:
	mov	ax, VIKING_WPR OR VIKING_ADR0
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	mov	ax, VIKING_WPR OR VIKING_ADR1
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	WPR8	VIKING_ADR2, SCREEN_WIDTH-1
	WPR8	VIKING_ADR3, SCREEN_HEIGHT-1
	call	viking_flush
	mov	ax, VIKING_WPR OR VIKING_CL0
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	out	dx, al
	mov	ax, VIKING_WPR OR VIKING_CL1
	OUT_DX_AHAL
	mov	ax, 0FFh
	out	dx, al
	out	dx, al
	call	endbusy
	mov	ax, bx
	jmp	scan_280

sEnd	Code

ifdef	PUBDEFS
	include scanlr.pub
endif

	end
