	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CURSOR.ASM
;
; This file contains the pointer shape routines required to draw the
; pointer shape on the EGA.
;
; Created: 23-Feb-1987
; Author:  Walt Moore [waltm]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	move_cursors
;			draw_cursor
;			cursor_off
;
; Public Data:		x_cell
;			y_cell
;			cur_cursor
;			inquire_data
;			CUR_HEIGHT
;			CUR_ROUND_LEFT
;			CUR_ROUND_RIGHT
;			INIT_CURSOR_X
;			INIT_CURSOR_Y
;
;			EGAMem:current_brush
;			EGAMem:known_word
;			EGAMem:shadowed_mode
;			EGAMem:saved_latches
;			EGAMem:plane_index
;			EGAMem:enable_test
;			EGAMem:tonys_bar_n_grill
;
; General Description:
;
;   All display drivers must support a "cursor" for the pointing
;   device.  The cursor is a small graphics image which is allowed
;   to move around the screen independently of all other operations
;   to the screen, and is normally bound to the location of the
;   pointing device.  The cursor is non-destructive in nature, i.e.
;   the bits underneath the cursor image are not destroyed by its
;   presence.
;
;   A cursor consists of an AND mask and an XOR mask, which give
;   possible pixel colors of 0 (black), 1 (white), display, or
;   inverse display.
;
;		    AND XOR | DISPLAY
;		    ---------------------
;		     0	 0  |	  0
;		     0	 1  |	  1
;		     1	 0  |	Display
;		     1	 1  | Not Display
;
;   The cursor also has a "hot spot", which is the pixel of the
;   cursor image which is to be aligned with the actual pointing
;   device location.
;
;
;		  |	    For a cursor like this, the hot spot
;		  |	    would normally be the *, which would
;	       ---*---	    be aligned with the pointing device
;		  |	    position
;		  |
;
;   The cursor may be moved to any location on the screen, be
;   restricted to only a section of the screen, or be made invisible.
;   Part of the cursor image may be past the edge of the screen, and
;   in such a case only the visible part is displayed.
;
;
;
;   Logically, the cursor image isn't part of the physical display
;   surface.  When a drawing operation coincides with the cursor
;   image, the result is the same as if the cursor image wasn't
;   there.  In reality, if the cursor image is part of the display
;   surface it must be removed from memory before the drawing
;   operation occurs, and redrawn afterwards.
;
;   Exclusion of the cursor image is the responsibility of the
;   display driver.  Each output operation must decide whether
;   or not to remove the cursor from display memory, and, if yes,
;   to set a protection rectangle wherein the cursor must not be
;   displayed.  The cursor image drawing routine honors this
;   protection rectangle.
;
;
;
;   To reduce the amount of perceived flicker of the cursor,
;   a buffering scheme has been implemented where the cursor
;   update is performed off-screen.
;
;   To do this, a couple of buffers are maintained.  One buffer
;   contains the contents of the screen in an area around where
;   the cursor will go, and the other saves the contents of this
;   buffer where the actual cursor is to be drawn.  The region
;   of the screen where the cursor goes is read into the buffer,
;   the old cursor removed by copying the contents of the save
;   area over the old cursor, the area under the new cursor is
;   saved, and the new cursor written into the buffer.	The
;   buffer is then written back to the screen.	This has the
;   advantage that removal of the old cursor and writing of the
;   new happen at the same time on the screen.
;
;   Since the buffer is of a fixed size, it must be determined
;   if both the old and new cursors fit within. If they do not
;   both fit within the buffer, the old cursor is removed from
;   the screen by copying the save area directly to the screen.
;   The drawing of the cursor then proceeds normally, except
;   that there is no old cursor to remove from the buffer.
;
;   This code doesn't distinguish between cursors and icons,
;   They both are the same size, 32 x 32 pixels.
;
; Restrictions:
;
;   All routines herein assume protection either via cli/sti
;   or a semephore at higher level code.
;
;-----------------------------------------------------------------------;

;
; An area of offscreen video RAM where the pixels overwritten by the 
; mouse pointer are saved
;
CURSOR_SAVE_BUF_X	equ	680h
CURSOR_SAVE_BUF_Y	equ	-1
CURSOR_SAVE_BUF_W	equ	31
CURSOR_SAVE_BUF_H	equ	-31

	.xlist
	include cmacros.inc
	include windefs.inc
	include cursor.inc		;Device specific constats
	include vikingi.inc
	include macros.mac
	.list

	??_out	cursor


	externA ScreenSelector		;Segment of screen


	public	move_cursors
	public	draw_cursor
	public	cursor_off

	page
;	The SMALL_ROTATE flag conditionally assembles optimum code for
;	rotating cursor masks one or two bit positions.  This however
;	costs approximately 90 bytes of code space
;
;		0 = do not assemble the small rotate code
;		1 = do	   assemble the small rotate code

SMALL_ROTATE	 equ	 1


sBegin	Code

;	inquire_data contains information about mouse acceleration
;	which the window manager uses.

;;; WIN1 not present
;;;inquire_data	CURSORINFO   <X_RATE,Y_RATE>

sEnd	Code



sBegin	Data

	public	x_cell			;Make all of these value available
	public	y_cell			;  to the other cursor routines
	public	cur_cursor
	public	inquire_data
	public	CUR_HEIGHT
	public	CUR_ROUND_LEFT
	public	CUR_ROUND_RIGHT
	public	INIT_CURSOR_X
	public	INIT_CURSOR_Y
	public	vik_busy


;	cur_cursor contains the cursor data structure (less the
;	actual bits) for the current cursor shape.

cur_cursor	cursorShape <,,,,,>
inquire_data	CURSORINFO   <X_RATE,Y_RATE>

enabled_flag	db	0

;	old_x_cell and old_y_cell contain the (X,Y) on the
;	screen where the contents of the save_area maps to.
;	These cells are only valid if old_valid = OLD_IS_VALID

old_x_cell	dw	0
old_y_cell	dw	0

;	(x_cell,y_cell) is the location of the cursor on the screen.
;	These locations are only updated whenever a cursor is drawn.

x_cell		dw	0
y_cell		dw	0

vik_busy	db	0
sEnd	Data


sBegin	Code
	assumes cs,Code
sEnd	Code

	page
sBegin	Code
	assumes cs,Code

;--------------------------Public-Routine-------------------------------;
; move_cursors
;
;   Move AND and XOR cursor masks
;
;   The AND and XOR cursor masks are stored in the cursor work areas.
;
; Entry:
;	DS:DI --> AND mask segment
;	ES     =  Data segment
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	DS,ES,BP
; Registers Destroyed:
;	AX,CX,DI
; Calls:
;	none
; History:
;	Mon 23-Feb-1987 12:47:30 -by-  Walt Moore [waltm]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,nothing		;DS is pointing to user data
	assumes es,Data 		;ES was set up by SetCursor

	externB		bus_width
	externB		mirror_byte
	externNP	busy_xflush
	externNP	endbusy
	externNP	viking_flush

move_cursors	proc	near

	push	bp
	call	busy_xflush
	test	cs:bus_width, 1
	jnz	move_cursors_16
	jmp	move_cursors_8
;
move_cursors_16:
	WPR16	VIKING_RWP0, 1Eh
	WPR16	VIKING_RWP1, 600h
	mov	bx, offset mirror_byte
	cld
	mov	bp, 600h
	mov	di, 20h
	mov	ax, 1Eh
	push	ax
move_cursors_17:
	mov	cx, 2
move_cursors_18:
	call	viking_flush
	mov	ax, VIKING_WT		;Squirt the cursor sprite at DS:SI
	out	dx, ax			;into the card
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	loop	move_cursors_18
	dec	di
	jz	move_cursors_19
	mov	ax, 80Dh
	out	dx, ax
	mov	ax, bp
	add	ax, 800h
	mov	bp, ax
	out	dx, ax
	jnc	move_cursors_17
	mov	ax, 80Ch
	out	dx, ax
	pop	ax
	inc	ax
	push	ax
	out	dx, ax
	jmp	short move_cursors_17
;
move_cursors_19:
	call	viking_flush
	pop	ax
	WPR16	VIKING_RWP0, 1Eh
	WPR16	VIKING_RWP1, 640h
	mov	bp, 640h
	mov	di, 20h
	mov	ax, 1Eh
	push	ax
move_cur_20:
	mov	cx, 2
move_cur_21:
	call	viking_flush
	mov	ax, VIKING_WT
	out	dx, ax
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	loop	move_cur_21
	dec	di
	jz	move_cur_22
	mov	ax, 80Dh
	out	dx, ax
	mov	ax, bp
	add	ax, 800h
	mov	bp, ax
	out	dx, ax
	jnc	move_cur_20
	mov	ax, 80Ch
	out	dx, ax
	pop	ax
	inc	ax
	push	ax
	out	dx, ax
	jmp	short move_cur_20
;
move_cur_22:
	call	endbusy
	pop	ax
	pop	bp
	ret
;	
move_cursors_8:	
	WPR8	0Ch, 1Eh
	WPR8	0Dh, 600h
	mov	bx, offset mirror_byte
	cld
	mov	bp, 600h
	mov	di, 20h
	mov	ax, 1Eh
	push	ax
move_cursors_9:
	mov	cx, 2
move_cursors_10:
	call	viking_flush
	mov	ax, VIKING_WT
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	loop	move_cursors_10
	dec	di
	jz	move_cursors_11
	mov	ax, 80Dh
	OUT_DX_AHAL
	mov	ax, bp
	add	ax, 800h
	mov	bp, ax
	OUT_DX_AHAL
	jnc	move_cursors_9
	mov	ax, 80Ch
	OUT_DX_AHAL
	pop	ax
	inc	ax
	push	ax
	OUT_DX_AHAL
	jmp	short	move_cursors_9
;
move_cursors_11:
	call	viking_flush
	pop	ax
	WPR8	0Ch, 1Eh
	WPR8	0Dh, 640h
	mov	bp, 640h
	mov	di, 20h
	mov	ax, 1Eh
	push	ax
move_cursors_12:
	mov	cx, 2
move_cursors_13:
	call	viking_flush
	mov	ax, VIKING_WT
	OUT_DX_AHAL
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	loop	move_cursors_13
	dec	di
	jz	move_cursors_14
	mov	ax, 080Dh
	OUT_DX_AHAL
	mov	ax, bp
	add	ax, 800h
	mov	bp, ax
	OUT_DX_AHAL
	jnc	move_cursors_12
	mov	ax, 80Ch
	OUT_DX_AHAL
	pop	ax
	inc	ax
	push	ax
	OUT_DX_AHAL
	jmp	short move_cursors_12
;
move_cursors_14:
	call	endbusy
	pop	ax
	pop	bp
	ret

move_cursors	endp
;
	page
;--------------------------Public-Routine-------------------------------;
; draw_cursor
;
;   Draw a cursor based at x_cell, y_cell
;
;   The currently defined cursor/icon is drawn.  If the old
;   cursor/icon is currently on the screen, it is removed.
;
; Entry:
;	DS = Data
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	BP,DS
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	enable_switching
;	disable_switching
;	save_hw_regs
;	res_hw_regs
;	erase_old_cursor
;	copy_buffer_to_save
;	rotate_masks
;	put_cursor_in_buffer
;	copy_buffer_to_screen
; History:
;	Sun 20-Sep-1987 19:41:38 -by-  [waltm], Bob Grudem [Bobgru]
;	OS/2 3.x box compatibility support.  Don't allow screen group
;	switch while we have state saved for the EGA (we can only
;	save one state at a time).
;
;	Tue 18-Aug-1987 14:36:59 -by-  Walt Moore [waltm]
;	Added test of the disabled flag.
;
;	Mon 23-Feb-1987 12:47:30 -by-  Walt Moore [waltm]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing

draw_cursor	proc	near
	call	busy_xflush
	test	cs:bus_width, 1
	jnz	draw_cursor16
	jmp	draw_cursor8
;
draw_cursor16:
	mov	ax, 1800h
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	mov	ax, -1
	out	dx, ax
	WPR16	4,-1
	cmp	enabled_flag, 1
	jnz	draw_cursor17
	call	viking_flush
	AMOVE16	old_x_cell, old_y_cell
	mov	ax, VIKING_AGCPY + 140h
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_X
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_Y
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_W
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	mov	enabled_flag, 0
	call	viking_flush
draw_cursor17:
	mov	ax, VIKING_AMOVE
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_X
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_Y
	out	dx, ax
	mov	ax, VIKING_AGCPY + 1C0h
	out	dx, ax
	mov	ax, x_cell
	out	dx, ax
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y_cell
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_W
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	mov	enabled_flag, 1
	mov	ax, x_cell
	mov	old_x_cell, ax
	mov	ax, y_cell
	mov	old_y_cell, ax
	call	viking_flush
	WPR16	VIKING_RWP0, 1Eh
	WPR16	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 6100h
	out	dx, ax
	mov	ax, 1Eh
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_X
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	call	viking_flush
	WPR16	VIKING_RWP0, 1Eh
	WPR16	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 7102h
	out	dx, ax
	mov	ax, 1Eh
	out	dx, ax
	mov	ax, 600h
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	call	viking_flush
	WPR16	VIKING_RWP0, 1Eh
	WPR16	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 7103h
	out	dx, ax
	mov	ax, 1Eh
	out	dx, ax
	mov	ax, 640h
	out	dx, ax
	mov	ax, 1
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	call	viking_flush
	AMOVE16	x_cell, y_cell
	mov	ax, VIKING_AGCPY + 140h
	out	dx, ax
	mov	ax, 06C0h		;Source X?
	out	dx, ax
	mov	ax, -1			;Source Y?
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_W	;X height
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H	;Y height
	out	dx, ax
	call	endbusy
	ret
;
draw_cursor8:
	mov	ax, 1800h
	OUT_DX_AHAL
	xor	al, al
	out	dx, al
	inc	al
	out	dx, al
	mov	al, -1	
	out	dx, al
	out	dx, al
	mov	ax, VIKING_WPR or 4
	OUT_DX_AHAL
	mov	al, -1
	out	dx, al
	out	dx, al
	cmp	enabled_flag, 1
	jnz	draw_cursor9
	call	viking_flush
	AMOVE8	old_x_cell, old_y_cell
	mov	ax, VIKING_AGCPY + 140h
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_X
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_Y
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_W
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	mov	enabled_flag, 0
	call	viking_flush
draw_cursor9:
	mov	ax, VIKING_AMOVE
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_X
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_Y
	OUT_DX_AHAL
	mov	ax, VIKING_AGCPY + 1C0h 
	OUT_DX_AHAL
	mov	ax, x_cell
	OUT_DX_AHAL
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y_cell
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_W
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	mov	enabled_flag, 1
	mov	ax, x_cell
	mov	old_x_cell, ax
	mov	ax, y_cell
	mov	old_y_cell, ax
	call	viking_flush
	WPR8	VIKING_RWP0, 1Eh
	WPR8	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 6100h
	OUT_DX_AHAL
	mov	ax, 1Eh
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_X
	OUT_DX_AHAL
	mov	ax, 1
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	call	viking_flush
	WPR8	VIKING_RWP0, 1Eh
	WPR8	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 7102h
	OUT_DX_AHAL
	mov	ax, 1Eh
	OUT_DX_AHAL
	mov	ax, 600h
	OUT_DX_AHAL
	mov	ax, 1
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	call	viking_flush
	WPR8	VIKING_RWP0, 1Eh
	WPR8	VIKING_RWP1, 6C0h
	call	viking_flush
	mov	ax, 7103h
	OUT_DX_AHAL
	mov	ax, 1Eh
	OUT_DX_AHAL
	mov	ax, 640h
	OUT_DX_AHAL
	mov	ax, 1
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	call	viking_flush
	AMOVE8	x_cell, y_cell
	mov	ax, VIKING_AGCPY + 140h
	OUT_DX_AHAL
	mov	ax, 06C0h		;Source X?
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_Y	;Source Y?
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_W	;X height
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H	;Y height
	OUT_DX_AHAL
	call	endbusy
	ret
	
draw_cursor	endp
	page

;--------------------------Public-Routine-------------------------------;
; cursor_off
;
;   Remove Cursor From Screen
;
;   The old cursor is removed from the screen if it currently
;   is on the screen.
;
; Entry:
;	DS = Data
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	BP,DS
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	enable_switching
;	disable_switching
;	save_hw_regs
;	res_hw_regs
;	copy_save_to_screen
; History:
;	Sun 20-Sep-1987 19:41:38 -by-  [waltm], Bob Grudem [Bobgru]
;	OS/2 3.x box compatibility support.  Don't allow screen group
;	switch while we have state saved for the EGA (we can only
;	save one state at a time).
;
;	Tue 18-Aug-1987 14:36:59 -by-  Walt Moore [waltm]
;	Added test of the disabled flag.
;
;	Mon 23-Feb-1987 12:47:30 -by-  Walt Moore [waltm]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing


cursor_off	proc	near
	cmp	enabled_flag, 1
	jz	cursor_off_1
	ret
;
cursor_off_1:
	call	busy_xflush
	test	cs:bus_width, 1
	jz	cursor_off_8
	AMOVE16	old_x_cell, old_y_cell
	mov	ax, VIKING_AGCPY + 140h
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_X
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_Y
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_W
	out	dx, ax
	mov	ax, CURSOR_SAVE_BUF_H
	out	dx, ax
	call	endbusy
	mov	enabled_flag, 0
	ret
;
cursor_off_8:
	AMOVE8	old_x_cell, old_y_cell
	mov	ax, VIKING_AGCPY + 140h
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_X
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_Y
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_W
	OUT_DX_AHAL
	mov	ax, CURSOR_SAVE_BUF_H
	OUT_DX_AHAL
	call	endbusy
	mov	enabled_flag, 0
	ret
;
cursor_off	endp
	page

sEnd	Code

	end
