	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	PIXEL.ASM
;
; This module contains the Set/Get Pixel routine.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Pixel
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Pixel is used to either set a pixel to a given color with the
;   current binary raster operation, or to return the color of the
;   the pixel at the given location.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


	??_out	Pixel

incDrawMode	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include stbht.inc
	include macros.mac
	.list


	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA COLOR_FORMAT		;Color format (0103h or 0104h)
	externNP ega_set_op

	externNP sum_RGB_colors_alt	;Color mapping routine

	externW	rop_indexes
	externW Y_OFFSETS

ifdef	EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


;	Define the type flags used to determine which type
;	of scan needs to be performed (color or mono).

COLOR_OP	equ	00000001b
MONO_OP 	equ	40h
END_OP		equ	0C0h
;END_OP		equ	MONO_BIT shl 1 + (1 shl (NUMBER_PLANES))


sBegin	Data

sEnd	Data
page

sBegin	Code
assumes cs,Code

	externB	 rot_bit_tbl

	.xlist
SINGLE_OK	equ	1
	externB dm_flags
	externB dm_pen_and	
	externB dm_pen_xor
	externB dm_data_r
	.list

;;; WIN1 this is now in egahires.asm
;;;
;;;rot_bit_tbl	label	byte
;;;		db	10000000b	;Table to map bit index into
;;;		db	01000000b	;  a bit mask
;;;		db	00100000b
;;;		db	00010000b
;;;		db	00001000b
;;;		db	00000100b
;;;		db	00000010b
;;;		db	00000001b
page

;--------------------------Exported-Routine-----------------------------;
; Pixel
;
;   Set or Get a Given Pixel
;
;   The given pixel is set to the given color or the given pixel's
;   physical color is returned.
;
;   The physical device may be the screen, a monochrome bitmap, or a
;   bitmap in our color format.
;
;   There will not be error checking to see if the bitmap is in our
;   color format.  If it isn't, then we'll treat the bitmap as monochrome.
;
;   If lp_draw_mode is NULL, then the physical color of the pixel is
;   returned.  If lp_draw_mode isn't NULL, then the pixel will be set
;   to the physical color passed in, combined with the pixel already
;   at that location according to the raster-op in lp_draw_mode.  Pixel
;   doesn't pay attention to the background mode.
;
;   No clipping of the input value is required.  GDI clips the
;   coordinate before it is passed in, for both Set and Get.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX:AX = physical color if get pixel
;	DX:AX = positive if no error and set was OK.
; Error Returns:
;	DX:AX = 8000:0000H if error occured
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude_far	(far version of exclude)
;	unexclude_far	(far version of unexclude)
; History:
;	Sat 31-Oct-1987 00:21:06 -by-  **** ***** [*****]
;	Added clipping of the (X,Y)
;
;	Tue 18-Aug-1987 14:50:37 -by-  **** ***** [*****]
;	Added test of the disabled flag.
;
;	Wed 12-Aug-1987 19:55:20 -by-  **** ***** [*****]
;	Moved to _PIXEL.  Removed stack checking.
;
;	Thu 06-Aug-1987          -by-  ***** ****** [mitchl]
;	Put code into segment _LINES
;
;	Tue 03-Mar-1987 20:42:07 -by-  **** ****** [******]
;	Moved a mov instruction in EGA ROP handling code.
;
;	Sun 22-Feb-1987 16:29:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	externNP my_check_stack

	assumes ds,Data
	assumes es,nothing

cProc	Pixel,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Pointer to device
	parmW	x			;X coordinate of pixel
	parmW	y			;Y coordinate of pixel
	parmD	p_color 		;Physical color to set pixel to
	parmD	lp_draw_mode		;Drawing mode to use, or null if Get

;;;	localB	is_device		;set non-zero if the device

cBegin
ife     ???                             ;If no locals
        xor	ax, ax                  ;See if room
	call	my_check_stack
endif
	jnc	pixel_00
	jmp	pixel_exit

pixel_00:
;;;	mov	al,enabled_flag 	;Load this before trashing DS
	lds	si,lp_device		;--> physical device
	assumes ds,nothing
	mov	cx,[si].bmType		;Get device type
	jcxz	pixel_20		;Memory bitmap, skip EGA specific code

;	This is the device.  The cursor must be excluded from the pixel
;	that will be processed.  The innerloop mask for the device will
;	be set for color.  The width of a plane will be set to 1 to flag
;	to the loop code that this is the EGA (odd widths are illegal).


ifdef	EXCLUSION			;If exclusion required
	mov	cx,x			;Set left
	mov	dx,y			;    top
	mov	si,cx			;    right
	mov	di,dx			;    bottom
	call	exclude 		;Exclude the area
	lds	si, lp_device
endif

pixel_20:
pixel_60:
	les	di,[si].bmBits
	mov	ax,[si].bmType		;Is it the screen?
	or	ax,ax
	mov	ax,y
	jz	pixel_61		;If so, munge y 
	mov	bx,ax
	and	bx,word ptr 7
	add	bx,bx
	add	di,cs:Y_OFFSETS[bx]
	mov	cl,3
	shr	ax,cl
pixel_61:
	mul	[si].bmWidthBytes
	add	di,ax
	mov	ax,x

;	Currently:
;		DS:DI --> the bitmap, start of the correct scan
;		DI = Index to next plane of the scan
;		     1 if the display (odd with illegal)
;		CL = looping flag

	mov	bx,ax
	shiftr	ax,3			;Compute byte offset from start of scan
	add	di,ax			;ds:di --> byte of pixel

	and	bx,word ptr 00000111B	;Get bit mask for bit
	mov	bl,rot_bit_tbl[bx]
	mov	si,off_lp_draw_mode	;If a drawmode was given
	mov	dx,seg_lp_draw_mode	;  then set the pixel, else
	mov	cx,dx			;  return it's physical color
	or	cx,si
	jz	pixel_200		;Not given, return pixel color
					;Given, operation is set pixel




;	The operation to be performed is SetPixel.  Currently:
;
;		CH    =   bit mask
;		DS:SI --> byte bit is to be set in
;		BX:DI --> physical drawing mode
;		CL    =   loop mask
;		DX    =   Index to next plane
;			  1 if the display


pixel_100:
	mov	ds,dx
	mov	al,wptr p_color
	mov	si,[si].Rop2
	add	si,si
	mov	ah,es:[di]
	call	word ptr cs:rop_indexes-2[si]
	xor	al,ah
	and	al,bl
	xor	al,ah
	stosb
	jmp	short pixel_210
	
page

;	The operation to be performed is get pixel.  The color of the
;	pixel will be returned.  The color of the pixel will be composed
;	from all planes if a color bitmap and the result "AND"ed to
;	produce the mono bit in the physical color (this is the same
;	as bitblt when blting from color to monochrome).
;
;	If this is a monochrome bitmap, then the color will simply be
;	black or white.
;
;	Currently:
;
;		CH     =  bit mask
;		CL     =  loop mask
;		DX     =  index to next plane
;			  1 if physical device
;		DS:SI --> byte bit is to be set in


WHITE	equ	C0_BIT+C1_BIT+C2_BIT+C3_BIT+MONO_BIT+ONES_OR_ZEROS
BLACK	equ	ONES_OR_ZEROS


pixel_200:
	mov	al,es:[di]
	and	al,bl
	mov	dx,0FFh
	mov	ax,0FFFFh		;Return either FFFFFF
	jnz	pixel_300
pixel_210:
	xor	ax,ax			;or 000000
	xor	dx,dx
pixel_300:
ifdef	EXCLUSION
	call	unexclude		;Clear any exclude rectangle
endif
pixel_exit:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	10h

cEnd	<nogen>

ifdef	PUBDEFS
	.xlist
	include PIXEL.PUB
	.list
endif

sEnd	Code
	end
