	
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	STRBLT.ASM
;
;   This module contains the strblt function and the ExtendedTextOut
;   function.
;
; Created: 17-Mar-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Strblt
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


FIXED_PITCH_ON = 1			;en/disables smartfix code


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.	?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.


?CHKSTK = 1
?CHKSTKPROC	macro
		endm


	.xlist
	include cmacros.inc
incFont 	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include control for gdidefs.inc
	include gdidefs.inc
	include display.inc
	include pc98.inc
	include macros.mac
	include strblt.inc
	include fontseg.inc
	.list


	??_out	strblt


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_WIDTH		;Screen width in pixels
	externA COLOR_FORMAT		;Color format (0103h or 0104h)


;	Other functions required for strblt.

ifdef	 EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


sBegin	Code
assumes cs,Code

X0C4D	dw	0
X0C4F	db	1Fh dup(0)
X0C6E	db	0
X0C6F	db	1400h dup(0)


page
;--------------------------Exported-Routine-----------------------------;
; Strblt
;
; This is the old strblt entry point.  Null parameters are pushed
; for the ExtTextOut's extra parameters, and control given to
; ExtTextOut.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX = Y extent of string if extent call
;	AX = X extent of string if extent call
;	EGA registers in default state
; Error Returns:
;	DX:AX = 8000:0000H
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	See ExtTextOut
; History:
;	Thu 09-Apr-1987 13:36:08 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing

FLAG_FONT_W	equ	1
FLAG_FONT_H	equ	2

	externB	nec_wrmode
	externB	nec_red
	externB	nec_green
	externB	nec_blue
	externB	nec_busy

;
; WIN1 In Windows 1, STRBLT now becomes live!
;
cProc	Strblt,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

;	ExtTextOut parameters we have to dummy up.
;
;	parmD	lp_dx			;Widths for the characters
;	parmD	lp_opaque_rect		;Opaquing rectangle
;	parmW	eto_options		;ExtTextOut options

	localW	bp4			;
	localW	abs_count		; [bp-6] WIN1
	localW 	local_str		; [bp-8] WIN1
	localW	next_scan		; [bp-0a] Index to get to next scan line
	localW	y_step			; [bp-0c] Y step
	localW	draw_func		; [bp-0e]
	localW	opaque_routine		; [bp-10]
	localW	colors			; [bp-12] Text/background colors
	localW	next_plane		; [bp-14] Index to get to next plane
	localW	fontw_bytes		; [bp-16] Source font width (bytes)
	localW	opaque_height		; [bp-18] Height of opaque box (sometimes)
	localW	clip_left		; [bp-1a] WIN1
	localW	clip_right		; [bp-1c] WIN1
;;;	localD	lp_surface		;Pointer to first byte of destination
	localW	temp_off_lp_bits	; [bp-1e] Intermediate pointer to dev surface
	localW	scan_start		; [bp-20] Delta from start of scan
	localW	clipped_font_height	; [bp-22] Actual height of bits to be drawn
;
; BP-24h
;
;;;	localW	tot_brk_extra		;Total break extra
	localW	df_pixel_w		; [bp-24]  WIN1 font pixel width
	localW	brk_extra		; [bp-26] *# extra pixels to add each break char
	localW	brk_err 		; [bp-28] *Justification DDA error term
	localW	brk_rem 		; [bp-2A] *  extra pixels are distributed
	localW	brk_count		; [bp-2C] *DDA - # breaks into which BrkRem
	localW	char_xtra		; [bp-2E] *# extra pixels to add each char


	localW	buffer			; [bp-30] Offset of buffer on the stack
	localW	plane_pitch		;_[bp-32] Gap from one plane to next
	localW	codebuf			; [bp-34] Offset of generated code

	localD	background		;[bp-38]
	localD	foreground		;[bp-3c]
	
	localW	gl_bitmap_type		;->[bp-3eh]

	localW	bp40			;->[bp-40h]
	localW	bp42			;->[bp-42h]
	localW	bp44			;->[bp-44h]
	localW	bp46			;->[bp-46h]
	localW	font_w_16		;->[bp-48h]
	localW	font_h_16		;->[bp-4ah]
	localW	bp4c			;->[bp-4ch]
	localW	bp4e			;->[bp-4eh]
	localW	bp50
	localW	bp52
	localW	bp54
	localW	bp56
	localD	bp5a
	localD	bp5e
	localW	bp60
	localW	bp62
	localB	bp63			;->[bp-63h]
	localB	bp64			;->[bp-64h]
	localB	source_cs		;->[bp-65h]
	localB	bp66			;->[bp-66h]
	localB	flags			;->[bp-67h]
	localB	bp68			;->[bp-68h]
	localB	bp69			;->[bp-69h]

cBegin
	if	???			;Do test only if locals
	jc	j_exit_strblt		;No room for locals, return now
	endif

	mov	ax, count
	cwd
	xor	ax,dx			;Force positive
	shl	ax, 1			;Check that there's room on the stack
	shl	ax, 1			;for the string
	mov	cx, ax
	shl	ax, 1			;*8
	shl	ax, 1			;*16
	add	ax, cx			;*20
	add	ax, 20h			;at 20 bytes / character + 32 overhead
	mov	cx, ax
	call	my_check_stack
	jnc	strblt_01
j_exit_strblt:
	jmp	exit_strblt
;
strblt_01:
	add	sp, cx
	mov	local_str, sp	
	mov	bp69, 1
	cld
	xor	dx, dx
	lds	si, lp_string
	mov	cx, count
	
;;;	mov	al,enabled_flag 	;Save enabled_flag incase we need it
;;;	mov	local_enabled_flag,al

;;;	call	get_mode		;Get data from drawmode, set flags
;;;	call	get_font		;Get font data (aborts if invalid)


;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	or	cx,cx
	jg	strblt_02		;Positive count, output string
	jnz	strblt_02c
	xor	ax, ax
	jmp	only_draw
;
strblt_02:
	lodsb				;Get next character from string
	call	isprint			;
	jnc	strblt_02a
	mov	bp69, 0
	dec	cx
	jz	strblt_02b
	inc	si
strblt_02a:
	dec	cx
	jz	strblt_02c
	jmp	short strblt_02
;
strblt_02b:
	dec	count
strblt_02c:
	lds	si, lp_clip_rect
	les	di, lp_font
	mov	bp42, offset X0C6F
	mov	bp63, dl
	mov	bp66, dl
	mov	flags, dl
	mov	bp68, dl
	mov	bp56, dx
	mov	ax, count
	mov	bp40, offset X29F9
	or	ax, ax
	jnz	strblt_02d
	jmp	j_only_draw
;
strblt_02d:
	jg	strblt_02e
	mov	bp40, offset X29DB
	neg	ax
	xor	bx, bx
	mov	wptr lp_clip_rect, bx
strblt_02e:
	mov	abs_count, ax
	mov	ax, es:[di].dfMaxWidth
	mov	cl, 16
	div	cl
	xor	ah, ah
	or	ax, ax
	jnz	strblt_02f
	inc	ax
	or	flags, FLAG_FONT_W
	jmp	short strblt_02g

strblt_02f:
	cmp	ax, 4
	jbe	strblt_02g
	mov	ax, 4
strblt_02g:
	mov	font_w_16, ax
	mov	ax, es:[di].dfPixHeight
	mov	cl, 16
	div	cl
	xor	ah, ah
	or	ax, ax
	jnz	strblt_02h
	inc	ax
	or	flags, FLAG_FONT_H
	jmp	short strblt_02i
;
strblt_02h:
	cmp	ax, 4
	jbe	strblt_02i
	mov	ax, 4
strblt_02i:
	mov	font_h_16, ax
	test	flags, FLAG_FONT_H
	jz	strblt_02j
	mov	ax, 10
	jmp	short strblt_02k

strblt_02j:
	mul	cl
strblt_02k:
	mov	bp4c, ax
	test	flags, FLAG_FONT_H
	jz	strblt_02l
	mov	ax, 10
strblt_02l:
	mov	cx, font_w_16
	mul	cx
	mov	cx, 2
	test	flags, FLAG_FONT_W
	jz	strblt_02m
	mov	cx, 2
strblt_02m:
	mul	cx
	mov	bp4e, ax
	mov	ax, 0Ah
	test	flags, FLAG_FONT_W	
	jnz	strblt_02n
	mov	ax, font_w_16
	mov	cl, 16
	mul	cl
strblt_02n:
	mov	cx, es:[di].dfMaxWidth
	sub	cx, ax
	jnc	strblt_02o
	xor	ax, ax
	mov	bp50, ax
	mov	bp52, ax
	jmp	short strblt_02p
;
strblt_02o:
	shr	cx, 1
	mov	bp52, cx
	adc	cx, 0
	mov	bp50, cx
strblt_02p:
	mov	cx, es:[di].dfWidthBytes
	mov	fontw_bytes, cx
	mov	ax, es:[di].dfPixWidth
	mov	df_pixel_w, ax
	or	si, si			;Clip rectangle present?
	jz	strblt_05
	mov	ax, [si].top
	mov	dx, ax
	sub	ax, y
	mov	bx, ax
	jge	strblt_03
	sub	dx, bx
	xor	bx, bx
strblt_03:
	mov	temp_off_lp_bits,dx
	mov	scan_start,dx
	mov	dx, es:[di].dfPixHeight
	cmp	bx, dx
	jge	j_only_draw
	mov	ax, [si].bottom
	sub	ax, y
	cmp	ax, dx
	jl	strblt_04
	mov	ax, dx
strblt_04:
	or	ax, ax
	jle	j_only_draw
	cmp	ax, bx
	jle	j_only_draw
	jmp	short strblt_06

j_only_draw:
	jmp	only_draw


strblt_05:
	mov	bx, y
	mov	temp_off_lp_bits,bx
	mov	scan_start,bx
	xor	bx, bx
	mov	ax, es:[di].dfPixHeight
strblt_06:
	push	ax
	mov	ax, font_w_16
	shl	ax, 1
	mul	bx
	mov	bp44, ax
	pop	ax
	mov	bp46, bx
	cmp	bx, bp4c
	jc	strblt_06a
	mov	bp66, 1
strblt_06a:
	sub	ax, bx
	mov	clipped_font_height,ax
	add	scan_start, ax
	add	ax, bx
	mul	cx
	mov	dx, wptr es:[di].dfBitsPointer
	add	ax, dx
	dec	ax
	mov	opaque_height, ax
	mov	ax, bx
	mov	si, bx
	mov	bx, dx
	mul	cx
	add	ax, bx
	dec	ax
	mov	next_plane,ax
	mov	ax, si
	lds	si, lp_draw_mode
	mov	brk_err, 0
	cmp	word ptr es:[di].dfPixWidth, 0
	jz	strblt_08
	mov	dx, offset X152D
	mov	opaque_routine,dx		
	cmp	[si].TBreakExtra,0
	jz	strblt_07
	mov	dx, offset X1553
	mov	opaque_routine,dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_07:
	mov	dx, [si].CharExtra
	mov	si, offset X150C
	or	dx, dx
	jz	strblt_10
	mov	si, offset X150B
	mov	char_xtra,dx
	xor	dx, dx
	mov	df_pixel_w, dx
	jmp	short strblt_10
;
strblt_08:
	mov	dx, offset X158E
	mov	opaque_routine, dx
	cmp	[si].TBreakExtra, 0
	jz	strblt_09
	mov	dx, offset X153F
	mov	opaque_routine, dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_09:	
	mov	dx, [si].CharExtra
	mov	si, offset X292A
	or	dx, dx
	jz	strblt_10
	mov	si, offset X1570
	mov	char_xtra, dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_10:
	mov	draw_func, si
	xor	si, offset X15AF
	mov	colors, si		;XXX
	lds	si, lp_device
	mov	dx, [si].bmWidthBytes
	mov	y_step, dx
	add	ax, y
	mul	dx
	lds	si, lp_clip_rect
	mov	bx, x
	or	si, si
	jnz	strblt_10a
	jmp	strblt_15

strblt_10a:
	mov	cx, [si].left
	mov	clip_left, cx
	mov	di, bx
	mov	dx, [si].right
	mov	clip_right, dx
	sub	dx, cx
	sub	bx, cx
	jl	strblt_11
	mov	clip_left, di
	mov	cx, di
	sub	dx, bx
	xor	bx, bx
strblt_11:
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	add	ax, cx
	mov	next_scan, ax	;XXX
	cmp	bx, dx
	jl	strblt_11a
	jmp	j2_only_draw
strblt_11a:
	lds	si, lp_string
	les	di, lp_font
strblt_12:
	call	word ptr draw_func
	jle	strblt_12
	or	ax, ax
	jz	strblt_14
	add	ax, cx
	sub	ax, bx
	mov	cx, bx
	sub	bx, dx
strblt_13:
	jl	strblt_13a
	jmp	strblt_21
strblt_13a:
	mov	ch, cl
	mov	cl, al
	cmp	bp54, 0
	jz	strblt_13b
	mov	ax, 4000h
	jmp	short strblt_13c
;
strblt_13b:
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	or	ah, source_cs
strblt_13c:
	push	ax
	and	cl, 7
	push	cx
	call	word ptr draw_func
	jmp	short strblt_13
;
strblt_14:
	add	ax, cx
	sub	ax, bx
	and	ax, 7
	mov	cx, bx
	sub	bx, dx
	jmp	short strblt_13
;
strblt_15:
	mov	clip_left, bx
	mov	clip_right, bx
	mov	cx, bx
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	;XXX
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	add	ax, bx
	mov	next_scan, ax	;XXX
	lds	si, lp_string
	les	di, lp_font
	xor	bx, bx
strblt_16:
	call	word ptr draw_func
	mov	ch, cl
	mov	cl, al
	cmp	bp54, 0
	jz	strblt_16a
	mov	ax, 4000h
	jmp	short strblt_16b
strblt_16a:
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	or	ah, source_cs
strblt_16b:
	push	ax
	and	cl, 7
	push	cx
	jmp	short strblt_16
;
j2_only_draw:	
	jmp	only_draw
;
	jmp	strblt_42	;Seems not to be referenced
;
strblt_20:
	pop	dx
	pop	si
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	push	si
	push	dx
	jmp	short strblt_23
;
strblt_21:
	sub	cx, bx
	jle	strblt_22
	mov	ch, cl
	mov	cl, al
	cmp	bp54, 0
	jz	strblt_21a
	mov	ax, 4000h
	jmp	short strblt_21b
;
strblt_21a:
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	or	ah, source_cs
strblt_21b:
	push	ax
	and	cl, 7
	push	cx
strblt_22:
	cmp	bp63, 1
	jnz	strblt_22a
	call	word ptr draw_func
strblt_22a:
	cmp	sp, local_str
	jz	j2_only_draw
	cmp	bp69, 1
	jnz	strblt_23
	cmp	df_pixel_w, 8
	jz	strblt_20
strblt_23:
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	mov	cx, count
	or	cx, cx
	jg	strblt_25
	mov	cx, brk_err
	jcxz	strblt_24
	lds	si, lp_draw_mode
	mov	[si].BreakErr, cx
strblt_24:
	mov	ax, clip_right
	sub	ax, clip_left
	mov	dx, scan_start
	sub	dx, temp_off_lp_bits
	jmp	only_draw
;
strblt_25:
	lds	si, lp_device
	mov	cx, [si].bmType
	mov	gl_bitmap_type, cx
	jcxz	strblt_27
	mov	cx, clip_left
	mov	dx, temp_off_lp_bits
	mov	si, clip_right
	mov	di, scan_start
	call	exclude
;
strblt_27:
	lds	si, lp_device
	mov	ax, [si].bmWidthPlanes
	cmp	word ptr [si].bmPlanes, 103h
	lds	si, lp_draw_mode
	jz	strblt_28
	mov	al, [si].TextColor + 3
	shl	al, 1
	cbw
	mov	bptr foreground, ah
	mov	dx, offset write_to_mono
	cmp	word ptr [si].bkMode, 1
	jz	strblt_26
	mov	al, [si].bkColor + 3
	shl	al, 1
	cbw
	mov	bptr background, ah
	mov	cx, offset blank_mono
	jmp	short strblt_29
;
strblt_26:
	mov	buffer, dx
	jmp	strblt_42
;
strblt_28:
	mov	plane_pitch, ax
	mov	bx, ax
	add	ax, ax
	add	ax, bx
	add	ax, y_step
	mov	codebuf,ax
	mov	ax, [si].TextColor
	mov	wptr foreground, ax
	mov	al, [si].TextColor+2
	mov	bptr foreground+2, al
	mov	dx, offset write_to_cbitmap
	cmp	gl_bitmap_type, 0
	jz	strblt_28a
	mov	dx, offset write_to_vram
strblt_28a:
	cmp	word ptr [si].bkMode, 1
	jz	strblt_26
	mov	ax, [si].bkColor
	mov	wptr background, ax
	mov	al, [si].bkColor+2
	mov	bptr background + 2, al
	mov	cx, offset strblt_410
	cmp	gl_bitmap_type, 0
	jz	strblt_29
	mov	cx, offset strblt_500
strblt_29:
	mov	[bp-30h], dx
	push	cx
	mov	cx, clip_left
	mov	ax, cx
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	dl, 0FFh
	and	cx, word ptr 7
	shr	dl, cl		;Left fringe
	mov	cx, clip_right
	dec	cx
	mov	bx, cx
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	mov	dh, 0FFh
	and	cx, word ptr 7
	sub	cx, 7
	neg	cx
	shl	dh, cl		;Right fringe
	inc	ax
	sub	bx, ax
	jge	strblt_30
	and	dl, dh	;Left fringe = right fringe
strblt_30:	
	mov	clip_left, bx
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan	
	retn
;
ifdef UNDEF
strblt_35:
	mov	bx, dx
	mov	dx, PLANE
strblt_35a:
	mov	si, 2
strblt_35b:
	mov	ax, si
	shl	al, 1
	jnz	strblt_35c
	inc	al
strblt_35c:	
	or	al, 0F0h
	out	dx, al
	push	di
	mov	ah, [bp+si-38h]	;Colour for this plane
strblt_36:
	mov	al, es:[di]
	xor	al, ah
	and	al, bl
	xor	es:[di], al
	inc	di
	mov	cx, clip_left
	or	cx, cx
	jl	strblt_37
	mov	al, ah
	rep	stosb
	mov	al, es:[di]
	xor	al, ah
	and	al, bh
	xor	es:[di], al
strblt_37:
	pop	di
	dec	si
	jns	strblt_35b
	add	di, y_step
	dec	clipped_font_height
	jg	strblt_35a
	jmp	short strblt_42
endif
;
blank_mono:
	mov	ah, bptr background	;Colour
	mov	si, y_step
	sub	si, bx
	dec	si
	mov	bx, clipped_font_height
strblt_39:
	mov	al, es:[di]
	xor	al, ah
	and	al, dl		;Left fringe
	xor	es:[di], al
	mov	cx, clip_left
	or	cx, cx
	jl	strblt_41	;No middle or right
	inc	di
	mov	al, ah
	rep	stosb
	mov	al, es:[di]
	xor	al, ah
	and	al, dh
	xor	es:[di], al
strblt_41:
	add	di, si
	dec	bx
	jg	strblt_39
	jmp	strblt_42
;
strblt_410:
	cmp	gl_bitmap_type, 0
	jnz	strblt_500
	mov	ax, plane_pitch
	add	ax, ax
	add	di, ax
strblt_411:
	mov	si, 2
strblt_412:
	mov	bx, di
	mov	ah, bptr background[si]	;Colour for this plane
	mov	al, es:[di]
	xor	al, ah
	and	al, dl		;Left fringe
	xor	es:[di], al
	inc	di
	mov	cx, clip_left
	or	cx, cx
	jl	strblt_413	;No middle or right
	mov	al, ah
	rep	stosb
	mov	al, es:[di]
	xor	al, ah
	and	al, dh		;Right fringe
	xor	es:[di], al
strblt_413:
	mov	di, bx
	sub	di, plane_pitch
	dec	si
	jns	strblt_412
	add	di, codebuf
	dec	clipped_font_height
	jg	strblt_411
	jmp	short strblt_42
;
strblt_500:
	mov	al, bptr background
	mov	cs:nec_red, al
	mov	al, bptr background+1
	mov	cs:nec_green, al
	mov	al, bptr background+2
	mov	cs:nec_blue, al
	mov	al, 0C8h
	mov	cs:nec_wrmode, al
	cli
	mov	cs:nec_busy, 1
	out	PC98_WRMODE, al
	mov	al,cs:nec_red
	out	PC98_WRPLANE, al
	mov	al,cs:nec_green
	out	PC98_WRPLANE, al
	mov	al,cs:nec_blue
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	jmp	short	strblt_501
strblt_501:
	sti
strblt_502:
	mov	bx, di
	mov	al, dl
	cli
	stosb
	sti
	mov	cx, clip_left
	or	cx, cx
	jl	strblt_503
	mov	al, 0FFh
	cli	
	rep	stosb
	sti
	mov	al, dh
	cli
	stosb
	sti
strblt_503:
	mov	di, bx
	add	di, y_step
	dec	clipped_font_height
	jg	strblt_502
	cli
	mov	cs:nec_busy, 0
	mov	al, 0
	jmp	short strblt_504
strblt_504:
	out	PC98_WRMODE, al
	sti
	
strblt_42:
	lds	si, lp_font
	lds	si, [si].dfBitsPointer
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan
	mov	next_scan, di
	cmp	gl_bitmap_type, 0
	jz	strblt_42a
	cli	
	mov	cs:nec_busy, 1
	push	ax
	mov	al, 0C0h
	mov	cs:nec_wrmode, al
	out	PC98_WRMODE, al
	mov	al, bptr foreground
	mov	cs:nec_red, al
	out	PC98_WRPLANE, al
	mov	al, bptr foreground+1
	mov	cs:nec_green, al
	out	PC98_WRPLANE, al
	mov	al, bptr foreground+2
	mov	cs:nec_blue, al
	out	PC98_WRPLANE, al
	mov	al, bptr foreground+3
	out	PC98_WRPLANE, al
	sti
	pop	ax
strblt_42a:
	jmp	strblt_52
;
strblt_43:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	call	word ptr buffer
	mov	dh, 8
	neg	cl
	jz	strblt_45
strblt_44:
	sub	dh, cl
	jle	strblt_43
	shl	ax, cl
strblt_45:
	cmp	ch, 8
	ja	strblt_47
	or	ch, ch
	jz	strblt_49
	xor	al, al
	or	si, si
	jz	strblt_46
	cmp	source_cs, 0
	jnz	strblt_45a
	lodsb
	jmp	short strblt_46
;
strblt_45a:
	lods	byte ptr cs:[si]
strblt_46:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_47:
	xor	al, al
	or	si, si
	jz	strblt_48
	cmp	source_cs, 0
	jnz	strblt_47a
	lodsb
	jmp	short strblt_48
;
strblt_47a:
	lods	byte ptr cs:[si]
strblt_48:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_44
strblt_49:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	test	si, 0C000h
	jz	strblt_49b
	mov	cx, si
	and	ch, 0C0h
	mov	source_cs, ch
	cmp	ch, 80h
	mov	cx, bp44
	jnz	strblt_49a
	shr	cx, 1
strblt_49a:
	and	si, 3FFFh
	add	si, offset X0C6E
	add	si, cx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al,al
	cmp	source_cs, 40h
	jz	strblt_50
	cmp	bp66, al
	jnz	strblt_50
	lods	byte ptr cs:[si]
	jmp	short strblt_50	

strblt_49b:
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al, al
	or	si, si
	jz	strblt_50
	add	si, next_plane
	lodsb
	mov	source_cs, 0
strblt_50:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jc	strblt_50a
	jmp	strblt_44
strblt_50a:
	add	cl, ch
	xor	ch, ch
	jmp	strblt_44
;
strblt_51:
	mov	cl, dh
	shl	ah, cl
	call	word ptr buffer
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_53
	mov	next_plane, si
	cmp	bp66, 0
	jnz	strblt_51a
	mov	di, bp46
	inc	di
	mov	bp46, di
	cmp	di, bp4c
	mov	bp66, 1
	jnc	strblt_51a
	mov	bp66, 0
	mov	di, font_w_16
	shl	di, 1
	add	bp44, di
strblt_51a:
	mov	di, y_step 
	add	di, next_scan
	mov	next_scan, di
strblt_52:
	mov	bx, local_str
	xor	ax, ax
	mov	dh, bptr bp4	;XXX
	cmp	bp69, 1
	jnz	strblt_52a
	cmp	df_pixel_w, 8
	jz	strblt_54
strblt_52a:
	jmp	strblt_49
;
strblt_53:
	jmp	short only_draw
	nop
strblt_54:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl		;Right fringe
	cmp	dh, cl
	jg	strblt_55
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_59
	mov	cl, 8
	jmp	short strblt_57
;
strblt_55:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_60

strblt_56:
	add	si, next_plane
	lodsb
strblt_57:
	xchg	al, ah
	call	word ptr buffer
	xchg	al, ah
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jnz	strblt_56
	jmp	short strblt_61
;
strblt_58:
	add	si, next_plane
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_59:
	neg	cl
	xchg	al, ah
	call	word ptr buffer
	xchg	al, ah
	rol	ax, cl
	sub	cl, 8
strblt_60:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jnz	strblt_58
strblt_61:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_49
;
only_draw:
	mov	sp, local_str
	call	unexclude
	cli
	push	ax
	mov	cs:nec_busy, 0
	mov	al, 0
	out	PC98_WRMODE, al
	pop	ax
	sti
exit_strblt:

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Eh
	page
;

X1505:	mov	al, es:[di].dfDefaultChar
	jmp	short X1523
;
X150B:	mov	cx,colors
	xor	draw_func,cx
X150C:	xor	cx, cx
	mov	bp54, cx
	cmp	bp68, cl
	jnz	X2875
	mov	source_cs, cl
X1511:	lodsb
	dec	abs_count
	jl	X1535
	call	word ptr bp40
	jc	X2875
	cmp	al, es:[di].dfLastChar
	ja	X1505
	sub	al, es:[di].dfFirstChar
	jb	X1505
X1523:	mov	cx, es:[di].dfPixWidth
	cmp	al, es:[di].dfBreakChar
	jz	X153C
X152D:	mul	cl
	add	ax, 8
	add	bx, cx
	ret
;
X1535:	add	clip_right, bx
	pop	ax
	jmp	strblt_22
;

;
X153F:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	pop	bx
	jnz	X1553
	jmp	X292A
;
X1553:	add	cx, brk_extra
	mov	ax, brk_err
	sub	ax, brk_rem
	jg	X1562
	add	ax, brk_count
	inc	cx
X1562:	mov	brk_err, ax
	xor	ax, ax
	add	bx, cx
	ret
;
X153C:	jmp	wptr opaque_routine
;
X2875:	mov	al, bp63
	cmp	al, 2
	jz	X28A2
	cmp	bp68, 0
	jnz	X28A8
	mov	cx, bp52
	cmp	source_cs, 80h
	jnz	X288D
	shr	cx, 1
X288D:	mov	bp54, cx
	jcxz	X28A8
X2892:	mov	bp68, 1
X2896:	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	add	ax, 8
	add	bx, cx
	ret
;
X28A2:	cmp	source_cs, 80h
	jz	X28EB
X28A8:	mov	cx, bp56
	cmp	font_w_16, cx
	jbe	X28EB
	xor	ax, ax
	cmp	bp63, 1
	jz	X28BB
	mov	ax, font_w_16
X28BB:	add	ax, bp42
	sub	ax, offset X0C6F
	add	ax, cx
	inc	bp56
	mov	cx, 8
	cmp	source_cs, 80h
	jnz	X28DA
	test	flags, FLAG_FONT_W
	jz	X2892
	mov	cx, 5
	jmp	short X2892
;
X28DA:	cmp	bp63, 2
	jnz	X2892
	test	flags, FLAG_FONT_W
	jz	X2892
	mov	cx, 2
	jmp	short X2892

X28EB:	mov	bp56, 0
	mov	bp68, 0
	cmp	al, 2
	jz	X28FB
X28F8:	jmp	wptr draw_func

X28FB:	mov	cx, bp4e
	cmp	source_cs, 80h
	jnz	X2906
	shr	cx, 1
X2906:	add	bp42, cx
	mov	cx, bp50
	cmp	source_cs, 80h
	jnz	X2914
	shr	cx, 1
X2914:	mov	bp54, cx
	or	cx, cx
	jz	X28F8
	jmp	X2896
;
X156A:	mov	al, es:[di].dfDefaultChar
	jmp	short X1588

X1570:	mov	cx, colors
	xor	draw_func, cx
X292A:	xor	cx, cx
	mov	bp54, cx
	cmp	bp68, cl
	jnz	X2942
	mov	source_cs, cl
X1576:	lodsb
	dec	abs_count
	jl	X15A8
	call	word ptr bp40
	jnc	X2945
X2942:	jmp	X2875

X2945:	cmp	al, es:[di].dfLastChar
	ja	X156A
	sub	al, es:[di].dfFirstChar
	jc	X156A
X1588:	cmp	al, es:[di].dfBreakChar
	jnz	X158E
	jmp	X153C
;
X158E:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	add	ax, 8
	pop	bx
	jz	X292A
	add	bx, cx
	ret

X15A8:
	add	clip_right, bx
	pop	ax
	jmp	strblt_22

X15AF:
	cmp	bp63, 1
	jnz	X298C
	mov	cx, draw_func	;XXX
	xor	cx, colors	;XXX
	add	cx, 6
	jmp	cx

X298C:
	mov	cx, colors
	xor	draw_func, cx
	mov	cx, char_xtra
	xor	ax, ax
	mov	source_cs, al
	add	bx, cx
	ret
;
write_to_mono:
	mov	dl, es:[di]
	xor	dl, bptr foreground
	and	dl, ah
	xor	es:[di], dl
	inc	di
	ret
;
; Write to a multiplane bitmap
;
write_to_cbitmap:
	push	bx
	mov	bx, plane_pitch
	mov	dl, es:[di]
	xor	dl, bptr foreground
	and	dl, ah
	xor	es:[di], dl
	mov	dl, es:[bx+di]
	xor	dl, bptr foreground+1
	and	dl, ah
	xor	es:[bx+di],dl
	add	bx,bx
	mov	dl, es:[bx+di]
	xor	dl, bptr foreground+2
	and	dl, ah
	xor	es:[bx+di], dl
	inc	di
	pop	bx
	ret
;
write_to_vram:
	cli
	mov	es:[di], ah
	sti
	inc	di
	ret
;
X29DB:	and	bp63, 1
	jnz	X29E7
	call	isprint
	jc	X2A05
	ret

X29E7:	inc	bp63
	mov	al, 80h
	cmp	bp64, 85h
	jz	X29F4
	mov	al, 0C0h
X29F4:	mov	source_cs, al
	stc
	ret
;
X29F9:	and	bp63,1
	jnz	X2A19
	call	isprint
	jc	X2A05
	ret
;
X2A05:	mov	bp64, al
	mov	source_cs, 80h
	cmp	al, 85h
	jz	X2A14
	mov	source_cs, 0C0h
X2A14:	inc	bp63
	stc
	ret

X2A19:	push	ax
	push	bx
	push	cx
	push	dx
	mov	ah, bp64
	call	X2C23
	mov	bx, cs
	mov	cx, offset X0C4D
	mov	dx, ax
	push	si
	mov	ah, 14h
	int	18h
	pop	si
	inc	bp63
	mov	source_cs, 80h
	cmp	bp64, 85h
	jz	X2A41
	mov	source_cs, 0C0h
X2A41:	push	ds
	push	es
	push	si
	push	di
	mov	ax, cs
	mov	ds, ax
	mov	es, ax
	mov	si, offset X0C4F
	mov	di, bp42
	test	flags, FLAG_FONT_H
	jnz	X2A7E
X2A57:	test	flags, FLAG_FONT_W
	jnz	X2ABB
X2A5D:	cmp	font_w_16, 1
	ja	X2AE0
	cmp	font_h_16, 1
	ja	X2AE0
	mov	cx, bp4c
	mov	si, offset X0C4F
	mov	di, bp42
	rep	movsw
X2A74:	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	stc	
	ret
;
X2A7E:	cmp	source_cs, 80h
	jz	X2AA1
	call	X2C4F
	mov	si, bp42
	mov	di, offset X0C4F
	mov	cx, 10h
	call	X2CEB
	mov	si, offset X0C4F
	mov	di, bp42
	call	X2C95
X2A9C:	call	X2D6D
	jmp	short X2A57
;
X2AA1:	call	X2C76
	mov	si, bp42
	mov	di, offset X0C4F
	mov	cx, 8
	call	X2CEB
	mov	si, offset X0C4F
	mov	di, bp42
	call	X2CC3
	jmp	short X2A9C

X2ABB:	mov	si, offset X0C4F
	mov	di, bp42
	mov	cx, 10h
	test	flags, FLAG_FONT_H
	jz	X2ACD
	mov	cx, 0Ah
X2ACD:	cmp	source_cs, 80h
	jz	X2ADB
	call	X2CEB
X2AD6:	call	X2D6D
	jmp	short X2A5D
;
X2ADB:	call	X2D3C
	jmp	short X2AD6
;
X2AE0:	mov	si, offset X0C4F
	mov	di, bp42
	mov	seg_bp5a, ds
	mov	seg_bp5e, es
	mov	bx, 2
	cmp	source_cs, 80h
	jnz	X2AF7
	shr	bx, 1
X2AF7:	mov	ax, bx
	mov	cx, 10h
	test	flags, FLAG_FONT_H
	jz	X2B05
	mov	cx, 0Ah
X2B05:	mul	cx
	add	si, ax
	mul	font_w_16
	mul	font_h_16
	add	di, ax
	dec	si
	dec	di
	std
	mov	ax,font_w_16
	mul	bx
	mov	dx, ax
	mov	bp60, cx
X2B1E:	dec	bp60
	jl	X2B57
	mov	off_bp5e, di
	mov	cx, bx
	mov	ax, font_w_16
	cmp	al, 2
	jz	X2B5F
	cmp	al, 3
	jz	X2B88
	cmp	al, 1
	jz	X2B5B
	jmp	X2BC3
;
X2B3A:	mov	off_bp5a, si
	mov	cx, font_h_16
	dec	cx
	jle	X2B1E
	mov	bp62, cx
	lds	si, bp5e
X2B49:	mov	cx, dx
	rep	movsb
	dec	bp62
	jg	X2B49
	lds	si, bp5a
	jmp	short X2B1E

X2B57:	cld
	jmp	X2A74
;
X2B5B:	rep	movsb
	jmp	short X2B3A

X2B5F:	lodsb
	mov	ah, al
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	stosb
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	stosb
	loop	X2B5F
	jmp	short X2B3A
;
X2B88:	lodsb
	mov	ah, al
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	stosb
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	stosb
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	stosb
	loop	X2B88
	jmp	X2B3A	

X2BC3:	lodsb
	mov	ah, al
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	stosb
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	stosb
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	stosb
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	shr	ax, 1
	sar	al, 1
	sar	al, 1
	sar	al, 1
	stosb
	loop	X2BC3
	jmp	X2B3A
;
isprint	proc	near
	cmp	al, 80h
	jb	isprnc
	cmp	al, 0A0h
	jc	isprc
	cmp	al, 0E0h
	jc	isprnc
	cmp	al, 0FDh
	jc	isprc
isprnc:	clc
	ret

isprc:	stc
	ret
;
isprint	endp

X2C23:	cmp	ah, 80h
	jz	X2C4E
	cmp	ah, 0A0h
	jnc	X2C32
	sub	ah, 70h
	jmp	short X2C3A

X2C32:	cmp	ah, 0F0h
	jnc	X2C4E
	sub	ah, 0B0h
X2C3A:	or	al, al
	jns	X2C40
	dec	al
X2C40:	add	ah, ah
	cmp	al, 9Eh
	jc	X2C4A
	sub	al, 5Eh
	jmp	short X2C4C
;
X2C4A:	dec	ah
X2C4C:	sub	al, 1Fh
X2C4E:	ret

X2C4F:	cld
	mov	bl, 2
X2C52:	mov	dh, 8
X2C54:	push	si	
	mov	dl, 2
X2C57:	mov	cx, 8
	xor	ah, ah
X2C5C:	shl	bptr [si], 1
	rcl	ah, 1
	inc	si
	inc	si
	loop	X2C5C
	xchg	al, ah
	stosb
	dec	dl
	jnz	X2C57
	pop	si
	dec	dh
	jnz	X2C54
	inc	si
	dec	bl
	jnz	X2C52
	ret
;
X2C76:	cld
	mov	dh, 8
X2C79:	push	si
	mov	dl, 2
X2C7C:	mov	cx, 8
	xor	ah, ah
X2C81:	shl	byte ptr [si], 1
	rcl	ah, 1
	inc	si
	loop	X2C81
	xchg	al, ah
	stosb
	dec	dl
	jnz	X2C7C
	pop	si
	dec	dh
	jnz	X2C79
	ret
;
X2C95:	cld
	mov	bl, 2
X2C98:	mov	dh, 8
	cmp	bl, 2
	jz	X2CA1
	mov	dh, 2
X2CA1:	push	si
	mov	dl, 2
X2CA4:	mov	cx, 8
	xor	ah, ah
X2CA9:	shl	byte ptr [si], 1
	rcl	ah, 1
	inc	si
	inc	si
	loop	X2CA9
	xchg	al, ah
	stosb
	dec	dl
	jnz	X2CA4
	pop	si
	dec	dh
	jnz	X2CA1
	inc	si
	dec	bl
	jnz	X2C98
	ret
;
X2CC3:	cld
	mov	bl, 2
X2CC6:	mov	dh, 8
	cmp	bl, 2
	jz	X2CCF
	mov	dh, 2
X2CCF:	push	si
	mov	cx, 8
	xor	ah, ah
X2CD5:	shl	byte ptr [si], 1
	rcl	ah, 1
	inc	si
	inc	si
	loop	X2CD5
	xchg	al, ah
	stosb
	pop	si
	dec	dh
	jnz	X2CCF
	inc	si
	dec	bl
	jnz	X2CC6
	ret
;
X2CEB:	lodsw
	xchg	al, ah
	mov	dx, ax
	and	ax, 2424h
	shl	ax, 1
	not	ax
	and	dx, ax
	mov	ax, dx
	and	ax, 9292h
	shr	ax, 1
	or	dx, ax
	xor	ax, ax
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	rcr	ax, 1
	shr	dx, 1
	shr	dx, 1	
	rcr	ax, 1
	shr	dx, 1
	rcr	ax, 1
	xchg	al, ah
	stosw
	loop	X2CEB
	ret

X2D3C:	lodsb
	mov	dl, al
	and	al, 24h
	shl	al, 1
	not	al
	and	dl, al
	mov	al, dl
	and	al, 92h
	shr	al, 1
	or	dl, al
	xor	al, al
	shr	dl, 1
	rcr	al, 1
	shr	dl, 1
	shr	dl, 1
	rcr	al, 1
	shr	dl, 1
	rcr	al, 1
	shr	dl, 1
	shr	dl, 1
	rcr	al, 1
	shr	dl, 1
	rcr	al, 1
	stosb
	loop	X2D3C
	ret
;
X2D6D:	mov	si, bp42
	mov	di, offset X0C4F
	mov	cx,16
	cmp	source_cs, 80h
	jnz	X2D7E
	shr	cx, 1
X2D7E:	rep	movsw
	ret

sEnd	Code
	end
