	
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	STRBLT.ASM
;
;   This module contains the strblt function and the ExtendedTextOut
;   function.
;
; Created: 17-Mar-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Strblt
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


FIXED_PITCH_ON = 1			;en/disables smartfix code


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.	?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.


?CHKSTK = 1
?CHKSTKPROC	macro
		endm


	.xlist
	include cmacros.inc
incFont 	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include control for gdidefs.inc
	include gdidefs.inc
	include display.inc
	include im1024.inc
	include macros.mac
	include strblt.inc
	include fontseg.inc
	.list


	??_out	strblt


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_WIDTH		;Screen width in pixels
	externA COLOR_FORMAT		;Color format (0103h or 0104h)

;	Other functions required for strblt.

ifdef	 EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif



sBegin	Code
assumes cs,Code
page

	externD		dest_device
	externD 	im1024_drawmode
	externW		im1024_x
	externW		im1024_y
	externW		im1024_rectw
	externW		im1024_recth
	externNP	im1024_send
	externNP	im1024_w_byte
	externB		im1024_tdefin
	externNP	X3CFB
	externB		xx_bkcolor
	externD		im1024_brush
	externB		shape_type
	externNP	X43D1
	externNP	im1024_setclip
	externNP	im1024_move
	externNP	im1024_exclude
	externNP	im1024_unexclude

;
; This translates characters from codepage 1252 (starting at 0xA0) into 
; codepage 437, which is what the card's ROM font uses.
;
xlt_cp1252	label byte
	db	20h	;NBSP -> space
	db	0ADh	;Upside-down pling
	db	09Bh	;Cent
	db	09Ch	;Pound sign
	db	000h	;Currency sign (unmapped)
	db	09Dh	;Yen
	db	07Ch	;Broken vertical bar -> vertical bar
	db	015h	;Section
	db	022h	;Umlaut -> quote
	db	00Ah	;Copyright -> white circle on black
	db	0A6h	;Feminine ordinal
	db	0AEh	;Open <<
	db	0AAh	;Logical negation
	db	0C4h	;Soft hyphen -> graphical horizontal line
	db	000h	;Registered (unmapped)
	db	000h	;Overline (unmapped)
	db	0F8h	;Degree sign
	db	0F1h	;Plus or minus
	db	0FDh	;Superscript 2
	db	000h	;Superscript 3
	db	000h	;Acute accent
	db	0E6h	;Micro
	db	014h	;Pilcrow
	db	0F9h	;Middle dot
	db	020h	;Cedilla
	db	000h	;Superscript 1
	db	0A7h	;Masculine ordinal
	db	0AFh	;Close >>
	db	0ACh	;One-quarter
	db	0ABh	;One-half
	db	000h	;Three-quarters
	db	0A8h	;Upside-down question mark
	db	000h	;A grave
	db	000h	;A acute
	db	000h	;A circumflex
	db	000h	;A tilde
	db	08Eh	;A umlaut
	db	08Fh	;A ring
	db	092h	;AE
	db	080h	;C cedilla
	db	000h	;E grave
	db	090h	;E acute
	db	000h	;E circumflex
	db	000h	;E tilde
	db	000h	;E umlaut
	db	000h	;I grave
	db	000h	;I acute
	db	000h	;I circumflex
	db	0E9h	;Eth -> Theta
	db	0A5h	;N tilde
	db	095h	;O grave -> o grave
	db	0A2h	;O acute -> o acute
	db	093h	;O circumflex -> o circumflex
	db	000h	;O tilde
	db	094h	;O umlaut -> o umlaut
	db	000h	;Multiplication
	db	0E8h	;O slash
	db	000h	;U grave
	db	000h	;U acute
	db	000h	;U circumflex
	db	09Ah	;U acute
	db	000h	;Y acute
	db	020h	;Thorn -> space
	db	0E1h	;sharp S
	db	085h	;a grave
	db	000h	;a acute
	db	083h	;a circumflex
	db	000h	;a tilde
	db	084h	;a umlaut
	db	086h	;a ring
	db	091h	;ae
	db	087h	;c cedilla
	db	08Ah	;e grave
	db	000h	;e acute
	db	088h	;e circumflex
	db	089h	;e umlaut
	db	08Dh	;i grave
	db	000h	;i acute
	db	08Ch	;i circumflex
	db	08Bh	;i umlaut
	db	020h	;eth
	db	0A4h	;n tilde
	db	095h	;o grave
	db	000h	;o acute
	db	093h	;o circumflex
	db	000h	;o bar
	db	094h	;o umlaut
	db	000h	;divide
	db	0EDh	;o slash
	db	097h	;u grave
	db	000h	;u acute
	db	096h	;u circumflex
	db	000h	;u umlaut
	db	098h	;y acute -> y umlaut
	db	000h	;thorn
	db	098h	;y umlaut
;
	public	strblt_brkchar
	public	X086C
	public	strblt_font
strblt_font	dd	0
strblt_clip	dd	0
strblt_string	dd	0
strblt_count	dw	0
strblt_pixw	dw	10h
strblt_pixh	dw	18h
;
; The text output command that will be sent to the IM1024
;
strblt_cmdlen	dw	0
strblt_command	db	8Bh	;Text write command (8Bh = TWRITE)
strblt_cmdbuf	db	256 dup(0)
strblt_pending	dw	0
strblt_tsize	db	3, 0, IM1024_TSIZE, 16, 0
black_brush	db	0
strblt_ascent	db	0
strblt_brkchar	db	20h
X086C	db	0

page
;--------------------------Exported-Routine-----------------------------;
; Strblt
;
; This is the old strblt entry point.  Null parameters are pushed
; for the ExtTextOut's extra parameters, and control given to
; ExtTextOut.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX = Y extent of string if extent call
;	AX = X extent of string if extent call
;	EGA registers in default state
; Error Returns:
;	DX:AX = 8000:0000H
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	See ExtTextOut
; History:
;	Thu 09-Apr-1987 13:36:08 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing

;
; WIN1 In Windows 1, STRBLT now becomes live!
;
cProc	Strblt,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

cBegin
	cld
	lds	si, lp_device
	mov	wptr dest_device, si
	mov	wptr dest_device+2, ds
	lodsw
	lds	si, lp_font
	mov	wptr strblt_font,si
	mov	wptr strblt_font+2,ds
	mov	bx,wptr [si].dfPixWidth
	mov	cx,wptr [si].dfPixHeight
	mov	dl,bptr [si].dfType+1		;Native font?
	mov	dh,bptr [si].dfBreakChar
	lds	si,lp_clip_rect
	mov	wptr strblt_clip,si
	mov	wptr strblt_clip+2,ds
	lds	si,lp_string
	mov	wptr strblt_string,si
	mov	wptr strblt_string+2,ds
	lds	si,lp_draw_mode
	mov	wptr im1024_drawmode,si	; 
	mov	wptr im1024_drawmode+2,ds
	mov	si,count
	mov	strblt_count,si
	mov	si,x
	mov	im1024_x,si
	mov	si,y
	mov	im1024_y,si
	mov	di,cs
	mov	ds,di
	mov	es,di
assumes ds,Code
assumes es,Code	
	mov	strblt_pixw,bx
	mov	strblt_pixh,cx
	mov	cx,count
	or	cx,cx

;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	jg	strblt_02
	jl	strblt_01
	jmp	strblt_exit
;
strblt_01:
	call	strblt_common
	jmp	strblt_exit
;
strblt_02:
	or	ax,ax
	jnz	strblt_03
	call	strblt_common
	jmp	strblt_exit
;
strblt_03:
	mov	strblt_brkchar, dh
	push	dx
	mov	strblt_command, IM1024_TWRITE
	or	dl,dl	;Using native font?
	jz	strblt_04
	mov	strblt_command, IM1024_TWRITE_ROM
strblt_04:
	push	es
	les	di,lp_clip_rect
	mov	ax,x
	and	ax,7FFFh
	push	ax
	mov	im1024_x, ax
	mov	ax,y
	and	ax,7FFFh
	push	ax
	mov	im1024_y, ax
	mov	ax, strblt_pixw
	or	ax,ax
	jnz	strblt_05
	call	measure_string
	jmp	short strblt_06
;
strblt_05:
	mul	cx
strblt_06:
	mov	im1024_rectw,ax
	add	ax, im1024_x
	push	ax
	mov	ax, im1024_y
	add	ax, strblt_pixh
	mov	dx, strblt_pixh
	mov	im1024_recth,dx
	push	ax
	call	im1024_exclude
	dec	wptr es:4[di]	
	dec	wptr es:6[di]	
	call	im1024_setclip
	pop	es
	cmp	strblt_command, IM1024_TWRITE
	jz	strblt_07
	mov	bx,strblt_pixw
	mov	wptr strblt_tsize+3, bx
	mov	si, offset strblt_tsize
	call	im1024_send
	jmp	short strblt_08
;
strblt_07:
	call	X3CFB
strblt_08:
	mov	ax, im1024_x
	mov	bx, im1024_y
	neg	bx
	call	im1024_move	;Move to correct position
	mov	wptr im1024_brush, offset black_brush
	mov	wptr im1024_brush+2, cs
	push	es
	les	di, im1024_drawmode
	cmp	es:[di].TBreakExtra,0
	jz	strblt_09
	cmp	strblt_command, IM1024_TWRITE_ROM
	jz	strblt_09
	call	X0A61
strblt_09:
	mov	al,bptr es:[di].dfAscent
	mov	dl,bptr es:[di].dfVertRes
	pop	es
	mov	strblt_ascent,al
	mov	xx_bkcolor, dl
	mov	shape_type, SHAPE_STRING
	mov	al, 0
	call	X43D1
	mov	strblt_pending, 0
	cmp	cx, 0FFh	;If there are fewer than 256 chars we can do
	jbe	strblt_10	;them all in one go
	mov	ax, 0FFh
	xchg	ax, cx
	sub	ax, cx
	mov	strblt_pending, ax
strblt_10:
	mov	di,offset strblt_cmdlen
	mov	[di+3],cl	;Length of parameter
	mov	[di],cx		;Length of command
	add	wptr[di],2	;Plus length of command itself
	pop	dx
	push	ds
	lds	si,lp_string
	add	di,4
	cmp	dl, 53h		;Font translation needed?
	jnz	strblt_13
	mov	bx,offset xlt_cp1252
strblt_11:
	push	bx
	lodsb
	cmp	al,0A0h		;Characters below 0A0h are not mapped
	jc	strblt_12
	sub	al,0A0h
	xor	ah,ah
	add	bx,ax
	mov	al,cs:[bx]	;Otherwise do the lookup
strblt_12:
	stosb
	pop	bx
	loop	strblt_11
	jmp	short strblt_14
;
strblt_13:
	rep	movsb
strblt_14:
	pop	ds
	mov	si, offset strblt_cmdlen
	call	im1024_send
	call	im1024_unexclude
	mov	ax,1

strblt_exit:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Eh
cEnd	<nogen>

;
; For variable-width fonts, measure how wide each character is in pixels
;
measure_string:	
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	les	di,lp_font
	lds	si,lp_string
	mov	dl,es:[di].dfFirstChar
	mov	di,offset dfCharOffset
	xor	bx,bx
measure_1:
	push	di
	lodsb		;Next character from string
	xor	ah, ah
	sub	al, dl	;Character number in font
	shl	ax, 1
	add	di, ax
	mov	ax, es:[di+2]	;Right edge
	sub	ax, es:[di]	;Left edge
	add	bx, ax
	pop	di
	loop	measure_1
	mov	ax, bx		;Result
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	ret
;
; ES:DI -> Drawmode
;
X0A61:	pusha		;286 instruction!
	mov	al,X086C
	xor	ah,ah
	add	ax,es:[di].BreakExtra
	mov	bx,es:[di].BreakErr
	sub	bx,es:[di].BreakRem
	jns	X0A7A
	inc	ax
	add	bx,es:[di].BreakCount
X0A7A:	mov	es:[di].BreakErr, bx
	mov	si,offset im1024_tdefin
	mov	cl,strblt_brkchar
	mov	[si+3],cl
	mov	[si+4],al	;Define brkchar as AL
	call	im1024_send	;Send the start of the TDEFIN command
	xor	ah, ah
	mov	bl,[si+5]
	xor	bh,bh
	mul	bx
	mov	bx,8
	mov	cx,ax
	xor	al,al
	shr	cx,1
	shr	cx,1
	shr	cx,1
	jnc	X0AA7
	inc	cx		;CX = Length of definition
X0AA7:	call	im1024_w_byte	;Define it to blank
	loop	X0AA7
	popa
	ret
;
; This is what, in other drivers, would the the public strblt entry point.
; Here I think it is the generic non-accelerated code path.
;
cProc	strblt_common,<PASCAL>

	parmD	lp_device		;Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

;	ExtTextOut parameters we have to dummy up.
;
;	parmD	lp_dx			;Widths for the characters
;	parmD	lp_opaque_rect		;Opaquing rectangle
;	parmW	eto_options		;ExtTextOut options

	localW	bp4
	localW	abs_count		;*[bp-6] WIN1
	localW 	local_str		;*[bp-8] WIN1
	localW	next_scan		;*[bp-0a] Index to get to next scan line
	localW	y_step			;*[bp-0c] Y step
	localW	back_step		;*[bp-0e] Y backstep
	localW	draw_func		;*[bp-10]
	localB	num_planes		;Number of planes in a bitmap
	localB	opaque_routine		;Routine which does actual opaquing
	localW	colors			;Text/background colors
;		^--- this is probably actually opaque_routine
	localW	next_plane		;Index to get to next plane
	localW	fontw_bytes		;*[bp-18h] Source font width (bytes)
	localW	opaque_height		;Height of opaque box (sometimes)
	localW	clip_left		;*[bp-1c] WIN1
	localW	clip_right		; [bp-1e] WIN1
;;;	localD	lp_surface		;Pointer to first byte of destination
	localW	temp_off_lp_bits	;Intermediate pointer to dev surface
	localW	scan_start		;Delta from start of scan
	localW	clipped_font_height	;Actual height of bits to be drawn
;
; BP-24h
;
;;;	localW	tot_brk_extra		;Total break extra
	localW	df_pixel_w		; WIN1 font pixel width
	localW	brk_extra		;*# extra pixels to add each break char
	localW	brk_err 		;*Justification DDA error term
	localW	brk_rem 		;*  extra pixels are distributed
	localW	brk_count		;*DDA - # breaks into which BrkRem
	localW	char_xtra		;*# extra pixels to add each char




cBegin
	if	???			;Do test only if locals
	jc	j_exit_strblt		;No room for locals, return now
	endif

	mov	ax, cs:strblt_count
	cwd
	xor	ax,dx			;Force positive
	shl	ax, 1			;Check that there's room on the stack
	shl	ax, 1			;for the string
	add	ax, 20h			;at 4 bytes / character + 32 overhead
	mov	cx, ax
	call	my_check_stack
	jnc	strblt_001
j_exit_strblt:
	jmp	exit_strblt
;
strblt_001:
	add	sp, cx
	mov	local_str, sp	
	lds	si, cs:strblt_clip
	les	di, cs:strblt_font
	
;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	mov	ax,cs:strblt_count
	or	ax,ax
	jz	j_only_draw		;No chars, might have opaque rect
	jg	strblt_002		;Positive count, output string
	neg	ax
	xor	bx, bx
	mov	word ptr cs:strblt_clip, bx
strblt_002:
	mov	abs_count, ax
	mov	cx, es:[di].dfWidthBytes
	mov	fontw_bytes, cx
	mov	ax, es:[di].dfPixWidth
	mov	df_pixel_w, ax
	or	si, si			;Clip rectangle present?
	jz	strblt_005
	mov	ax, [si].top
	mov	dx, ax
	sub	ax, cs:im1024_y
	mov	bx, ax
	jge	strblt_003
	sub	dx, bx
	xor	bx, bx
strblt_003:
	mov	temp_off_lp_bits,dx
	mov	scan_start,dx
	mov	dx, es:[di].dfPixHeight
	cmp	bx, dx
	jge	j_only_draw
	mov	ax, [si].bottom
	sub	ax, cs:im1024_y
	cmp	ax, dx
	jl	strblt_004
	mov	ax, dx
strblt_004:
	or	ax, ax
	jle	j_only_draw
	cmp	ax, bx
	jle	j_only_draw
	jmp	short strblt_006
	nop

j_only_draw:
	jmp	only_draw


strblt_005:
	mov	bx, cs:im1024_y
	mov	temp_off_lp_bits,bx
	mov	scan_start,bx
	xor	bx, bx
	mov	ax, es:[di].dfPixHeight
strblt_006:
	sub	ax, bx
	mov	clipped_font_height,ax
	add	scan_start, ax
	add	ax, bx
	mul	cx
	mov	dx,wptr es:[di].dfBitsPointer
	add	ax, dx
	dec	ax
	mov	opaque_height, ax
	mov	ax, bx
	mov	si, bx
	mov	bx, dx
	mul	cx
	add	ax, bx
	dec	ax
	mov	next_plane,ax
	mov	ax, si
	lds	si, cs:im1024_drawmode
	mov	brk_err, 0
	cmp	word ptr es:[di].dfPixWidth, 0
	jz	strblt_008
	mov	dx, offset X152D
	mov	wptr opaque_routine,dx		
	cmp	[si].TBreakExtra,0
	jz	strblt_007
	mov	dx, offset X1553
	mov	wptr opaque_routine,dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_007:
	mov	dx, [si].CharExtra
	mov	si, offset X1511
	or	dx, dx
	jz	strblt_010
	mov	si, offset X150B
	mov	char_xtra,dx
	xor	dx, dx
	mov	df_pixel_w, dx
	jmp	short strblt_010
	nop
;
strblt_008:
	mov	dx, offset X158E
	mov	wptr opaque_routine, dx
	cmp	[si].TBreakExtra, 0
	jz	strblt_009
	mov	dx, offset X153F
	mov	wptr opaque_routine, dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_009:	
	mov	dx, [si].CharExtra
	mov	si, offset X1576
	or	dx, dx
	jz	strblt_010
	mov	si, offset X1570
	mov	char_xtra, dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_010:
	mov	draw_func, si
	xor	si, offset X15AF
	mov	colors, si		;XXX
	lds	si, cs:dest_device
	mov	dx, [si].bmWidthBytes
	add	ax, cs:im1024_y
	xor	cx, cx
	mov	bx, dx
	xor	di, di
	cmp	[si].bmType, cx		;Main memory bitmap?
	jz	strblt_010b		;Redundant code
strblt_010b:
	mul	dx
	add	ax, di
	mov	y_step, bx		; XXX y_step and back_step are 
	mov	back_step, cx		; correct here... which means 
	lds	si, cs:strblt_clip	; previous references are incorrect
	mov	bx, cs:im1024_x
	or	si, si
	jz	strblt_015
	mov	cx, [si].left
	mov	clip_left, cx
	mov	di, bx
	mov	dx, [si].right
	mov	clip_right, dx
	sub	dx, cx
	sub	bx, cx
	jl	strblt_011
	mov	clip_left, di
	mov	cx, di
	sub	dx, bx
	xor	bx, bx
strblt_011:
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di		;XXX
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	add	ax, cx
	mov	next_scan, ax	;XXX
	cmp	bx, dx
	jge	j2_only_draw
	lds	si, cs:strblt_string
	les	di, cs:strblt_font
strblt_012:
	call	word ptr draw_func
	jle	strblt_012
	or	ax, ax
	jz	strblt_014
	add	ax, cx
	sub	ax, bx
	mov	cx, bx
	sub	bx, dx
strblt_013:
	jge	strblt_21
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	call	word ptr draw_func
	jmp	short strblt_013
;
strblt_014:
	add	ax, cx
	sub	ax, bx
	and	ax, 7
	mov	cx, bx
	sub	bx, dx
	jmp	short strblt_013
;
strblt_015:
	mov	clip_left, bx
	mov	clip_right, bx
	mov	cx, bx
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	;XXX
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	add	ax, bx
	mov	next_scan, ax	;XXX
	lds	si, cs:strblt_string
	les	di, cs:strblt_font
	xor	bx, bx
strblt_16:
	call	word ptr draw_func
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	jmp	short strblt_16
;
j2_only_draw:	
	jmp	only_draw

strblt_20:
	pop	dx
	pop	si
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	push	si
	push	dx
	jmp	short strblt_23
	nop
;
strblt_21:
	sub	cx, bx
	jle	strblt_22
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
strblt_22:
	cmp	sp, local_str
	jz	j2_only_draw
	cmp	df_pixel_w, 8
	jz	strblt_20
strblt_23:
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	lds	si, cs:im1024_drawmode
	mov	ax, cs:strblt_count
	or	ax,ax
	jg	strblt_25
	mov	ax, brk_err
	or	ax,ax
	jz	strblt_24
	mov	[si].BreakErr, ax
strblt_24:
	mov	ax, clip_right
	sub	ax, clip_left
	mov	dx, scan_start
	sub	dx, temp_off_lp_bits
	jmp	only_draw
;
strblt_25:
	cmp	[si].bkMode, 1
	jnz	strblt_26
	jmp	strblt_34
;
strblt_26:
;
	mov	al,bptr [si].bkColor
	xor	ah,ah
	mov	si,ax
	mov	cx, clip_left
	mov	ax, cx
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	dl, 0FFh
	and	cx, word ptr 7
	shr	dl, cl		;Left fringe
	mov	cx, clip_right
	dec	cx
	mov	bx, cx
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	mov	dh, 0FFh
	and	cx, word ptr 7
	sub	cx, 7
	neg	cx
	shl	dh, cl		;Right fringe
	inc	ax
	sub	bx, ax
	jge	strblt_27
	and	dl, dh		;Left fringe = right fringe
strblt_27:
	mov	cx,bx	
	mov	clip_left, cx
	les	di, cs:dest_device
	les	di, es:[di].bmBits
	add	di, next_scan	
	mov	bx, y_step
	mov	al, 0FFh
	or	si, si		;Solid white or solid black?
	jnz	strblt_31	
	not	al		;Solid black, so mask out everything
	not	dx
strblt_28:
	mov	si,di
	and	es:[di],dl	;Left fringe
	inc	di
	or	cx,cx		;Middle exists?
	jl	strblt_30
	jz	strblt_29
	rep	stosb		;Fill middle range
strblt_29:
	and	es:[di],dh	;Right fringe
strblt_30:
	mov	di, si		;Back to start of row
	add	di, bx		;Move to next row
	mov	cx, clip_left
	dec	clipped_font_height
	jg	strblt_28
	jmp	short strblt_34
	nop
;
strblt_31:
	mov	si,di
	or	es:[di],dl	;Left fringe
	inc	di
	or	cx,cx
	jl	strblt_33
	jz	strblt_32
	rep	stosb		;Centre if present
strblt_32:
	or	es:[di],dh	;Right fringe
strblt_33:
	mov	di, si		;Back to start of row
	add	di, bx		;Move to next row
	mov	cx, clip_left
	dec	clipped_font_height
	jg	strblt_31
strblt_34:
	xor	dx,dx
	lds	si,cs:im1024_drawmode
	cmp	bptr [si].TextColor, 1
	sbb	dl,dl
strblt_42:
	lds	si,cs:strblt_font
	lds	si,[si].dfBitsPointer
	les	di,cs:dest_device
	les	di,es:[di].bmBits
	add	di,next_scan
	mov	next_scan,di
	jmp	strblt_52

strblt_43:
	add	cl,dh
	shl	ax,cl
	mov	cl,dh
	mov	dh, es:[di]
	xor	dh,dl
	or	ah,dh
	xor	ah,dl
	xchg	ah,al
	stosb
	xchg	ah,al
	mov	dh,8
	neg	cl
	jz	strblt_45
strblt_44:
	sub	dh,cl
	jle	strblt_43
	shl	ax, cl
strblt_45:
	cmp	ch, 8
	ja	strblt_47
	or	ch, ch
	jz	strblt_49
	xor	al, al
	or	si, si
	jz	strblt_46
	lodsb
strblt_46:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_47:
	xor	al, al
	or	si, si
	jz	strblt_48
	lodsb
strblt_48:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_44
strblt_49:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al, al
	or	si, si
	jz	strblt_50
	add	si, next_plane
	lodsb
strblt_50:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_44
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_51:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	mov	al, es:[di]
	xor	al,dl
	or	al,ah
	xor	al,dl
	stosb
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_53
	mov	next_plane, si
	mov	bx, y_step
	mov	di, bx
	add	di, next_scan
	mov	next_scan, di
	mov	y_step, bx
strblt_52:
	mov	bx,local_str
	xor	ax,ax
	mov	dh,bptr bp4
	cmp	df_pixel_w, 8
	jz	strblt_54
	jmp	short strblt_49
;
strblt_53:
	jmp	only_draw

strblt_54:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl		;Right fringe
	cmp	dh, cl
	jg	strblt_55
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_59
	mov	cl, 8
	jmp	short strblt_57
	nop
;
strblt_55:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_60
	nop

strblt_56:
	lodsb
strblt_57:
	mov	dh, es:[di]
	xor	dh, dl
	or	al, dh
	xor	al, dl
	stosb
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si,next_plane
	jmp	short strblt_56
;
strblt_58:
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_59:
	neg	cl
	mov	dh, es:[di]
	xor	dh,dl
	or	al,dh
	xor	al,dl
	stosb
	rol	ax, cl
	sub	cl, 8
strblt_60:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	jmp	short strblt_58
strblt_61:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_49
;
only_draw:
	mov	sp, local_str
;;;	call	unexclude
exit_strblt:
	mov	sp, bp
	pop	bp
	ret

cEnd	<nogen>

X1505:	mov	al, es:[di].dfDefaultChar
	jmp	short X1523
	nop
;
X150B:	mov	cx,colors
	xor	draw_func,cx
X1511:	lodsb
	dec	abs_count
	jl	X1535
	cmp	al, es:[di].dfLastChar
	ja	X1505
	sub	al, es:[di].dfFirstChar
	jb	X1505
X1523:	mov	cx, es:[di].dfPixWidth
	cmp	al, es:[di].dfBreakChar
	jz	X153C
X152D:	mul	cl
	add	ax, 8
	add	bx, cx
	ret
;
X1535:	add	clip_right, bx
	pop	ax
	jmp	strblt_22
;
X153C:	jmp	wptr opaque_routine
;
X153F:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	pop	bx
	jz	X1576
X1553:	add	cx, brk_extra
	mov	ax, brk_err
	sub	ax, brk_rem
	jg	X1562
	add	ax, brk_count
	inc	cx
X1562:	mov	brk_err, ax
	xor	ax, ax
	add	bx, cx
	ret
;
X156A:	mov	al, es:[di].dfDefaultChar
	jmp	short X1588
	nop

X1570:	mov	cx, colors
	xor	draw_func, cx
X1576:	lodsb
	dec	abs_count
	jl	X15A8
	cmp	al, es:[di].dfLastChar
	ja	X156A
	sub	al, es:[di].dfFirstChar
	jc	X156A
X1588:	cmp	al, es:[di].dfBreakChar
	jz	X153C
X158E:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	add	ax, 8
	pop	bx
	jz	X1576
	add	bx, cx
	ret

X15A8:
	add	clip_right, bx
	pop	ax
	jmp	strblt_22

X15AF:
	mov	cx, colors
	xor	draw_func, cx
	mov	cx, char_xtra
	xor	ax, ax
	add	bx, cx
	ret

sEnd	Code
	end
