        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	SCANLR.ASM
;
;   This module contains the ScanLR routine.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	ScanLR
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   ScanLR is used to search a scanline for a pixel of the given
;   color or one which isn't of the given color.  This is usually
;   used by the floodfill simulation.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDrawMode	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include im1024.inc
	include macros.mac
	.list



;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_WIDTH		;Screen width in pixels
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_HEIGHT		;Screen height in scans
	externA COLOR_FORMAT		;Color format (0103h or 0104h)


ifdef	EXCLUSION
	externNP  exclude		;Exclude area from screen
	externNP  unexclude		;Clear excluded area
endif
	externNP  imagex_read
	externNP  im1024_unexclude
	externNP  im1024_exclude
	externW	im1024_y
	externW	im1024_x
	externW	im1024_rectw
	externW	im1024_recth
	externW	im1024_linex
	externW	im1024_liney
	externD	source_device
	externD	dest_device
	externW Y_OFFSETS
	externB X194A

;	Define the flag values which control the direction
;	and type of the scan.

STEP_LEFT	equ	00000010b	;Flag values for DirStyle
STEP_RIGHT	equ	00000000b
FIND_COLOR	equ	00000001b
FIND_NOT_COLOR	equ	00000000b


;	Define the type flags used to determine which type
;	of scan needs to be performed (color or mono).

COLOR_OP	equ	NUMBER_PLANES
MONO_OP 	equ	1


;	Define the error conditions which will be returned

ERROR_CLIPPED	equ	8000h		;Coordinate was clipped
ERROR_NOT_FOUND equ	-1		;Stop condition not reached

sBegin	Code
assumes cs,Code

;
; This is the start of a BITMAP structure for a single screen line
;
dev_1014	dw	0		;bmType 
		dw	SCREEN_WIDTH	;bmWidth
		dw	1		;bmHeight
		dw	SCREEN_WIDTH	;bmWidthBytes
		db	1		;1 plane
		db	8		;8 bits / pixel
		dw	offset X194A,0	;bmBits
		dw	SCREEN_WIDTH	;bmWidthPlanes

rot_bit_tbl	label	byte
		db	10000000b	;Table to map bit index into
		db	01000000b	;  a bit mask
		db	00100000b
		db	00010000b
		db	00001000b
		db	00000100b
		db	00000010b
		db	00000001b


page

;--------------------------Exported-Routine-----------------------------;
; ScanLR
;
;   ScanLR - Scan left or right
;
;   Starting at the given pixel and proceeding in the choosen direction,
;   the pixels are examined for the given color until one is found that
;   matches (or doesn't match depending on the style).  The X coordinate
;   is returned for the pixel that matched (or didn't match).
;
;   The physical device may be the screen, a monochrome bitmap, or a
;   bitmap in our color format.
;
;   There will be no error checking to see if the bitmap is in our
;   color format.  If it isn't, it will be treated as if it were a
;   monochrome bitmap.
;
; Entry:
;	EGA registers in default state
; Returns:
;	AX = x location of sought pixel
; Error Returns:
;	AX = -1 if nothing found
;	AX = 8000h if clipped
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude
;	unexclude
; History:
;	Fri 01-May-1987 12:30:45 -by-  **** ***** [*****]
;	Output to GRAF_CDC for Win386 support.
;
;	Sun 22-Feb-1987 16:29:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing


cProc	ScanLR,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;ptr to a physical device
	parmW	x			;x coordinate of search start
	parmW	y			;y coordinate of search start
	parmD	color			;color for the search
	parmW	dir_style		;control and search style

;;;	localB	planes			;#Planes
;;;	localW	next_plane		;*[bp-6] index to next plane if color

cBegin
;;;	mov	al,enabled_flag 	;Load this before trashing DS
	lds	si,lp_device		;--> physical device
	assumes ds,nothing
	mov	cx,[si].bmType		;Get bitmap type
	jcxz	scan_30 		;Device is a memory bitmap
	jmp	scan_200		;Device is the screen
;
scan_30:
	les	di, lp_device
	lds	si, es:[di].bmBits		;Get device bitmap
	mov	ax, y
	mov	di, es:[di].bmWidthBytes	;Get width in bytes
	mul	di
	add	si, ax				;Address of row
	mov	cx, x
scan_80:
	mov	bx,cx
	shiftr	cx,3			;Compute byte offset in scan
	add	si,cx			;DS:SI --> byte with start pixel
	mov	ax,ds			;Will be working off both DS: and ES:
	mov	es,ax
	assumes es,nothing


;	Set cx to be the byte count for searching left.  Must adjust it
;	to include the byte pixel is in.

	inc	cx			;Adjust for partial byte


	mov	ax, wptr color
	mov	dx, dir_style
	shr	dx, 1
	jnc	scan_40
	not	ax
scan_40:

;	Compute the mask for the first byte (the partial byte).  Since
;	the defaults being set up are for searching left, this can be done
;	by getting the rotating bitmask for the pixel and decrementing it,
;	then using the logical NOT of the mask.  The mask will be used
;	for masking the bits to test in the partial (first) byte.
;
;		Bitmask 	  Mask		NotMask
;
;		10000000	01111111	10000000
;		01000000	00111111	11000000
;		00100000	00011111	11100000
;		00010000	00001111	11110000
;		00001000	00000111	11111000
;		00000100	00000011	11111100
;		00000010	00000001	11111110
;		00000001	00000000	11111111


	and	bx,word ptr 00000111B	;Get bit mask for bit
	mov	bl,rot_bit_tbl[bx]	;Assume we're going left.
	dec	bl			;Create mask

;	The assumption has been made that the scan will be right to left.
;	If the scan is left to right, then the first byte mask and the
;	byte count must be adjusted.
;
;	Also set up the correct bias for getting back to the interesting
;	byte for the rep scasb instruction (DI is always updated by one
;	byte too many).


	std				;Assume search left
	shl	dx,1
	dec	dx			;(to counter post decrement)
	jg	scan_100

	page
;	Compute the first byte mask for the first byte for stepping right.
;
;		Current 	  SHL		  INC		  NOT
;
;		01111111	11111110	11111111	00000000
;		00111111	01111110	01111111	10000000
;		00011111	00111110	00111111	11000000
;		00001111	00011110	00011111	11100000
;		00000111	00001110	00001111	11110000
;		00000011	00000110	00000111	11111000
;		00000001	00000010	00000011	11111100
;		00000000	00000000	00000001	11111110


	cld				;Going right, fix up dir flag
	shl	bl,1			;Fix up first bit mask per above
	inc	bl
	not	bl

;	Compute the number of bytes from current position to end of scanline
;	and set adjustment to counter the rep's post increment

	sub	cx,di			;Fix up byte count
	neg	cx
	inc	cx




;	Set the pixel count for the entire scan.  The scanning will actually
;	continue until the end of the scan as given in bmWidthBytes, and
;	the result clipped to bmWidth.

scan_100:
	not	bl			;Need inverse of the first byte mask
	shiftl	di,3			;Set DI = pixel count of entire scan
	lodsb				;Read bitmap
	xor	al,ah
	and	al,bl			;Colour did not match, go to next
	jnz	scan_110		;pixel
	mov	al,ah
	dec	cx
	jz	scan_160		;Reached end of scan
	xchg	si,di
	rep	scasb			;Search for requested pixel
	jz	scan_160		;Found
	inc	cx
	xchg	si,di
	add	si,dx
	lodsb
	xor	al,ah
scan_110:
	shl	cx,1	
	shl	cx,1	
	shl	cx,1	
	or	dx,dx
	jg	scan_130
	sub	cx,di
	neg	cx
	dec	cx
scan_120:
	inc	cx
	shl	al, 1
	jnc	scan_120
	lds	si,lp_device
	cmp	cx,[si].bmWidth
	jge	scan_160
	jmp	short scan_140
;
scan_130:
	dec	cx
	shr	ax, 1
	jnc	scan_130
scan_140:
	mov	ax, cx
scan_150:
	cld
	pop	di
	pop	si
	sub	bp,2
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	retf	0Eh
;
scan_160:
	mov	ax, -1
	jmp	short scan_150


	page
;
; For reading from the screen
;
scan_200:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	assumes ds,Code
	assumes	es,Code
	mov	ax,0	;Left
	mov	bx,1023	;Right
	push	ax
	push	y
	push	bx
	push	y
	call	im1024_exclude
	push	es
	mov	di,offset dev_1014	;A 1024x1 bitmap for that screen line
	mov	wptr [di].bmBits + 2, es
	mov	wptr cs:dest_device, di
	mov	wptr cs:dest_device+2, es
	mov	cs:im1024_x, 0
	mov	cs:im1024_y, 0
	mov	ax,y
	mov	cs:im1024_liney, ax
	mov	cs:im1024_recth, 1
	mov	cs:im1024_linex, 0
	mov	cs:im1024_rectw, SCREEN_WIDTH
	les	di,lp_device
	mov	wptr cs:source_device,di
	mov	wptr cs:source_device+2, es
	pop	es
	call	imagex_read
	call	im1024_unexclude
	mov	di, offset X194A	;Buffer retrieved
	mov	ax,x
	add	di,ax			;Address of point within buffer
	mov	dx,dir_style
	test	dl,2
	jnz	scan_210
	cld
	mov	cx,SCREEN_WIDTH
	sub	cx,ax
	jmp	short scan_220
;
scan_210:
	std
	mov	cx, ax
scan_220:
	mov	ax, wptr color
	test	dl, 1
	jnz	scan_230
	rep	scasb
	jmp	short scan_240
;
scan_230:
	repne	scasb
scan_240:
	jcxz	scan_260
	mov	ax, di
	dec	ax
	test	dl, 2
	jz	scan_250
	add	ax, 2
scan_250:
	sub	ax, offset X194A
	jmp	scan_150
;
scan_260:
	mov	ax, ERROR_NOT_FOUND
	jmp	scan_150

cEnd <nogen>
	
sEnd	Code

ifdef	PUBDEFS
	include scanlr.pub
endif

	end
