	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	ROBJECT.ASM
;
; This module contains the code which realizes the objects required
; by GDI.
;
; Created: 19-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	RealizeObejct
;
; Public Functions:	
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incLogical	=	1		;Include control for gdidefs.inc


	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include macros.mac
	.list


	??_out	robject


sBegin	Code
assumes cs,Code

	externNP	map_RGB_colors
page
;--------------------------Exported-Routine-----------------------------;
; RealizeObject
;
;   RealizeObject - Logical to Physical Object Realization
;
;   RealizeObject performs the task of converting logical objects
;   into physical objects that this driver can manipulate to per-
;   form the various functions requested of it.
;
;   The size needed to realize an object will be returned if the
;   pointer to where the physical realization is to be stored is
;   NULL.
;
;   In some cases where the driver cannot realize the requested object,
;   a solid color pen must be realized which GDI will use when it
;   performs the nessacary simulations.  In other cases, punt.
;
; Entry:
;	None
; Returns:
;	AX = object size if ok
; Error Returns:
;	AX = 0	if error or object unrealizable
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;
; History:
;	Mon 16-Feb-1987 18:09:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing


cProc	RealizeObject,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Pointer to Device structure
	parmW	style			;Style of realization
	parmD	lp_in_obj		;Pointer to input (logical) object
	parmD	lp_out_obj		;Pointer to output (physical) object
	parmD	lp_text_xform		;Pointer to a text transformation
					;  or (x,y) for brush realization
					;  Segment = y, Offset = x

;;;	localW	plane_start
;;;	localB	brush_accel		;Temp brush accelerator
;;;	localB	prev_dither		;Brush dither value
;;;	localW	bw_sum			;Black & white sum for a brush
;;;	localV	l_brush,%(size oem_brush_def)

cBegin
	push	ds
	lds	si,lp_in_obj		;Not sure this was needed!
	lds	si,lp_out_obj	
	pop	ds

	cld				;Following code assumes this
;;;	mov	ax,1			;Assume good exit
	mov	bx,style		;If delete object, nothing to do
	or	bx,bx			;  since we don't keep objects
	jns	realize_10
	jmp	realize_exit1		;This is a delete object
realize_10:
	lds	si,lp_in_obj		;--> logical object
	assumes ds,nothing

;;;	dec	ax			;Assume error (AX = 0 as return code)
	dec	bx			;Determine style of realization.
	cmp	bx,OBJ_FONT-1		;Is it a legal object?
	jg	j_realize_exit0		;  Not by our standards, return error
	shl	bx,1			;Compute index into dispatch table
	mov	ax, wptr lp_out_obj	;If lp_out_obj is NULL, then return
	or	ax, wptr lp_out_obj+2	;  size requirement?
	jz	return_obj_size 	;They want the size
	jmp	cs:realize_dispatch[bx] ;Realize a physical object

return_obj_size:
	mov	ax,cs:realize_sizes[bx] ;Get size for the object
	jmp	realize_exit

j_realize_exit0:
	jmp	realize_exit0

page
;--------------------------Private-Routine------------------------------;
; realize_pen
;
;   Realize Logical Pen Into a Physical Pen
;
;   The given logical pen is realized into a physical pen.
;
;   The pen will be realized regardless of the pen width or
;   style since GDI will need a pen to use for simulations.
;
;   If the width of the pen is >1, then a solid pen will be
;   realized regardless of the pen style.  GDI will use this
;   pen for simulating the wide line.
;
;   If the pen style isn't recognized, then a solid pen of
;   the given color will be realized (this is called punting).
;
; Entry:
;	DS:SI --> logical pen definition
;	ES:DI --> output object
; Returns:
;	AX non-zero to show success
; Error Returns:
;	No error return.
; Registers Preserved:
;	BP,DS,ES
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,FLAGS
; Calls:
;	sum_RGB_colors
; History:
;	Thu 19-Feb-1987 14:06:41 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


realize_pen:
	mov	cx,[si].lopnStyle	;If a NULL pen, then all that really
	cmp	cx,LS_NOLINE		;  needs to be stored is the pen
	je	realize_pen_30		;  type so it can be recognized
	cmp	[si].lopnWidth,2	;If not a nominal width pen,
	jb	realize_pen_20		;  make a solid pen for simulations
realize_pen_10:
	mov	cx, LS_SOLID
realize_pen_20:
	cmp	cx,MaxLineStyle 	;If the line style is unknown
	jg	realize_pen_10		;  make it a solid pen
realize_pen_30:
	mov	ax,[si].lopnColor
	mov	dl,[si].lopnColor+2	
	call	map_RGB_colors		;Sum up the color
	mov	ah, dh
	mov	al, cl
	les	di,lp_out_obj

	stosw				;Save color of pen
	jmp	realize_exit1	

	errnz	oem_pen_pcol		;Must be first field

page
;--------------------------Private-Routine------------------------------;
; realize_brush
;
;   Realize Logical Brush Into a Physical Brush
;
;   Four styles of logical brushes may be realized.  These are SOLID,
;   HOLLOW, HATCHED, and PATTERN.
;
;   A SOLID brush is defined with a logical RGB color definition.
;   This color is processed into one of 65 dithers.
;
;   A HATCHED brush is defined with a logical RGB color definition and
;   a hatching type.  The hatch type is mapped to one of the six hatched
;   styles that the driver supports.  All bits in the hatched brush which
;   are 1 are set to the hatch color passed in, and all bits which are
;   0 are set to the background color passed in.
;
;   A PATTERN brush is defined with an 8 X 8 pattern in the form of a
;   physical bitmap.  The bitmap may be monochromw or color.  More
;   discussion on converting is contained under the pattern brush code.
;
;   A HOLLOW brush is one which can never be seen.  The brush style is
;   maintained in the device brush structure so that a check can be
;   made and an abort executed if one is used.	No punting is needed
;   for hollow brushes.
;
;   Brushes will be aligned based at the (x,y) origin passed in via
;   the text transform.
;
; Entry:
;	DS:SI --> logical pen definition
;	ES:DI --> output object
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;
; History:
;	Thu 19-Feb-1987 14:06:41 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


realize_brush:
	les	di,lp_out_obj
	lodsw
	cmp	al, BS_PATTERN
	jz	rbrush_pattern
	cmp	al, BS_HATCHED
	jnz	rbrush_solid
	jmp	short rbrush_hatched
	nop
;
rbrush_solid:
	cmp	al, BS_HOLLOW
	jz	rbrush_solid1
	xor	al,al			;If an illegal brush, create
					;  a solid brush
rbrush_solid1:
	stosb
	lodsw
	mov	dx, ax
	lodsw
	xchg	ax,dx			;DLAX = colour
	call	map_RGB_colors
	mov	es:[di],dh
	jmp	short realize_exit1
;
	nop

page
;--------------------------Private-Routine------------------------------;
; realize_pattern
;
;   Realize Pattern brush
;
;   The given bitmap is copied for use as a 8x8 bit pattern brush.
;   Any information beyond the first 8x8 bits is not required to be
;   maintained as part of the brush, even though GDI does allow
;   you to do this if desire.
;
;   If the bitmap is a monochrome bitmap, it is to be expanded up
;   into a black/white bitmap.	If the bitmap is a color bitmap,
;   then to compute the monochrome portion of the brush, the planes
;   will be ANDed together (this favors a white background).
;
;   This code doesn't correctly handle huge bitmaps as the source
;   for a pattern.
;
; Entry:
;	DS:SI --> logical object
;	ES:DI --> output object
; Returns:
;	DL = oem_brush_accel flags
; Error Returns:
;	None
; Registers Preserved:
;	BP,ES,FLAGS
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,DS,FLAGS
; Calls:
;	None
; History:
;	Thu 19-Feb-1987 14:06:41 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing

rbrush_pattern:
	push	di
	mov	al,2
	stosb
	lodsw
	push	ax
	lodsw
	pop	si
	mov	ds, ax
	mov	ax, di
	add	ax, 4
	stosw
	mov	ax, es
	stosw
	cmp	bptr [si].bmBitsPixel, 8
	jz	rbrush_pattern8
	mov	cx, 20h
	rep	movsb
	mov	cx,wptr lp_text_xform
	mov	bx,wptr lp_text_xform+2
	mov	dx, 7
	and	cl, dl
	mov	ch, dl
	and	bx, dx
	shl	bx, 1
	add	di, bx
	xor	ah,ah
rbrush_pattern1:
	lodsb
	ror	al,cl
	stosw
	add	bx,2
	cmp	bx,10h
	jc	rbrush_pattern2
	sub	di, 16
	sub	bx, 16
rbrush_pattern2:
	inc	si
	dec	ch
	jns	rbrush_pattern1
	jmp	short rbrush_pattern9
;
rbrush_pattern8:
	mov	cx, 60h
	rep	movsb
rbrush_pattern9:
	pop	di
	mov	ax,es
	mov	es:[di+11h], ax
	mov	ax, es:[di+0Fh]
	add	ax, di
	add	ax, 5
	mov	es:[di+0Fh], ax
	jmp	short realize_exit1
;
page
;--------------------------Private-Routine------------------------------;
; realize_hatch
;
;   Realize a Hatched Brush
;
;   The requested hatched brush is realized.  Two colors are invloved
;   for hatched brushes, the background color, and the hatch color.
;   If these two colors are the same, then the brush will be a
;   solid brush, and the solid brush code will be invoked
;
;   If not, then all 0 bits in the hatch pattern will be set to the
;   background color, and all 1 bits will be set to the foreground
;   color.  Note that hatched colors are solid colors; no dithering
;   takes place for their realization.
;
; Entry:
;	DS:SI --> logical object
;	ES:DI --> output object
; Returns:
;	DL = oem_brush_accel flags
; Error Returns:
;	None
; Registers Preserved:
;	BP,ES,DS,FLAGS
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,FLAGS
; Calls:
;	move_hatch
; History:
;	Thu 19-Feb-1987 14:06:41 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


rbrush_hatched:
	inc	al
	stosb
	lodsw
	mov	dx, ax
	lodsw
	xchg	ax, dx
	call	map_RGB_colors
	mov	al, dh
	stosb
	lodsw
	stosb
	movsb
realize_exit1:
	mov	al, 1
	jmp	short realize_exit
	nop
;
page
;--------------------------Private-Routine------------------------------;
; realize_font
;
;   Realize a Font
;
;   Realize font is the routine that realizes a logical font into a
;   physical font.  It is possible to punt on this routine and have
;   GDI's font manager realize the desired font, or something close
;   to it, by returning the error code (ax = 0).  That's what I'm
;   going to do.
;
; Entry:
;	AX = 0
; Returns:
;	AX = 0
; Error Returns:
;	AX = 0
; Registers Preserved:
;	BP
; Registers Destroyed:
;	None
; Calls:
;	None
; History:
;	Thu 19-Feb-1987 14:06:41 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


realize_font:
realize_exit0:	
	xor	ax, ax

realize_exit:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	12h	
cEnd <nogen>

assumes ds,nothing
assumes es,nothing


page

X36C8:	push	si		;Orphaned code fragment?
	add	si, 12h
X36CC:	cmpsb
	jnz	X36D7
	cmp	byte ptr [si-1], 0
	jz	X36DA
	jmp	short X36CC
X36D7:	stc
	jmp	short X36DB
X36DA:	clc
X36DB:	pop	si
	ret

realize_dispatch label	word

	dw	realize_pen
	dw	realize_brush
	dw	realize_font

	errnz	OBJ_PEN-1
	errnz	OBJ_BRUSH-OBJ_PEN-1
	errnz	OBJ_FONT-OBJ_BRUSH-1




;	realize_sizes
;
;	realize_sizes contains the size of the memory required to realize
;	each of the objects.  These sizes will be returned to GDI when it
;	inquires the memory needed far an object.


realize_sizes	label	word

	dw	SIZE oem_pen_def
	dw	SIZE oem_brush_def
	dw	0

	errnz	OBJ_PEN-1
	errnz	OBJ_BRUSH-OBJ_PEN-1
	errnz	OBJ_FONT-OBJ_BRUSH-1

sEnd	Code

	ifdef	PUBDEFS
	include robject.pub
	endif

end
