	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	PIXEL.ASM
;
; This module contains the Set/Get Pixel routine.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Pixel
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Pixel is used to either set a pixel to a given color with the
;   current binary raster operation, or to return the color of the
;   the pixel at the given location.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


	??_out	Pixel

incDrawMode	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include im1024.inc
	include macros.mac
	.list


	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA COLOR_FORMAT		;Color format (0103h or 0104h)

	externNP im1024_unexclude
	externNP im1024_setdrawmode
	externNP im1024_send
	externNP im1024_move

	externB im1024_color
	externW	rop_indexes
	externW Y_OFFSETS

ifdef	EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


;	Define the type flags used to determine which type
;	of scan needs to be performed (color or mono).

COLOR_OP	equ	00000001b
MONO_OP 	equ	40h
END_OP		equ	0C0h
;END_OP		equ	MONO_BIT shl 1 + (1 shl (NUMBER_PLANES))


sBegin	Data

sEnd	Data
page

sBegin	Code
assumes cs,Code

X1191	db	0	

im1024_dot	db 1, 0, IM1024_DOT
pixel_rops	label	byte
	db	 0 , 0,  0 , 0	;R2_BLACK	
	db	'P', 4, 'D', 1	;R2_NOTMERGEPEN
	db	'D', 1, 'P', 3	;R2_MASKNOTPEN
	db	'P', 1, 'P', 0	;R2_NOTCOPYPEN
	db	'P', 1, 'P', 3	;R2_MASKPENNOT
	db	'D', 1,  0 , 0	;R2_NOT
	db	'P', 2,  0 , 0	;R2_XORPEN
	db	'P', 3, 'D', 1	;R2_NOTMASKPEN
	db	'P', 3,  0 , 0	;R2_MASKPEN
	db	'P', 2, 'D', 1	;R2_NOTXORPEN
	db	 -1,-1,  -1,-1	;R2_NOP
	db	'D', 1, 'P', 4	;R2_MERGENOTPEN
	db	'P', 0,  0 , 0	;R2_COPYPEN
	db	'P', 1, 'P', 4	;R2_MERGEPENNOT
	db	'P', 4,  0,  0	;R2_MERGEPEN
	db	 1,  1,  1,  1	;R2_WHITE

	.xlist
SINGLE_OK	equ	1
	.list

;;; WIN1 this is now in scanlr.asm
;;;
page

;--------------------------Exported-Routine-----------------------------;
; Pixel
;
;   Set or Get a Given Pixel
;
;   The given pixel is set to the given color or the given pixel's
;   physical color is returned.
;
;   The physical device may be the screen, a monochrome bitmap, or a
;   bitmap in our color format.
;
;   There will not be error checking to see if the bitmap is in our
;   color format.  If it isn't, then we'll treat the bitmap as monochrome.
;
;   If lp_draw_mode is NULL, then the physical color of the pixel is
;   returned.  If lp_draw_mode isn't NULL, then the pixel will be set
;   to the physical color passed in, combined with the pixel already
;   at that location according to the raster-op in lp_draw_mode.  Pixel
;   doesn't pay attention to the background mode.
;
;   No clipping of the input value is required.  GDI clips the
;   coordinate before it is passed in, for both Set and Get.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX:AX = physical color if get pixel
;	DX:AX = positive if no error and set was OK.
; Error Returns:
;	DX:AX = 8000:0000H if error occured
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude_far	(far version of exclude)
;	unexclude_far	(far version of unexclude)
; History:
;	Sat 31-Oct-1987 00:21:06 -by-  **** ***** [*****]
;	Added clipping of the (X,Y)
;
;	Tue 18-Aug-1987 14:50:37 -by-  **** ***** [*****]
;	Added test of the disabled flag.
;
;	Wed 12-Aug-1987 19:55:20 -by-  **** ***** [*****]
;	Moved to _PIXEL.  Removed stack checking.
;
;	Thu 06-Aug-1987          -by-  ***** ****** [mitchl]
;	Put code into segment _LINES
;
;	Tue 03-Mar-1987 20:42:07 -by-  **** ****** [******]
;	Moved a mov instruction in EGA ROP handling code.
;
;	Sun 22-Feb-1987 16:29:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	externNP my_check_stack
	externNP im1024_readpixel
	externNP im1024_setclip
	externNP im1024_exclude

	assumes ds,Data
	assumes es,nothing


cProc	Pixel,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Pointer to device
	parmW	x			;X coordinate of pixel
	parmW	y			;Y coordinate of pixel
	parmD	p_color 		;Physical color to set pixel to
	parmD	lp_draw_mode		;Drawing mode to use, or null if Get

;;;	localB	is_device		;set non-zero if the device

cBegin
	push	es
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	assumes	ds,Code
	
	push	es
pixel_00:
;;;	mov	al,enabled_flag 	;Load this before trashing DS
	les	di,lp_device		;--> physical device
	mov	ax,es:[di].bmType		;Get device type
	pop	es
	or	ax,ax
	jnz	pixel_20		;Screen bitmap
	call	pixel_mem
	jmp	pixel_exit
;
pixel_20:
	push	es			;Read a screen pixel
	xor	di,di
	mov	es,di			;Disable clipping
	call	im1024_setclip	
	pop	es
	mov	ax,x
	sub	ax,5
	push	ax
	mov	ax,y
	sub	ax,5
	push	ax
	mov	ax,x
	add	ax,5
	push	ax
	mov	ax,y
	add	ax,5
	push	ax
	call	im1024_exclude
	push	es
	les	di,lp_draw_mode
	mov	si,es:[di].Rop2
	mov	ax,es
	or	ax,di
	pop	es
	jnz	pixel_30
	mov	bx,x
	mov	dx,y
	neg	dx
	call	im1024_readpixel
	mov	X1191,al 
	xor	ah,ah
	jmp	short pixel_100
	nop

pixel_30:
	mov	bx, wptr p_color
	mov	X1191,bl 
	dec	si			;Convert the ROP
	shl	si, 1	
	shl	si, 1			;into an index into the ROP array
	add	si, offset pixel_rops
	mov	ax, [si]
	xchg	al,ah
	cmp	ah,0
	jz	pixel_40
	cmp	ah,1
	jz	pixel_50
	cmp	ah,0FFh
	jnz	pixel_60
	jmp	short pixel_100
	nop
;
pixel_40:
	xor	bl,bl
	xor	al,al
	mov	cx,1
	jmp	short pixel_80
;
pixel_50:
	mov	bl,0FFh
	xor	al,al
	mov	cx,1
	jmp	short pixel_80
;
pixel_60:
	mov	cx,2
pixel_70:
	lodsw
	xchg	al,ah
	or	ah,ah
	jz	pixel_100
	cmp	ah,50h
	jnz	pixel_80
	cmp	al,1
	jnz	pixel_80
	not	bl
	jmp	short pixel_90
;
pixel_80:
	call	im1024_setdrawmode
	push	si
	mov	si,offset im1024_color
	mov	[si+3],bl
	call	im1024_send
	mov	ax, x
	mov	bx, y
	neg	bx
	call	im1024_move
	mov	si, offset im1024_dot
	call	im1024_send
	pop	si	
pixel_90:
	loop	pixel_70
pixel_100:
	call	im1024_unexclude
	mov	al, X1191
	mov	al, byte ptr im1024_dot-1
pixel_exit:
	mov	dx, 8000h
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	10h
cEnd	<nogen>

pixel_mem proc near
	les	di,lp_device
	mov	cx,es:[di].bmWidthBytes
	mov	ax,y
	mul	cx	;Offset of row in bitmap
	push	ds
	lds	si,es:[di].bmBits
	add	si,ax	;SI -> row
	mov	ax,x
	mov	cl,es:[di].bmBitsPixel	
	xor	ch,ch
	cmp	cx,8	;See if it's a colour or mono bitmap
	jz	pixel_memcol
	mov	cx, 8	;It's mono. Divide offset by 8 to get byte address
	xor	dx,dx
	div	cx
	add	si,ax
	mov	al,[si]	;The byte in question
	mov	cl,dl
	mov	dl,80h	;Bitmask
	shr	dl,cl
	les	di,lp_draw_mode
	mov	bx,es
	or	bx,di
	jz	pixel_mem_1	;Reading or writing?
	or	al,dl
	mov	[si],al		;Writing a pixel
	mov	al,1
	jmp	short pixel_mem_ret
;
pixel_mem_1:
	and	al,dl		;Reading a pixel
	or	al,al
	jz	pixel_mem_2
	mov	al,-1
	jmp	short pixel_mem_ret
;
pixel_mem_2:
	mov	al, 0
	jmp	short pixel_mem_ret
;
; Accessing a colour pixel
;
pixel_memcol:
	add	si,x
	les	di,lp_draw_mode
	mov	bx,es
	or	bx,di
	jz	pixel_mem_3
	mov	ax,p_color
	mov	[si],al
	mov	al,1
	jmp	short pixel_mem_ret
;
pixel_mem_3:
	mov	al,[si]
pixel_mem_ret:
	pop	ds
	xor	dx,dx	
	xor	ah,ah
	ret

pixel_mem	endp



ifdef	PUBDEFS
	.xlist
	include PIXEL.PUB
	.list
endif

sEnd	Code
	end
