        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	OUTPUT.ASM
;
;   This module contains the dispatch routine for the Output function.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Output
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Those functions of output which are supported by this driver
;   are dispatched to.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


	??_out	output

incLogical	= 1			;Include GDI Logical object definitions
incOutput	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include GDI DrawMode definitions

Y_MAJOR		equ	1		;Y is the major axis
STEP_LEFT	equ	2		;The DDA is stepping right
STEP_UP		equ	4		;The DDA is stepping up

?CHKSTK	= 1
?CHKSTKPROC	macro
		endm

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include im1024.inc
	include macros.mac
	include display.inc
	include genconst.blt
	.list

BUFY	equ	-224	;Y-coordinate of offscreen buffer?

sBegin	Code
assumes cs,Code
page

	public sniptab
	public snipdata
	public sniplen
	public snipflg
	externB	bitmask_tbl1
	externB	bitmask_tbl2
	externW	rop_indexes
	externB	rop_lengths
	externW Y_OFFSETS

	externNP im1024_setclip
	externNP im1024_exclude
	externNP im1024_unexclude
	externNP im1024_scanline
	externNP im1024_polyline
	externNP im1024_polygon
	externNP im1024_rectangle
	externNP im1024_ellipse
	externNP im1024_circle
	externNP im1024_imagewrite
	externNP imagex_read

	externD	im1024_drawmode
	externD	source_device
	externD	dest_device
	externW	im1024_linex
	externW	im1024_liney
	externW	im1024_x
	externW im1024_y
	externW	im1024_rectw
	externW	im1024_recth

	externA	X_MAJOR_DIST
	externA	X_MINOR_DIST
	externA Y_MAJOR_DIST
	externA	Y_MINOR_DIST
	externA	MAX_STYLE_ERR

	public	im1024_color

im1024_color	label	byte
	dw	2
	db	IM1024_COLOR
	db	0

	assumes ds,Data
	assumes es,nothing


cProc	Output,<FAR,PUBLIC,WIN,PASCAL>

	parmD	lp_dst_dev		;--> to the destination
	parmW	style			;Output operation
	parmW	count			;# of points
	parmD	lp_points		;--> to a set of points
	parmD	lp_phys_pen		;--> to physical pen
	parmD	lp_phys_brush		;--> to physical brush
	parmD	lp_draw_mode		;--> to a Drawing mode
	parmD	lp_clip_rect		;--> to a clipping rectange if <> 0

cBegin
	sub	sp, 8
	push	si
	push	di
	cld
	lds	si,lp_dst_dev
	lodsw
	mov	bl,[si].bmBitsPixel - 2	;-2 to account for lodsw
	or	ax,ax
	jnz	output_03		;Writing to screen
	cmp	bl,8
	jz	output_02		;Writing to colour bitmap
	cmp	style, OS_RECTANGLE
	jnz	output_01
	call	output_rectangle
	jmp	output_0end
;
; Writing to mono bitmap
;
output_01:
	push	wptr lp_dst_dev + 2
	push	wptr lp_dst_dev
	push	style
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono	
	jmp	output_0end
;
; Writing to screen
;
output_02:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	call	X297F
	call	bitmap_to_screen
	call	im1024_operation
	call	screen_to_bitmap
	jmp	output_09
;
; Writing to colour bitmap
;
output_03:	
	mov	cx,cs
	mov	ds,cx
	mov	es,cx
	mov	ax,-1
	push	ax
	push	ax
	push	ax
	push	ax
	call	im1024_exclude
	push	es
	les	di,lp_clip_rect
	call	im1024_setclip
	pop	es
	xor	ax,ax
	mov	di,style
	cmp	di,OS_SCANLINES
	jnz	output_04
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_scanline
	jmp	output_09
;
output_04:
	cmp	di,OS_POLYLINE
	jnz	output_05
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	im1024_polyline
	jmp	output_09
;
output_05:	
	cmp	di,OS_POLYGON
	jnz	output_06
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	im1024_polygon
	jmp	short output_09

output_06:
	cmp	di,OS_RECTANGLE
	jnz	output_07
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_rectangle
	jmp	short output_09
;
output_07:
	cmp	di,OS_ELLIPSE
	jnz	output_08
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_ellipse
	jmp	short output_09

output_08:
	cmp	di,OS_CIRCLE
	jnz	output_0end
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_circle
output_09:
	mov	ax,1
output_0end:
	call	im1024_unexclude
	pop	di	
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Ch

rectfill_scan		db	8 dup (0)
off_rectfill_scan	dw	offset rectfill_scan
seg_rectfill_scan	dw	0

param_x0	equ	word ptr [bp-4]
param_y0	equ	word ptr [bp-6]
param_x1	equ	word ptr [bp-8]
param_y1	equ	word ptr [bp-10]

output_rectangle:
	lds	si,lp_points	;Get the corners of the rectangle
	lodsw
	mov	param_x0, ax
	lodsw
	mov	param_y0, ax
	lodsw
	mov	param_x1, ax
	lodsw
	mov	param_y1, ax
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	assumes ds,Code
	assumes es,Code
	mov	seg_rectfill_scan,ax	;Turn off_rectfill_scan into a far pointer
	cmp	wptr lp_phys_brush+2, 0
	jz	rectfill_no_brush
	mov	cx, param_y1	;If there is a brush, use PC_SCANLINE to do 
	sub	cx, param_y0	;the fill
	inc	cx		;Rows in rectangle
	mov	di, offset rectfill_scan
	mov	ax,param_x0
	mov	[di+4],ax
	mov	ax,param_x1
	mov	[di+6],ax
	mov	ax,param_y0
	mov	[di+2],ax
do_rectfill:
	mov	ax,OS_SCANLINES
	mov	bx,2		;Do a SCANLINE output with 2 points
	push	wptr lp_dst_dev+2
	push	wptr lp_dst_dev
	push	ax
	push	bx
	push	seg_rectfill_scan
	push	off_rectfill_scan
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono
	inc	wptr [di+2]	;Move to next row
	loop	do_rectfill
rectfill_no_brush:
;
; Draw the outline of the rectangle with four POLYLINE operations
;
	mov	di, offset rectfill_scan
	mov	ax, param_x0
	stosw
	mov	ax,param_y0
	stosw
	mov	ax,param_x1
	stosw
	mov	ax,param_y0
	stosw			;The line at the top
	mov	ax,OS_POLYLINE
	mov	bx,2		;Do a POLYLINE output with 2 points
	push	wptr lp_dst_dev+2
	push	wptr lp_dst_dev
	push	ax
	push	bx
	push	seg_rectfill_scan
	push	off_rectfill_scan
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono
	mov	di, offset rectfill_scan
	mov	ax, param_x0
	stosw
	mov	ax,param_y0
	stosw
	mov	ax,param_x0
	stosw
	mov	ax,param_y1
	stosw			;The line at the left
	mov	ax,OS_POLYLINE
	mov	bx,2		;Do a POLYLINE output with 2 points
	push	wptr lp_dst_dev+2
	push	wptr lp_dst_dev
	push	ax
	push	bx
	push	seg_rectfill_scan
	push	off_rectfill_scan
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono
	mov	di, offset rectfill_scan
	mov	ax, param_x1
	stosw
	mov	ax,param_y0
	stosw
	mov	ax,param_x1
	stosw
	mov	ax,param_y1
	stosw			;The line at the right
	mov	ax,OS_POLYLINE
	mov	bx,2		;Do a POLYLINE output with 2 points
	push	wptr lp_dst_dev+2
	push	wptr lp_dst_dev
	push	ax
	push	bx
	push	seg_rectfill_scan
	push	off_rectfill_scan
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono
	mov	di, offset rectfill_scan
	mov	ax, param_x0
	stosw
	mov	ax,param_y1
	stosw
	mov	ax,param_x1
	stosw
	mov	ax,param_y1
	stosw			;The line at the bottom
	mov	ax,OS_POLYLINE
	mov	bx,2		;Do a POLYLINE output with 2 points
	push	wptr lp_dst_dev+2
	push	wptr lp_dst_dev
	push	ax
	push	bx
	push	seg_rectfill_scan
	push	off_rectfill_scan
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	output_mono
	retn
;
X297F:	mov	ax,-1
	push	ax
	push	ax
	push	ax
	push	ax
	call	im1024_exclude
	push	es
	mov	es,ax
	call	im1024_setclip
	pop	es
	retn
;
; Copy the source bitmap to offscreen area to be drawn on
;
bitmap_to_screen:
	push	es
	les	di,lp_draw_mode
	mov	wptr im1024_drawmode,di
	mov	wptr im1024_drawmode+2,es
	les	di,lp_dst_dev
	mov	wptr source_device,di
	mov	wptr source_device+2, es
	mov	im1024_linex, 0
	mov	im1024_liney, 0
	mov	im1024_x, 0
	mov	im1024_y, BUFY
	mov	bx,es:[di].bmWidth
	mov	im1024_rectw,bx
	mov	bx,es:[di].bmHeight
	mov	im1024_recth,bx
	pop	es
	call	im1024_imagewrite
	retn
;
im1024_operation:
	xor	ax,ax
	mov	di,style
	cmp	di,OS_SCANLINES
	jnz	im1024_accel_04
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_scanline
	jmp	im1024_op_end	

im1024_accel_04:	
	cmp	di,OS_POLYLINE
	jnz	im1024_accel_18
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	im1024_polyline
	jmp	im1024_op_end	
im1024_accel_18:
	cmp	di,OS_POLYGON
	jnz	im1024_accel_22
	push	count
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	push	wptr lp_clip_rect + 2
	push	wptr lp_clip_rect
	call	im1024_polygon
	jmp	short im1024_op_end	

im1024_accel_22:
	cmp	di,OS_RECTANGLE
	jnz	im1024_accel_06
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_rectangle
; XXX	jmp	short im1024_op_end	;BUG: This line seems to be missing!
;
im1024_accel_06:
	cmp	di,OS_ELLIPSE
	jnz	im1024_accel_07
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_ellipse
	jmp	short im1024_op_end	

im1024_accel_07:
	cmp	di,OS_CIRCLE
	jnz	im1024_op_end	
	push	wptr lp_points + 2
	push	wptr lp_points
	push	wptr lp_phys_pen + 2
	push	wptr lp_phys_pen
	push	wptr lp_phys_brush + 2
	push	wptr lp_phys_brush
	push	wptr lp_draw_mode + 2
	push	wptr lp_draw_mode
	call	im1024_circle
im1024_op_end:
	retn
;
; Copy from temporary screen buffer back to bitmap
;
screen_to_bitmap:
	push	es
	les	di,lp_dst_dev
	mov	wptr dest_device,di
	mov	wptr dest_device+2, es
	mov	im1024_linex, 0
	mov	im1024_liney, BUFY
	mov	im1024_x,0
	mov	im1024_y,0
	mov	ax,es:[di].bmWidth
	mov	im1024_rectw,ax
	mov	ax,es:[di].bmHeight
	mov	im1024_recth,ax
	pop	es
	call	imagex_read
	retn
	

cEnd<nogen>
;
; XXX Why are these still using the CGA memory model?
TOGGLE_EVEN_ODD		equ	0C050h
TOGGLE_EVEN_ODD_D	equ	-50h
;
snip0:	add	di, dx
	xor	dx, word ptr TOGGLE_EVEN_ODD
	sub	cl, Y_MINOR_DIST
	ror	bl, 1
	adc	di, ax
	sub	cl, X_MAJOR_DIST

snip1:	add	di, dx
; 	xor	dx, word ptr TOGGLE_EVEN_ODD_D
	db	81h, 0F2h		;XXX Is there a better way to make
	dw	TOGGLE_EVEN_ODD_D	;MASM generate the 4-byte form of this?
	sub	cl, Y_MINOR_DIST
snip2:	ror	bl, 1
	adc	di, ax
	sub	cl, X_MAJOR_DIST
;
snip3:	add	di, dx
	xor	dx, word ptr TOGGLE_EVEN_ODD
	sub	cl, Y_MINOR_DIST
;
snip4:	rol	bl, 1
	sbb	di, ax
	sub	cl, X_MAJOR_DIST

snip5:	add	di, dx
; 	xor	dx, word ptr TOGGLE_EVEN_ODD_D
	db	81h, 0F2h		;XXX Is there a better way to make
	dw	TOGGLE_EVEN_ODD_D	;MASM generate the 4-byte form of this?
	sub	cl, Y_MINOR_DIST
	rol	bl, 1
	sbb	di, ax
	sub	cl, X_MAJOR_DIST

snip6:	ror	bl, 1
	adc	di, ax
	sub	cl, X_MINOR_DIST
	add	di, dx
	xor	dx, word ptr TOGGLE_EVEN_ODD
	sub	cl, Y_MAJOR_DIST

snip7:	ror	bl, 1
	adc	di, ax
	sub	cl, X_MINOR_DIST
	add	di, dx
; 	xor	dx, word ptr TOGGLE_EVEN_ODD_D
	db	81h, 0F2h		;XXX Is there a better way to make
	dw	TOGGLE_EVEN_ODD_D	;MASM generate the 4-byte form of this?
	sub	cl, Y_MAJOR_DIST

snip8:	rol	bl, 1
	sbb	di, ax
	sub	cl, X_MINOR_DIST

snip9:	add	di, dx
	xor	dx, word ptr TOGGLE_EVEN_ODD
	sub	cl, Y_MAJOR_DIST

snip10:	rol	bl, 1
	sbb	di, ax
	sub	cl, X_MINOR_DIST

snip11:	add	di, dx
; 	xor	dx, word ptr TOGGLE_EVEN_ODD_D
	db	81h, 0F2h		;XXX Is there a better way to make
	dw	TOGGLE_EVEN_ODD_D	;MASM generate the 4-byte form of this?
	sub	cl, Y_MAJOR_DIST
snip12 label near

sniptab	dw	offset snip0, offset snip1, offset snip3, offset snip5
	dw	offset snip6, offset snip7, offset snip8, offset snip10
	dw	offset snip2, offset snip2, offset snip4, offset snip4
	dw	offset snip9, offset snip11, offset snip9, offset snip11

snipdata db	9, 9, 9, 9, 7, 7, 7, 7

sniplen	db	offset snip1 - offset snip0
	db	offset snip3 - offset snip1
	db	offset snip5 - offset snip3
	db	offset snip6 - offset snip5
	db	offset snip7 - offset snip6
	db	offset snip8 - offset snip7
	db	offset snip10 - offset snip8
	db	offset snip12 - offset snip10
	db	offset snip3 - offset snip2
	db	offset snip3 - offset snip2
	db	offset snip5 - offset snip4
	db	offset snip5 - offset snip4
	db	offset snip10 - offset snip9
	db	offset snip12 - offset snip11
	db	offset snip10 - offset snip9
	db	offset snip12 - offset snip11

snipflg	db	4, 4, 4, 4
	db	11, 11, 11, 11
	db	0, 0, 0, 0
	db	4, 4, 4, 4

; [BUG] There's already one of these in scanlr
rot_bit_tbl     label   byte
                db      10000000b       ;Table to map bit index into
                db      01000000b       ;  a bit mask
                db      00100000b
                db      00010000b
                db      00001000b
                db      00000100b
                db      00000010b
                db      00000001b


; List of line styles	
style_table	label	 byte
	db	11111111B		;Solid line
	db	11100111B		;Dashed
	db	10101010B		;Dotted
	db	11100100B		;Dot-dash
	db	11101010B		;Dash-dot-dot
	db	00000000B		;No line


X18FF:	mov	bp, si
	inc	si
	shr	si, 1
	mov	ah, [di]
	mov	al, bh
;
X1908:	or	ch, ch
	js	X1910
	mov	al, 0
;
X1910:	or	ch, ch
	jns	X191C
X1914:	xor	al, ah
	and	al, bl
	xor	al, ah
	mov	[di], al
X191C:	xor	ax, ax

X191E:	jns	X1925
	add	cl, MAX_STYLE_ERR
	rol	ch, 1
X1925:	dec	bp
X1926:	jg	X1926
	retf
;
X1947:	ror	bl, 1
	jc	X194F
	dec	bp
	jg	X1947
X194E:	retf
;
X194F:	inc	di
	dec	bp
	jle	X194E
;
X1953:	cmp	bp, 8
	jl	X1947
	mov	ah,[di]
	mov	al,bh
X1803:	mov	[di],al
	inc	di
	sub	bp,8
	jg	X1953
	retf
;
; This is the standard (non-accelerated) output, for drawing on mono
; bitmaps.
;
;--------------------------Exported-Routine-----------------------------;
; Output
;
;   Output is the entry point for output functions such as lines,
;   scanlines, arcs, etc.  Those functions which are supported
;   will be dispatched to.  If the function is not supported, an
;   error code will be returned.
;
; Entry:
;	None
; Return:
;	Per sub-function
; Error Returns:
;	Per sub-function
;	AX = 0 if sub-function not supported
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	scanlines
;	lines
; History:
;	Wed 04-Mar-1987 12:25:32 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing

cProc	output_mono,<WIN,PASCAL>

	parmD	lp_dst_dev		;--> to the destination
	parmW	style			;Output operation
	parmW	count			;# of points
	parmD	lp_points		;--> to a set of points
	parmD	lp_phys_pen		;--> to physical pen
	parmD	lp_phys_brush		;--> to physical brush
	parmD	lp_draw_mode		;--> to a Drawing mode
	parmD	lp_clip_rect		;--> to a clipping rectange if <> 0

	localW	bp04			;[bp-4]
	localD	bp08			;[bp-8]
	localW	CurStyle		;[bp-0A]
	localD	CurByte			;[bp-0C] Destination address
	localW	gl_scan_inc		;*[bp-0e]
	localW	gl_rop			;*[bp-10] Rop
	localW	gl_bitmap_type		;*[bp-12] Bitmap width, bytes
	localW	gl_bitmap_width_bytes	;*[bp-14] Increment to next scanline
	localW	gl_y_toggle		;*[bp-16] 
	localB	gl_jumptype		;*[bp-17]
	localB	gl_pen_pcol		;*[bp-18]
	localB	bp17			;*[bp-19]
	localB	RotBitMask		;*[bp-1A]
	localV	bpBC,%78h
cBegin	
	push	ax
	push	bx
	push	cx
	push	si
	push	di
	push	es
	push	ds
	jc	output_return
	cld
	mov	bp17, 0FFh
	lds	si, lp_points
	mov	ax, [si].ycoord	;Point 0 Y
	lds	si, lp_dst_dev
	les	di, [si].bmBits
	mov	cx, [si].bmType
	mov	gl_bitmap_type, cx	;XXX gl_bitmap_type 
	mov	dx, [si].bmWidthBytes		;may be misplaced
	mov	gl_bitmap_width_bytes, dx
	mov	gl_y_toggle,cx
	mul	dx				;Offset of Y0
	add	di,ax				;Address of Y0
	mov	wptr CurByte, di
	mov	wptr CurByte+2, es
	mov	ax, style			;What is the operation?
	cmp	ax, OS_POLYLINE
	jz	mono_polyline
	cmp	ax, OS_SCANLINES
	jnz	output_return_error
	jmp	mono_scanline
;
output_return_1:
	mov	ax, 1	
	jmp	short output_return
	nop
output_return_error:
	xor	ax,ax 
output_return:
	pop	ds
	pop	es
	pop	di
	pop	si
	pop	cx
	pop	bx
	pop	ax
	mov	sp, bp
	pop	bp
	retn	1Ch
;
;----------------------------Module-Header------------------------------;
; Module Name: polyline.asm
;
; Brief Description: Polyline drawing device driver.
;
; Created: 3/3/87
; Author: **** ******	(******)
;
; Copyright (c) 1983 - 1987  Microsoft Corporation
;
; Given a set of points, draw a set of polylines connecting adjoining
; points.  Depending on whether we are writing to the EGA or a bitmap
; we initialize as necessary.  Solid and styled lines are handled.
; Small (<= 64k bytes) monochrome and color bitmaps and huge monochrome
; and color bitmaps are all supported.  A run length slice algorithm is
; used to determine the pixels used to draw each line.  The algorithm is
; explained later on.  
;
; The line drawing code is slightly different depending on whether
; we are drawing solid lines to the EGA, solid lines to a bitmap, or
; styled lines to either the EGA or a memory bitmap.  For the sake
; of speed, a different set of line drawing routines is called
; for each case.  Only the case we are using will be brought into memory.
; In almost every case, only one of these destinations at a time will 
; be used.  If the user wants to draw lines to the EGA and a bitmap at the
; same time, for example, then they will have both of these sets of 
; routines in memory at the same time, and are hosed on memory.
;
; There are sixteen raster operations (sets of logical operations) performed
; on the data written out.  When writing to the EGA there are four of
; these operations which take two passes of EGA memory.  In each of these
; cases the first passes sets the necessary bits in the necessary planes
; to ones or zeros explicitly.  The second pass then XORs the necessary
; bit in the necessary planes.  The other twelve raster operations can
; be done in one pass of EGA memory.  All raster operations are done in
; one pass of memory for bitmaps.  Depending on the raster operation and
; the color of the pen, it is easily determined whether we set bits to 
; zeros, set bits to ones, invert bits or do nothing.  Bitmaps are written
; to one plane at a time.  In the case of a mono bitmap, only one plane is
; written to.
;
; Styled lines are drawn in two passes.  The first pass draws the line color.
; The second pass draws the gap color.  If we are writing to the EGA and
; have one of the four raster operations which takes two passes of EGA memory,
; then a total of four passes will have to be made.  Two passes to draw
; the line color and two more to draw the gap color.  Styled lines are 
; drawn one pixel at a time.  there is no efficient way around this due
; to the rotating style error term which has to be updated with each bit
; output.  It, unfortunately, depends on the value of the bit, which makes
; outputting a byte at a time expensive to set up.
;
; !!! For the release of Driver 2.0 small bitmaps are stored on a plane !!!
; !!! by plane basis (ie if we have three color planes, then the segment !!!
; !!! is stored as the red color plane, green color plane and then the !!!
; !!! blue color plane).  For the release of Driver 3.0 this will need to !!!
; !!! be changed to match the format of huge bitmaps. !!!
;
; Huge bitmaps are stored on a scan line basis.  For example, if we have
; three color planes, the the bitmap is stored as a red scan line, a green
; scan line, a blue scan line, a red scan line, and so on.  Because of this
; format, there will most likely be some left over bytes at the end of the
; segment.  These will have to be accounted for when crossing segment
; boundaries.  
;
; All lines, except vertical, are drawn from left to right.
;-----------------------------------------------------------------------;


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.  ?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.
;
;	Since the stack-checking code is designed to work quickly
;	as a near subroutine, and normally resides in segment Code, a
;	duplicate is included in the segment _LINES.  To reach this,
;	the macro ?CHKSTKNAME is defined.


	externA SCREEN_W_BYTES
	externA ScreenSelector
	externA	SCREEN_WIDTH
	externA	SCREEN_HEIGHT
	externA	HYPOTENUSE
	externA	Y_MAJOR_DIST
	externA	X_MAJOR_DIST
	externA	Y_MINOR_DIST
	externA	X_MINOR_DIST
	externA	MAX_STYLE_ERR


ifdef	EXCLUSION
	externNP exclude   		; exclude area from screen.
	externNP unexclude 		; clear excluded area.
endif




page

;--------------------------Public-Routine-------------------------------;
; do_polylines(lp_dst_dev,style,count,lp_points,lp_phys_pen,lp_phys_brush,
;	       lp_draw_mode,lp_clip_rect)
;
; DWORD lp_dst_dev 			// pointer to destination.
; short	style				// output operation.
; short count				// number of points.
; DWORD lp_points			// pointer to set of points.
; DWORD lp_phys_pen			// pointer to physical pen.
; DWORD lp_phys_brush			// pointer to physical brush.
; DWORD	lp_draw_mode			// pointer to drawing mode.
; DWORD lp_clip_rect			// pointer to clipping rect if <> 0.
;
; do_polylines initializes things for the line drawing routines.  if
; the lines are being drawn to the EGA, then the EGA is initialized 
; as necessary and the exclusion area is handled.  if the lines are
; being written to a bitmap, information about the bitmap is loaded.
; necessary tables and pointers are set up depending on line style and
; destination device.  When all of the necessary initialization is
; complete, we jump to polyline_loop which does the DDA and the line
; drawing.
;
; Entry: per parameters.
;
; Returns: AX = 1 if polylines drawn.
;
; Error Returns: AX = 0 if polylines not drawn.
;
; Registers Destroyed: AX,BX,CX,DX,DS,flags.
;
; Registers Preserved: DI,SI.
;
; Calls: 
;	 polyline_set_ega_for_one_pass
;	 polyline_set_ega_for_two_pass
;	 exclude_far	(far version of exclude)
;	 unexclude_far	(far version of un_exclude)
;
; History:
;  Tue 18-Aug-1987 14:50:37 -by-	**** *****	    [*****]
; Added test of the disabled flag.
;
;  Thu 30-Apr-1987 13:20:00	-by-	**** ******	    [******]
; Added huge bitmap handling.
;
;  Wed 08-Apr-1987 10:32:33	-by-	**** ******	    [******]
; Modified to draw all lines moving right.
;
;  Mon 23-Feb-1987 12:56:41	-by-	**** ******	    [******]
; Major re-write.
;
;  Tue 28-Oct-1986 16:05:04	-by-    **** ********	    [*****]
; Created.
;-----------------------------------------------------------------------;

;---------------------------Pseudo-Code---------------------------------;
; do_polylines(lp_dst_dev,style,count,lp_points,lp_phys_pen,lp_phys_brush,
;	       lp_draw_mode,lp_clip_rect)
;
; DWORD lp_dst_dev 			// pointer to destination.
; short	style				// output operation.
; short count				// number of points.
; DWORD lp_points			// pointer to set of points.
; DWORD lp_phys_pen			// pointer to physical pen.
; DWORD lp_phys_brush			// pointer to physical brush.
; DWORD	lp_draw_mode			// pointer to drawing mode.
; DWORD lp_clip_rect			// pointer to clipping rect if <> 0.
;
; {
;    if (style is not a polyline)
;        return(0);			// return that line is not drawn.
;
;    // for speed considerations EGA specific code is separated from
;    // memory bitmap specific code.
;
;    if (destination is bitmap)
;        jump to get_bitmap_info;
;
;    // handle exclusion area on the screen.
;
;#ifdef EXCLUSION
;    assume exclusion area is entire screen;
;
;    if (passed a clipping rectangle)
;        set exclusion to passed clipping rectangle;
;
;    exclude_far();			// exclude scan from the screen.
;#endif
;
;    jump to load_color_info;
;
;    // get bitmap specific information,  this section is skipped over
;    // if destination is the EGA.
;
;get_bitmap_info:
;    assume monochrome bitmap;
;    get number of color planes;
;    if (number of planes > 1)
;        DeviceFlags = DEST_IS_BITMAP+DEST_IS_COLOR;
;
;    NumPlanes = number of planes;
;
;    // the following group of information is found from the current
;    // bitmap structure.
;
;    BitmapSegment = starting segment of bitmap;
;    NextPlane = index to the next plane;
;    NextScan = index to next scan line;
;    BitmapOffset = starting offset of bitmap;
;
;    // check to see if small or huge bitmap.  if it is huge, this is a
;    // good time to load huge bitmap information.
;
;    if (small bitmap)
;        jump to load_color_info;
;
;    // load huge bitmap information.
;
;    DeviceFlags |= DEST_IS_HUGE;
;
;    SegIndex = index to the next segment;
;    FillBytes = number of fill bytes at end of segment;
;    ScansSeg = scan lines per segment;
;
;    // huge bitmaps are stored in groups of scan lines.  For example, with
;    // three color planes, the bitmap is stored as a scan line of the first
;    // color plane, a scan line of the second color plane, a scan line of the
;    // third color plane, a scan line of the first color plane, and so on.
;    // therefore, when writing to a color plane, a move to the next scan line
;    // actually has to jump over three scan lines.
;
;    NextPlane = NextScan;		// reset index to next plane.
;    NextScan *= Numplanes;		// reset index to next scan line.
;
;    // load the pen and line style information.  this is done for both
;    // EGA and bitmaps.
;
;load_color_info:
;    TmpColor = current pen color;
;    get current line style;
;
;    if (line style > MaxLineStyle)
;        return(0);			// exit with error.
;
;    if (line style == 0)
;        return(1);			// do nothing.
;
;    // get raster operation from draw mode structure.
;
;    DrawModwIndex = raster operation;
;
;    index = current line style;
;    CurStyle = style mask indexed in style_table;
;
;    if (styled line)
;    {
;        // the same style information is needed for both EGA and bitmaps.
;        // get the background mode and store it as the high byte of
;        // StyleFlags and store CurByte as the low byte.  also, get the
;        // gap color and set the rotating style information.
;
;        BackMode = background mode;
;        BackColor.SPECIAL = background color;
;        high byte of StyleFlags = BackMode;
;        low byte of StyleFlags = CurStyle;
;        StyleLength = MAX_STYLE_ERR;
;    }
;
;    // load flag to see if raster op can be done in one pass of EGA memory.
;
;    SingleFlag = dm_flags + DrawModeIndex;
;
;    if (destination is bitmap)
;        jump to set_bitmap_table;	// skip EGA stuff.
;    
;    PenANDFlag = dm_pen_and + DrawModeIndex;
;    PenXORFlag = dm_pen_xor + DrawModeIndex;
;    DataROTFlag = dm_data_r + DrawModeIndex;
;
;    // depending on whether the raster op can be done in one pass of EGA
;    // memory or not, we set up the EGA differently.
;
;    if (raster op can be done in one pass)
;        polyline_set_ega_for_one_pass();
;    else
;        polyline_set_ega_for_two_pass();
;
;    // point to the appropriate set of tables.
;
;    if (solid line)
;    {
;	 DDAstandardProcTable = CodeOFFSET ega_standard_routines;
;	 DDAsimpleProcTable = CodeOFFSET ega_simple_routines;
;    }
;    else
;    {
;        StyledProc => styled_line_pixel;  // ega styled line output routine.
;	 DDAstandardProcTable = CodeOFFSET styled_standard_routines;
;	 DDAsimpleProcTable = CodeOFFSET styled_simple_routines;
;    }
;
;    jump to set_up_loop;		// skip over bitmap stuff.
;
;set_bitmap_table:
;    if (solid line)
;    {
;	 DDAstandardProcTable = CodeOFFSET bitmap_standard_routines;
;	 DDAsimpleProcTable = CodeOFFSET bitmap_simple_routines;
;    }
;    else
;    {
;        StyledProc => styled_bitmap_line_pixel; // bitmap line routine.
;	 DDAstandardProcTable = CodeOFFSET styled_standard_routines;
;	 DDAsimpleProcTable = CodeOFFSET styled_simple_routines;
;    }
;
;set_up_loop:
;    // assume destination is not huge bitmap.
;
;    OverflowProc = CodeOFFSET dont_check_overflow;
;
;    get first polyline point;
;
;    point CurByte at that point;
;    if (destination is huge bitmap)
;    {
;        // we have a huge bitmap.  compute which segment the Y coordinate
;        // is in. set up SegmentNum to show which segment number this
;        // point is in. set SEG_CurByte to the segment which the point is in.
;
;        SegmentNum = current segment number;
;        SEG_CurByte = current segment;
;    }
;
;    index = x coordinate;
;    index &= PARTIAL_BYTE_MASK;	// get bit offset.
;    BL = rot_bit_tbl + index;		// get rotating bitmask in BL.
;
;    jump to polyline loop;
;
;exit_polyline:
;    if (destination is EGA)
;    {
;        restore EGA to default state;
;#ifdef EXCLUSION
;        unexclude_far();		// free up the exclusion area.
;#endif
;
;    return(1);				// indicate success.
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing

mono_polyline:
load_color_info:
	lds	si,lp_phys_pen		;Get current pen
	mov	ah, [si].oem_pen_pcol+1
	mov	bptr gl_pen_pcol, ah
	xor	bx,bx
	mov	bl,[si].oem_pen_pcol	;Get and save line style
	cmp	bx,MaxLineStyle 	;Legal line style?
	jg	output_return_error	;  No, abort
	jz	output_return_1		;  Null, exit
	errnz	MaxLineStyle-LS_NOLINE
	mov	ah,cs:style_table[bx]
	mov	al,MAX_STYLE_ERR
	dec	al
	mov	CurStyle, ax
	xor	cx,cx
	call	cpolyline		;X1C1F
;	set up polyline loop (dest byte calculation)

	lds	si,lp_points		;--> first point
	lodsw
	mov	dx,ax			;Save X coordinate
	errnz	xcoord
	lodsw
	mov	cx,ax			;Save Y coordinate
	errnz	ycoord-xcoord-2
	mov	di,dx
	shr	di, 1
	shr	di, 1
	shr	di, 1
	add	di, wptr CurByte	; Add address of bitmap
	mov	bx, dx
	and	bx, word ptr 7
	mov	bl, cs:rot_bit_tbl[bx]
	mov	ax,count		;Set count of line segments

; polyline_loop
;
; polyline_loop contains the run length slice algorithm DDA.
; when this routine is entered, it is passed the coordinates of the first
; point.  it gets the next point and draws the line between them.  the
; first point of the line is drawn and the last point is not.  this is 
; so when raster operations such as XOR are done, the end points do not
; get drawn twice and cancel each other.  different line drawing routines
; are called depending on the destination device and the type of line
; being drawn.
;
; the DDA algorithm used here is based on Jack Bresenham's Run Length
; Algorithm for Incremental Lines.  NATO ASI Series.  Volume F17.
; Fundamental Algorithms for Computer Graphics.  Springer-Verlag
; Berlin Heidelberg  1985.
;
; ALGORITHM
;
; // Given two integer points (x1,y1) and (x2,y2), the following algorithm
; // will calculate run lengths or slices of constant direction movement to 
; // increment a rastered line from (x1,y1) to (x2,y2) under the constraint
; // that unit steps are restricted to those eight axial/diagonal moves in
; // which the x and/or y positions change only by 1, 0, or -1 per step.
;
; HALF OCTANT NORMALIZATION
;
; // Normalize the directed line segment to a standard first partial octant,
; // zero origin form.
;
; delta_x = x2 - x1;
; delta_y = y2 - y1;
; delta_major = max(delta_x, delta_y);
; delta_minor = min(delta_x, delta_y);
; del_b = min(delta_minor, (delta_major - delta_minor));
;
; // Determine true display incremental directions (m11,m12) and (m21,m22) 
; // which correspond to full first octant diagonal and axial unit steps,
; // then re-order as appropriate for pseudo-axial, pseudo-diagonal partial
; // octant movement pairs (s11,s12) and (s21,s22).
;
; m21 = (delta_x >= 0) ? 1 : -1;
; m22 = (delta_y >= 0) ? 1 : -1;
; m11 = (abs(delta_x) >= abs(delta_y)) ? m21 : 0;
; m12 = (abs(delta_x) >= abs(delta_y)) ? 0 : m22;
;
; if (delta_major >= 2 * delta_minor)
; {
;	s11 = m11;
;	s12 = m12;
;	s21 = m21;
;	s22 = m22;
; }
; else
; {
;	s11 = m21;
;	s12 = m22;
;	s21 = m11;
;	s22 = m12;
; }
;
; // Provisionally specifiy HLast to accomodate the degenerate cases of 
; // movement solely in an axial or diagonal direction.
;
; HLast = delta_major;
;
; if (del_b > 0)
; {
;	// PARAMETERS
;
;	// Calculate parameters for the repetitive run length generaton loop.
;
;	BitCount = delta_major / del_b;	// bits per intemediate line segment.
;
;	r = delta_major % del_b;
;
;	m = BitCount / 2;
;
;	n = even(q) ? r : (r + del_b);
; 
;	if ((delta_y >= 0) || (n != 0))
;		HFirst = m;		// bits per first line segment.
;	else
;		HFirst = m -1;		// bits per first line segment.
;
;	if ((delta_y < 0) || (n != 0))
;		HLast = m;		// bits per last line segment.
;	else
;		HLast = m - 1;		// bits per last line segment.
;
;	DDAcount = del_b;		// number of intermediate line segments.
;
;	// Bias the initial decision variable to generate retractable lines.
;	
;	if (delta_y >= 0)
;		ErrTerm = n + 2*r - 2*del_b;
;	else
;		ErrTerm = n + 2*r - 2*del_b - 1;
;
;	// INITIAL RUN LENGTH
;
;	// Output initial run length pair.  First run of length HFirst is
;	// in the direction (s11,s12).  The single diagonal step of length
;	// one is in direction (s21,s22).
;
;	for (i = 0; i < HFirst; i++)
;	{
;		x1 += s11;
;		y1 += s12;
;	}
;
;	x1 += s21;
;	x2 += s22;
;
;	// INTERMEDIATE RUN LENGTH LOOP
;
;	// select appropriate run and output successive intermediate run
;	// length pairs associated with movement directions given by
;	// (s11,s12) and (s21,s22).
;
;	while (-- count)
;	{
;		if (ErrTerm >= 0)
;		{
;			hi = BitCount;	// the ith intermediate segment.
;			ErrTerm += 2*r - 2*del_b;
;		}
;		else
;		{
;			hi = BitCount - 1;
;			ErrTerm += 2*r;
;		}
;
;		for (j = 0; j < hi; j++)
;		{
;			x1 += s12;
;			x2 += s12;
;		}
;
;		x1 += s21;
;		y1 += s22;
;	}
; }
;
; // TERMINATION
;
; // output final single run length in direction (s11,s12).
;
; for (i = 0; i < HLast; i++)
; {
;	x1 += s11;
;	x2 += s12;
; }
;
; // END OF ALGORITHM.
;
;
; Entry: 
;	AX = number of points to process + 1.
;	BL = rotating bit mask.
;	CX = first Y coordinate.
;	DX = first X coordinate.
;	DI = offset of current byte.
;	DS:SI points to next point.
;
; Returns: None.
;
; Error Returns: None.
;
; Registers Destroyed: AX,BX,CX,DX,DI,SI,DS,flags.
;
; Registers Preserved: None.
;
; Calls: 
;	 ega_line_dispatch_routine
;	 bitmap_line_dispatch_routine
;	 polyline_set_ega_for_one_pass
;	 polyline_set_ega_for_two_pass
;
; History:
;  Thu 30-Apr-1987 13:20:00	-by-	**** ******	    [******]
; Added huge bitmap handling.
;  Wed 08-Apr-1987 10:32:33	-by-	**** ******	    [******]
; Modified to draw all lines moving right.
;  Mon 23-Feb-1987 12:56:41	-by-	**** ******	    [******]
; Major re-write.
;  Tue 28-Oct-1986 16:05:04	-by-    **** ********	    [*****]
; Created.
;-----------------------------------------------------------------------;

;---------------------------Pseudo-Code---------------------------------;
; polyline_loop
;
; {
;    number of points--;
;    if (number of points == 0)
;        jump to exit_polyline;		// no more lines to do.
;
;    // set some variables.
;
;    RotBitMask = BL;
;    OFF_CurByte = DI;
;    TmpCurByte = DI;
;
;    get the next point;
;
;    if (destination is huge bitmap)
;    {
;        // compute which 64K block of memory the end point is in.  if 
;        // both points are in the same segment, then we don't need to
;        // check for segment overflow, otherwise we do.
;
;        compute segment end point is in;
;        if (ending segment == starting segment)
;            OverflowProc => dont_check_overflow;
;        else
;            OverflowProc => check_segment_overflow;
;
;        // we have a huge bitmap.  compute which segment the Y coordinate
;        // is in. set up SegmentNum to show which segment number this
;        // point is in. 
;
;        SegmentNum = number of current segment.
;    }
;
;    CaseFlags = 0;
;
;    // depending on whether delta x is positive or negative, we will
;    // set the stepping left or right bit.
; 
;    if (delta x >= 0)
;        jump to x2_ge_x1;		// moving right.
;
;    delta x *= -1;			// make it positive.
;    CaseFlags |= STEPLEFT;		// indicate moving left.
;
;    // the following bunch of ugliness is to set up CurByte when we are
;    // drawing a left moving line.  we will be drawing all lines moving
;    // right.  so when we draw a left moving line, we have to jump CurByte
;    // over to the left side of the line, then draw the line, and then
;    // reset CurByte one last time.
;
;    reset OFF_CurByte to left endpoint of line;
;
;    if (destination is huge bitmap)
;    {
;        // we have a huge bitmap.  compute which segment the Y coordinate
;        // is in. set up SegmentNum to show which segment number this
;        // point is in. set SEG_CurByte to the segment which the point is in.
;
;        SegmentNum = number of current segment;
;        SEG_CurByte = current segment;
;        TmpSegment = current segment; 	// segment reset value.
;    }
;
;    set new RotBitMask;
;    TmpBitMask = RotBitMask;		// save a copy.
;
;    swap Y1 and Y2;			// since we are drawing line backwards.
;
;    // depending on whether delta y is positive or negative, set the 
;    // stepping up or down bit.
;
;x2_ge_x1:
;    AddVertStep = NextScan;		// set up scan line jumping values.
;    SubVertStep = - NextScan;
;
;    if (delta y >= 0)
;        jump to y2_ge_y1;		// moving down.
;
;    delta y *= -1;			// make it positive.
;    CaseFlags |= Y_MAJOR;		// indicate moving up.
;
;    AddVertStep = -NextScan;		// reverse scan line jumping values.
;    SubVertStep = NextScan;
;
;    // depending on the relative values of delta x and delta y we decide
;    // whether the line is x or y major and set the bit accordingly.
;
;y2_ge_y1:
;    if (delta x < delta y)
;        CaseFlags |= Y_MAJOR;		// indicate y major.
;
;    // if delta_major >= 2*delta_minor then the line is axial, else
;    // it is diagonal, and we set the bit accordingly.
;
;    if (delta_major < 2 * delta_minor)
;        CaseFlags |= DIAGONAL;		// indicate diagonal line.
;
;    // now all of the CaseFlags are set to point us to the correct case
;    // if the procedure table.  we now want to check the value of del_b
;    // to see if we have a simple case.  if del_b = 0 then we have a 
;    // simple case.
;    // del_b = min(delta_minor, (delta_major - delta_minor)).
;
;    del_b = min(delta_minor, (delta_major - delta_minor));
;
;    if (del_b == 0)
;    {
;        // we have a simple case.  by simple it is meant that the line is
;        // horizontal, vertical or on a diagonal.  these cases can be 
;        // handled much faster than other cases, so they are broken out
;        // separately.  call the proper routine, depending on whether we 
;        // are writing to a bitmap or the EGA.  by setting up for the call
;        // slightly differently from the standard line case, we are able to
;        // use the same line drawing procedure.  in a simple case, delta_major
;        // is equal to the total number of pixels of the entire line.
;
;        HFirst = delta_major;		// total # of pixels to draw.
;
;        // point to the proper set of routines.
;
;        DDAcurrentProcTable = DDAsimpleProcTable;
;
;        if (writing to the EGA)
;        {
;            ega_line_dispatch_routine();	// go draw the line.
;            jump to polyline_get_return;
;        }
;        else
;        {
;            bitmap_line_dispatch_routine;	// go draw the line.
;            jump to ignore_two_pass_setup;
;        }
;    }
;
;    // if we get here, we do not have one of the simple cases.  the next
;    // thing to do is to calculate the parameters for the repetitive
;    // run length generation loop.
;
;    BitCount = delta_major / del_b; 		// bits per intermediate segment.
;    
;    if (BitCount is even)
;        n = r (remainder from above division);
;    else
;	 n = r + del_b;
;
;    if (delta y < 0 && n == 0)
;        HFirst = m - 1;		// decrement first segment length.
;    else
;        HFirst = m;
;
;    if (delta y >= 0 && n == 0)	
;        HLast = m - 1;			// decrement last segment length.
;    else
;        HLast = m;
;
;    DDAcount = del_b;			// set number of segments.
;    DDAtmpcount = del_b;		// save a copy.
;
;    // now calculate the proper error term.
;
;    if (delta y >= 0)
;        ErrTerm = n + 2*r - 2*del_b;
;    else
;        ErrTerm = n + 2*r - 2*del_b - 1;
;
;    ErrAdj = 2*r;
;    ErrReset = 2*r - 2*del_b;
;
;    DDAcurentProcTable = DDAstandardProcTable;
;
;    if (destination is bitmap)
;    {
;        bitmap_line_dispatch_routine();
;        jump to ignore_two_pass_setup;
;    }
;    else
;        ega_line_dispatch_routine();
;
;polyline_get_return:
;    if (raster op was done in one pass)
;        jump to ignore_two_pass_setup;
;
;    // only do the following if finishing up a line with a raster op which
;    // took two passes of EGA memory, since the EGA would be all screwed
;    // up to start the next line.
;
;    polyline_set_ega_for_two_pass();
;
;ignore_two_pass_setup:
;    if (moving left)
;    {
;        DI = TmpCurByte;		// reset current byte pointer.
;        BL = TmpBitMask;		// reset bitmask.
;    }
;
;    get next point to be processed;
;
;    jump to polyline_loop;		// process the next line.
; }
;-----------------------------------------------------------------------;

polyline_loop:

	dec	ax			; any lines to draw?
	jg	plineloop_10	
	jmp	output_return_1		; no, then exit.

plineloop_10:
	push	ax    	 		; save # of points left to process
	push	ds			; save point pointer
	push	si
	mov	wptr CurByte,di		; save current byte offset
	mov	RotBitMask,bl		; save RotBitMask

	mov	ax,[si].xcoord		; get new X coordinate
	mov	di,[si].ycoord		; get new Y coordinate
	xor	bx,bx			; zero stepping flags


; It will take less time to refetch the (x,y) pair that was just
; fetched at the end of the loop than to push them onto the stack
; and then pop them at the end of the loop.

; AX = x2
; CX = y1
; DX = x1
; SI = y2

;	cmp	CurStyle,0FFh		
;	je	set_for_solid

; assume styled line is not moving left and set up style parameters as such.

;	mov	XMajorDist,X_MAJOR_DIST
;	mov	YMajorDist,Y_MAJOR_DIST
;	mov	XMinorDist,X_MINOR_DIST
;	mov	YMinorDist,Y_MINOR_DIST
;	mov	Hypot,HYPOTENUSE

; depending on whether delta x is positive or negative, we will then
; set the stepping left or right bits.

set_for_solid:
;	mov	bx,ax			; save X2 in BX.
	sub	ax,dx			; AX = delta_x
	jnc	x2_ge_x1
gots_to_be_left:
	mov	bl,STEP_LEFT		; vs stepRight
	neg	ax			; AX = abs(delta_x)
x2_ge_x1:
	mov	si, gl_bitmap_width_bytes
	mov	dx, ax
	mov	ax, di	
	mov	gl_jumptype, 7Dh	;JNL
	mov	byte ptr [bp-090h], 90h	;NOP
	sub	ax, cx
	jnc	dx_ge_dy	
	neg	ax
	or	bl, Y_MAJOR
	xor	si, [bp-16h]
	neg	si
	mov	gl_jumptype, 7Fh	;JG
	mov	byte ptr [bp-090h], 46h	;INC SI
dx_ge_dy:
	mov	cx, ax
	cmp	cx, dx
	jc	y2_ge_y1
	or	bl, STEP_UP
	xchg	cx, dx
y2_ge_y1:
	mov	gl_scan_inc, si
	or	dx, dx
	jnz	pline_10
	mov	di, wptr CurByte
	mov	bl, RotBitMask
	jmp	pline_90
;
pline_10:
	mov	ax, cs
	mov	ds, ax
	mov	di, bp04
	or	cx, cx
	jnz	pline_20
	or	bl, 8	;XXX
	test	bl, 4	;XXX
	jnz	pline_20
	cmp	bptr CurStyle+1, 0FFh
	jnz	pline_20
	cmp	bp17, bl
	jz	pline_50
	mov	bp17, bl
	push	dx
	call	X1CEE
	pop	dx
	jmp	short pline_50
;
pline_20:
	test	bl, 8	;XXX
	jnz	pline_30
	mov	ax, I_SUB_SI_WORD_I
	stosw
	mov	ax, cx		;nnnn
	stosw
	mov	ah, cs:snipdata[bx]
	add	ah, 4
	mov	al, gl_jumptype
	stosw
	mov	ax, I_ADD_SI_WORD_I
	stosw
	mov	ax, dx
	stosw
pline_30:
	cmp	bp17, bl
	jz	pline_50
	mov	bp17, bl
	mov	cl, cs:sniplen[bx]
	xor	ch, ch
	mov	al, cs:snipflg[bx]
	add	bx, bx
	mov	si, cs:sniptab[bx]
	mov	bx, di
	rep	movsb
	cmp	gl_bitmap_type, 0
	jnz	pline_31
	and	ax,0FFh
	jz	pline_31
	add	bx, ax
	mov	wptr ss:[bx],0
pline_31:
	mov	si, offset X1925
	mov	cl, 4
	cmp	bptr CurStyle+1, 0FFh
	jz	pline_40
	mov	si, offset X191E
	mov	cl, 0Bh
pline_40:
	rep	movsb	
	mov	ax, wptr bp08
	sub	ax, di
	add	ax, 6
	mov	es:[di-2], al
pline_50:	
pline_60:
pline_70:
	lds	di, CurByte
	mov	si, dx
	mov	dx, gl_scan_inc
	mov	bh, bptr gl_pen_pcol
	mov	bl, RotBitMask
	mov	cx, CurStyle
	push	bp
	call	dword ptr bp08
	pop	bp
pline_80:
	mov	CurStyle, cx
pline_90:
	pop	si
	pop	ds
	cld
	lodsw
	mov	dx, ax
	lodsw
	mov	cx, ax
	pop	ax
	jmp	polyline_loop	
;
; Generate polyline code
;
cpolyline:
	lds	si, lp_draw_mode
	mov	ax, [si].bkMode
	mov	dh, bptr [si].bkColor
	mov	bx, [si].Rop2
	dec	bx
	and	bx, wptr 0Fh
	jcxz	cpolyline_2
	cmp	ax, 2
	jz	cpolyline_2
	or	dh, dh
	jz	cpolyline_1
	and	bl, 0FBh
	or	bl, 8
	jmp	short cpolyline_2
cpolyline_1:
	and	bl, 0FEh
	or	bl, 2
cpolyline_2:
	mov	gl_rop, bx	
	lea	di, [bp-092h]
	mov	cx, ss
	mov	es, cx
	mov	wptr bp08, di
	mov	wptr bp08+2, cx
	mov	cx, cs
	mov	ds, cx
	mov	si, offset X18FF
	mov	cx, 9
	rep	movsb
	cmp	bptr CurStyle+1, 0FFh
	jz	cpolyline_10
	cmp	ax, 2
	jnz	cpolyline_10
	mov	si, offset X1908
	mov	cl, 3
	rep	movsw
	mov	es:[di-1], dh
cpolyline_10:
	mov	cl, cs:rop_lengths[bx]
	add	bx, bx
	mov	si, cs:rop_indexes[bx]
	rep	movsb
	mov	si, offset X1914
	mov	cl, 5
	cmp	bptr CurStyle+1, 0FFh
	jz	cpolyline_40
	cmp	ax, 2
	jz	cpolyline_40
	mov	si, offset X1910
	mov	cl, 7
cpolyline_40:
	rep	movsw
cpolyline_50:
	mov	bp04, di
	ret
;
X1CEE:
	lea	ax, [bp-08Dh]
	sub	ax, di
	mov	si, offset X1947
	mov	cx, 15h
	rep	movsb
	add	es:[di-0Fh], al
	add	es:[di-5], al
	test	bl, 2
	jz	cpolyline_110
	mov	bptr es:[di-14h], I_RET_NEAR
	mov	bptr es:[di-0Dh], 4Fh	;DEC
cpolyline_110:
	mov	ah, bl
	mov	bx, gl_rop
	mov	cl, cs:rop_lengths[bx]
	mov	al, cl
	add	bx, bx
	mov	si, cs:rop_indexes[bx]
	mov	bl, ah
	rep	movsb
	mov	si, offset X1803
	mov	cl, 9
	rep	movsb
	test	bl, 2
	jz	cpolyline_120
	mov	bptr es:[di-7], 4Fh	;DEC
cpolyline_120:
	sub	es:[di-2], al
	ret


mono_scanline:
	lds	si,lp_dst_dev
	mov	cx,[si].bmType
	lds	si,lp_points
	mov	bx,[si].ycoord
	mov	dx, bx
scanlines_10:
	mov	di, wptr lp_phys_brush
	mov	ax, wptr lp_phys_brush + 2
	mov	cx, ax
	or	cx, di
	jz	scanlines_20
	mov	ds,ax
	mov	cx,[di+8]	;XXX should be [di].oem_brush_style
	mov	si, 0FFFFh
	cmp	cx, BS_PATTERN
	ja	j_out_return_error
	cmp	cx, BS_HOLLOW
	jnz	scanlines_30
j_out_return_1:
	jmp	output_return_1

j_out_return_error:
	jmp	output_return_error
;
scanlines_20:
	lds	di, lp_phys_pen
	cmp	bptr [di].oem_pen_pcol, 5
	jz	j_out_return_1
	xor	bx,bx
	xor	si,si
scanlines_30:
	and	bx, word ptr 7	
	mov	al, [bx+di]			;Pattern
	mov	gl_pen_pcol, al	
	mov	CurStyle, -1
	mov	cx,si
	call	cpolyline
	mov	bl, 8
	call	X1CEE
scanlines_70:
	mov	ax, count
	lds	si, lp_points
	add	si, 4
scanlines_80:	
	dec	ax
	jg	scanlines_90
	jmp	output_return_1
;
scanlines_90:
	push	ax
	lodsw
	mov	bx,ax
	mov	cx,bx
	shr	ax,1
	shr	ax,1
	shr	ax,1
	add	ax, wptr CurByte
	mov	di, ax
	and	bx, word ptr 7
	mov	bl, cs:rot_bit_tbl[bx]
	mov	bh, gl_pen_pcol
	lodsw
	push	ds
	push	si
	sub	ax,cx
	mov	si,ax
	push	bp
	mov	ds, wptr CurByte+2
	call	bp08
	pop	bp
	pop	si
	pop	ds
	pop	ax
	jmp	short scanlines_80	

cEnd <nogen>

sEnd	Code

ifdef	PUBDEFS
	include output.pub
endif

end
