        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	IMFUNCS.ASM
;
;   This module contains functions and definitions specific to
;   the IM1024 display driver
;
; Created: 7 January 2026
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	im1024_enable
;			im1024_disable
;
; Public Data:
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc
incDrawMode = 1

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include windefs.inc
	include im1024.inc
	include display.inc
	include macros.mac
	include	cursor.inc
	.list


	public	im1024_enable 	;Enable routine
	public	im1024_disable	;Disable
	public	im1024_w_byte	;Send a single byte
	public	im1024_send1	;Send CX bytes from SI
	public	im1024_send	;Send wptr [SI] bytes from SI+2
	public	im1024_r_byte	;Read a single byte
	public	im1024_readpixel ;Read pixel at (BX,DX)
	public	im1024_move
	public  im1024_setdrawmode
	public	y_origin
	public	im1024_moveto
	public	im1024_linpat
	public	brush_patterns
	public	im1024_rect
	public	im1024_outline
	public	im1024_prmfil
	public	X44ED
	public	map_RGB_colors
	public	im1024_exclude


BS_SOLID	equ	0
BS_HOLLOW	equ	1
BS_HATCHED	equ	2
BS_PATTERN	equ	3

IS_BUSY		equ	0FFh
NOT_BUSY	equ	0

sBegin	Data

	externB	cur_flags
	externW	cursor_width
	externW	cursor_height
	externW	cursor_xhot
	externW	cursor_yhot
	externW	cursor_x
	externW	cursor_y
	externB cur_needs_update
	externB	screen_busy

	public	draw_mode
draw_mode	db	5
last_vwport	dw	0, 0, 0, 0
sEnd	Data

sBegin	Code
assumes cs,Code

	externNP im1024_move_cursor
	externNP colourtomono
	externNP cursor_off
	externB	im1024_color
	externB cursor_tdefin
	externB	xx_textcolor
	externB	xx_bkcolor
	externW	colour_srcw
	externW colour_srcy
	externW	mono_desty
	externW im1024_clrun
	public	im1024_seg

	externW	_cstods

	assumes ds,Data
	assumes es,nothing

BDATA	equ	40h		;BIOS data segment
VIDMODE	equ	49h		;Video mode



im1024_seg	dw	IM1024_SEGMENT
old_dispreq	db	0
im1024_pending	dw	0
		dw	0
im1024_display	dw	2
		db	IM1024_DISPLAY
		db	0
im1024_lutint	dw	2
		db	IM1024_LUTINT
		db	4		;Initialise palette to rrrgggbb 
str_CX		dw	3	;Command string to change to Hex
		db	'CX '
im1024_iprec	dw	2
		db	IM1024_IPREC
		db	1
im1024_pan	dw	5
		db	IM1024_PAN
		dw	0
		dw	-112
im1024_imgsiz	dw	7		;Work with a 1024x1024 framebuffer
		db	IM1024_IMGSIZ	;(of which 1024x800 is visible and 
		dw	SCREEN_WIDTH	; the rest is used for offscreen 
		dw	SCREEN_WIDTH	; graphics storage and blit workspace)
		db	8
		db	1

im1024_readp	dw	1	;1 command byte
		db	IM1024_READP

im1024_tjust	dw	3
		db	IM1024_TJUST
		db	1	;Horizontal alignment to left
		db	3	;Vertical alignment to top

old_video_mode	db	0

im1024_enable proc near

	push	ax
	push	cx
	push	di
	push	si
	push	es
	mov	ax, BDATA
	mov	es, ax
	mov	cl, es:bptr VIDMODE	;Get current mode
	mov	cs:old_video_mode, cl	;And save it
	mov	es:bptr VIDMODE, 6	;Set current mode to 6 (640x200 gfx)
	call	locate_im1024
	mov	es,cs:im1024_seg
	mov	es:bptr IM1024_COLDBOOT, 0FFh	;Set the cold boot flag
wait_cboot:
	mov	al,es:bptr IM1024_COLDBOOT	;And wait until it clears
	or	al,al
	jz	im1024_booted
	xor	cx,cx
delay:	nop
	loop	delay
	jmp	short wait_cboot
;
im1024_booted:
	xor	al,al
	mov	es:bptr IM1024_REPERROR, al	;Don't report errors	
	mov	al,1
	mov	es:bptr IM1024_FASTMODE, al
	mov	si, offset str_CX		;Switch to hex mode
	call	im1024_send		
	mov	al,es:bptr IM1024_DISPREQ	;Get last requested display mode
	mov	cs:old_dispreq,al
	mov	si, offset im1024_display
	mov	byte ptr [si+3], 0		;Switch to native mode
	call	im1024_send
	mov	si, offset im1024_iprec		;Set up the screen
	call	im1024_send
	mov	si, offset im1024_lutint	;and the palette
	call	im1024_send
	mov	si, offset im1024_imgsiz	;and the image area
	call	im1024_send
	mov	si, offset im1024_pan		;and the viewport
	call	im1024_send
	xor	di, di
	mov	es,di
	call	im1024_setclip
	mov	si, offset im1024_tjust
	call	im1024_send
	pop	es
	pop	si
	pop	di
	pop	cx
	pop	ax
	ret

im1024_enable endp
page


im1024_disable proc near
	push	cs
	pop	ds
	mov	ax, BDATA
	mov	es,ax
	mov	cl,cs:old_video_mode
	mov	es:bptr VIDMODE, cl
	mov	si, offset im1024_display
	mov	al,cs:old_dispreq
	mov	[si+3],al
	call	im1024_send
	ret
im1024_disable	endp
;
; Check for an IM1024 transfer buffer at C600:0000 and C640:0000 
;
locate_im1024	proc near
	push	ax
	push	es
	mov	ax, IM1024_SEGMENT
	mov	es, ax
	mov	bptr es:IM1024_TEST, 0AAh
	cmp	bptr es:IM1024_TEST, 0AAh
	jz	locate_test2
;
; Not found at C600:03DF. Try at C640:03DF.
;
	mov	ax, IM1024_SEGMENT_2
	mov	es, ax
	mov	cs:im1024_seg,ax
	mov	bptr es:IM1024_TEST, 0AAh
	cmp	bptr es:IM1024_TEST, 0AAh
	jz	locate_test2
locate_fail:
	stc
	jmp	short locate_end
;
; Write and read different test pattern to ensure it wasn't a fluke.
;
locate_test2:
	mov	bptr es:IM1024_TEST, 0BBh
	cmp	bptr es:IM1024_TEST, 0BBh
	jnz	locate_fail
	clc
locate_end:
	pop	es
	pop	ax
	ret
locate_im1024	endp
;
; Write a single byte to the IM1024
;
im1024_w_byte	proc	near
	push	ax
	push	di
	push	es
	mov	es, cs:im1024_seg
	mov	di, ax
im1024_w_byte_1:
	call	im1024_queue_avail
	cmp	ax, 1
	jc	im1024_w_byte_1
	mov	ax, di
	xor	di, di
	stosb	
	pop	es
	pop	di
	pop	ax
	ret
im1024_w_byte	endp


;
; CX = count of bytes to send. SI->bytes to send
;
im1024_send1	proc	near
	push	cx
	push	si
	jmp	short	im1024_send10
im1024_send1	endp
;
; SI->word giving command length, followed by command data
;
im1024_send	proc	near
	push	cx
	push	si	
	mov	cx, [si]
	add	si,2
im1024_send10:
	cld
	push	ax
	push	di
	push	es
	mov	es,cs:im1024_seg
im1024_send20:
	mov	cs:im1024_pending,0 
	call	im1024_queue_avail
	cmp	ax,cx
	jnc	im1024_send30
	xchg	ax,cx	;CX = length to send
	sub	ax,cx	;AX = length pending
	mov	cs:im1024_pending,ax
im1024_send30:
	xor	di,di	;Write into IM1024 buffer at 0
	rep	movsb
	mov	cx,cs:im1024_pending	;If it couldn't all be sent in one
	or	cx,cx			;go, then send the next chunk
	jnz	im1024_send20
	pop	es
	pop	di
	pop	ax
	pop	si
	pop	cx
	ret
im1024_send	endp
;
; Get available space to write to command queue
;
im1024_queue_avail	proc	near
	push	di
	mov	di,IM1024_QUEUESIZE
	mov	al,es:[di]
	not	al
	xor	ah,ah	;AX = free bytes
	pop	di
	ret
im1024_queue_avail	endp

im1024_r_byte	proc near
	cld
	push	di
	push	si
	push	ds
	mov	ds, cs:im1024_seg
	call	im1024_recv_status
	jc	im1024_recv_ret
	mov	si, IM1024_RECV_BUF
	mov	di, IM1024_RECV_R
	mov	al, [di]
	xor	ah,ah
	add	si,ax
	xchg	al,ah
	lodsb
	inc	ah
	mov	[di],ah
	clc
im1024_recv_ret:
	pop	ds
	pop	si
	pop	di
	ret
im1024_r_byte	endp
;
im1024_recv_status proc near
	mov	di, IM1024_RECV_W
	mov	al,[di]
	cmp	al,[di+1]
	jz	im1024_recv_stat1
	clc
	ret
;
im1024_recv_stat1:
	xor	ax,ax
	stc
	ret
im1024_recv_status endp

im1024_readpixel	proc near
	push	si
	mov	si, offset im1024_moveto
	mov	[si+3],bx	;X-coord
	mov	[si+5],dx	;Y-coord
	call	im1024_send	;Set position
	mov	si, offset im1024_readp
	call	im1024_send
im1024_readpixel_1:
	call	im1024_r_byte	;Read back the pixel value
	jc	im1024_readpixel_1
	pop	si
	ret

im1024_readpixel	endp

im1024_rop2	db	'D', 0,  0,  0
		db	'P', 4, 'D', 1
		db	'P', 1, 'P', 3
		db	'P', 1, 'P', 0
		db	'D', 1, 'P', 3
		db	'D', 1,  0,  0
		db	'P', 2,  0,  0
		db	'P', 3, 'D', 1
		db	'P', 3,  0,  0	
		db	'P', 2, 'D', 1
		db	 0,  0,  0,  0
		db	'P', 1, 'P', 4
		db	'P', 0,  0,  0
		db	'P', 4,  0,  0
		db	'D', 0,  0,  0
im1024_linpat	dw	3
		db	IM1024_LINPAT
		dw	0
line_patterns	dw	0FFFFh	;Solid
		dw	0C3C3h	;Dashed
		dw	8888h	;Dotted
		dw	0E10Fh
		dw	0E247h
		dw	0	
;
; Used to draw the outlines of filled shapes
;
im1024_outline	proc	near

outline_func	equ	word ptr [bp+18]
outline_pts	equ	dword ptr [bp+14]
outline_count	equ	word ptr  [bp+12]
outline_pen	equ	dword ptr [bp+8]
outline_rop	equ	word ptr  [bp+6]
outline_bkmode	equ	word ptr  [bp+4]

outline_colour	equ	byte ptr [bp-1]

	push	bp
	mov	bp, sp
	sub	sp,2
	push	es
	push	ds
	les	di,outline_pen
	mov	bl,es:[di]	;Line pattern
	cmp	bl,6
	jnz	outline_1
	mov	bl,es:[di+1]
	mov	ax,es:[di+2]
	jmp	short outline_2
;
outline_1:
	xor	bh,bh
	shl	bx,1
	mov	ax,ds:line_patterns[bx]
	mov	bl,es:[di+1]
	mov	si,offset im1024_linpat
	mov	[si+3],ax
	call	im1024_send
outline_2:
	mov	outline_colour, bl
	cmp	ax,0FFFFh
	jnz	outline_3
	mov	byte ptr [bp+4], 1
outline_3:
	push	cs
	pop	es
	mov	si, offset im1024_rop2
	mov	ax, outline_rop
	dec	ax
	shl	ax, 1
	shl	ax, 1
	add	si, ax
	mov	cx,2
outline_4:
	push	cx
	lodsw
	push	si
	or	al,al
	jz	outline_9
	cmp	al,'D'
	jz	outline_5
	cmp	ah,1
	jnz	outline_5
	not	outline_colour
	jmp	short outline_9
;
outline_5:
	cmp	outline_rop, 1	;Solid black
	jnz	outline_6
	mov	outline_colour, 0
	jmp	short outline_7
;
outline_6:
	cmp	outline_rop, 16	;Solid white
	jnz	outline_7
	mov	outline_colour, 0FFh
outline_7:
	mov	bl,outline_colour
	mov	si,offset im1024_color
	mov	[si+3],bl
	call	im1024_send
	mov	al,ah
	call	im1024_setdrawmode
	cmp	al,1
	jnz	outline_8
	mov	si, offset im1024_linpat
	mov	ax, [si+3]
	cmp	ax, 0FFFFh
	jz	outline_8
	push	ax
	mov	ax, 0FFFFh	;Draw outline in solid
	mov	[si+3], ax
	call	im1024_send
	push	word ptr outline_pts+2
	push	word ptr outline_pts
	push	outline_count
	push	outline_bkmode
	push	word ptr outline_colour
	call	outline_func
	pop	ax
	mov	[si+3],ax
	call	im1024_send
	jmp	short outline_9
;
outline_8:
	push	word ptr outline_pts+2
	push	word ptr outline_pts
	push	outline_count
	push	outline_bkmode
	push	word ptr outline_colour
	call	outline_func
outline_9:
	pop	si
	pop	cx
	dec	cx
	jcxz	outline_end
	jmp	outline_4	
outline_end:
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp
	retn	10h
im1024_outline	endp
;
	public	im1024_drawmode, im1024_brush, im1024_linex, im1024_liney
	public	im1024_x, im1024_y, im1024_rectw, im1024_recth
	public	im1024_circ, im1024_elipse

im1024_drawmode	dd	0
im1024_brush	dd	0
im1024_linex	dw	0
im1024_liney	dw	0
im1024_x	dw	0
im1024_y	dw	0
im1024_rectw	dw	0
im1024_recth	dw	0
W42A1		dw	0
im1024_prmfil	dw	2
		db	IM1024_PRMFIL
im1024_fillmode	db	0
im1024_areapt	dw	33
		db	IM1024_AREAPT
		dw	10h dup(0)
X42CA		dw	8 dup (0FFFFh)
X42DA		db	0
X42DB		db	0
X42DC		db	0

		public	shape_type
shape_type	db	0

im1024_rect	dw	5
		db	34h, 0, 0, 0, 0
im1024_circ	dw	3
		db	38h, 0, 0
im1024_elipse	dw	5
		db	39h, 0, 0, 0, 0
bmp_42F1	dw	0	;bmType
		dw	8	;bmWidth
		dw	8	;bmHeight
		dw	2	;bmWidthBytes
		db	1	;bmPlanes
		db	1	;bmBitsPixel
		dw	offset	bmp_42F1_bits
		dw	0	;bmBits
		dw	10h	;bmWidthPlanes
bmp_42F1_bits	db	16 dup (0)
;
brush_patterns	dw	0FFFFh, 00000h, 00000h, 00000h	;Horizontal hatched 
		dw	00000h, 00000h, 00000h, 00000h
		dw	0FFFFh, 00000h, 00000h, 00000h
		dw	00000h, 00000h, 00000h, 00000h

		dw	08080h, 08080h, 08080h, 08080h	;Vertical hatched
		dw	08080h, 08080h, 08080h, 08080h
		dw	08080h, 08080h, 08080h, 08080h
		dw	08080h, 08080h, 08080h, 08080h

		dw	08080h, 04040h, 02020h, 01010h	;\ diagonal hatched
		dw	00808h, 00404h, 00202h, 00101h
		dw	08080h, 04040h, 02020h, 01010h
		dw	00808h, 00404h, 00202h, 00101h

		dw	00101h, 00202h, 00404h, 00808h	;/ diagonal hatched
		dw	01010h, 02020h, 04040h, 08080h 
		dw	00101h, 00202h, 00404h, 00808h
		dw	01010h, 02020h, 04040h, 08080h

		dw	0FFFFh, 08080h, 08080h, 08080h	;+ hatched 
		dw	08080h, 08080h, 08080h, 08080h
		dw	0FFFFh, 08080h, 08080h, 08080h
		dw	08080h, 08080h, 08080h, 08080h

		dw	08181h, 04242h, 02424h, 01818h	;X hatched
		dw	01818h, 02424h, 04242h, 08181h
		dw	08181h, 04242h, 02424h, 01818h	
		dw	01818h, 02424h, 04242h, 08181h

	public X43D1

X43D1	proc	near
	pusha
	push	es
	les	di, cs:im1024_drawmode
	mov	cl, es:[di].bkColor
	mov	ch, es:[di].TextColor
	mov	dl, es:[di].bkMode
	les	di, cs:im1024_brush
	mov	dh, es:[di]
	cmp	al, 5
	jnc	X444F
	cmp	dh, 2
	jz	X440B
	cmp	dh, 3
	jnz	X4400
	call	X4495
	jmp	X4492
;
X4400:	cmp	cs:shape_type, SHAPE_STRING
	jz	X4423
	jmp	short X4477
	nop
X440B:	les	di, es:[di+1]
	cmp	byte ptr es:[di].bmBitsPixel, 8
	jnz	X4419
	call	X44ED
X4419:	les	di, cs:im1024_brush
	cmp	dl, 1
	jz	X4477
X4423:	call	im1024_setdrawmode
	xchg	ch,cl
	call	X458A
	xchg	ch,cl
	cmp	dl, 1
	jz	X4477
	push	word ptr cs:shape_type
	cmp	cs:shape_type, SHAPE_STRING
	jnz	X4445
	mov	cs:shape_type, SHAPE_RECT
X4445:	call	do_shape
	pop	word ptr cs:shape_type
	jmp	short X4477
;
X444F:	mov	ah,es:[di]
	cmp	ah, 2
	jnz	X4459
	mov	ah, 0
X4459:	push	cs
	pop	es
	mov	di, offset W42A1
	mov	es:[di],ah
	mov	byte ptr es:[di+1],0
	cmp	al, 7
	jnz	X446F
	mov	byte ptr es:[di+1],0FFh
X446F:	sub	al, 4
	cmp	al, 1
	jz	X4477
	mov	al, 0
X4477:	call	im1024_setdrawmode
	cmp	byte ptr es:[di],2
	jnz	X4486
	mov	cs:X42DC, 0FFh
X4486:	call	X458A
	call	do_shape
	mov	cs:shape_type, SHAPE_RECT
X4492:	pop	es
	popa	
	ret
;
X43D1	endp
;
; Here, ES:DI points at (I think) an OEM brush
;
X4495	proc	near
	call	im1024_setdrawmode
	push	es
	push	di	
	mov	al, es:[di+3]
	push	cs
	pop	es
	mov	di, offset W42A1
	mov	byte ptr es:[di],0
	mov	es:[di+1],al
	call	X458A
	call	do_shape
	pop	di
	pop	es
	push	cs
	pop	ds
	mov	al, es:[di+1]
	mov	si, offset im1024_color
	mov	[si+3],al
	call	im1024_send
	mov	bl, es:[di+2]
	xor	bh,bh
	mov	cl,5
	shl	bx,cl
	add	bx,offset brush_patterns
	mov	al,IM1024_AREAPT
	call	im1024_w_byte
	mov	cx,32
	mov	si,bx
	call	im1024_send1
	call	do_shape
	mov	cs:X42DB, 0FFh
	mov	cs:shape_type, SHAPE_RECT
	ret	
X4495	endp
	

X44ED:	push	ax
	push	bx
	push	dx
	push	cx
	mov	al, cl
	mov	cx, es:[di].bmHeight
	mov	bx, es:[di].bmWidthBytes
	les	di, es:[di].bmBits
X44FF:	push	cx
	push	di
	mov	cx, 8
	rep	scasb
	or	cx,cx
	mov	dl, es:[di-1]
	pop	di
	pop	cx
	jnz	X4514
	add	di,bx
	loop	X44FF
X4514:	pop	cx
	mov	ch,dl
	pop	dx
	pop	bx
	pop	ax
	ret
;
; address=451b
do_shape	proc near
	push	si
	cmp	cs:shape_type, SHAPE_RECT
	jz	do_rectangle
	cmp	cs:shape_type, SHAPE_CIRCLE
	jz	do_circle
	cmp	cs:shape_type, SHAPE_ELLIPSE
	jz	do_ellipse
	cmp	cs:shape_type, SHAPE_POLYGON
	jz	do_polygon
	jmp	short doshape_end
;
do_rectangle:
	push	ax
	push	bx
	mov	ax,cs:im1024_x
	mov	bx,cs:im1024_y
	push	bx
	neg	bx
	call	im1024_move
	pop	bx
	add	ax,cs:im1024_rectw
	dec	ax
	add	bx,cs:im1024_recth
	dec	bx
	neg	bx
	mov	si, offset im1024_rect
	mov	[si+3],ax
	mov	[si+5],bx
	call	im1024_send
	pop	bx
	pop	ax
	jmp	short doshape_end

do_circle:
	mov	si, offset im1024_circ
	call	im1024_send
	jmp	short doshape_end
;
do_ellipse:
	mov	si, offset im1024_elipse
	call	im1024_send
	jmp	short doshape_end
;
do_polygon:
	mov	si, offset im1024_clrun
	mov	byte ptr [si+3],0
	call	im1024_send
doshape_end:
	pop	si
	ret
do_shape	endp

X458A	proc	near
	push	ax
	push	dx
	push	si	
	push	ds
	push	cs
	pop	ds
	assumes ds,Code
	mov	al, es:[di+1]
	cmp	byte ptr es:[di],2
	jnz	X45BC
	mov	ax, di
	add	ax, 5
	mov	es:[di+1], ax
	mov	es:[di+3], es
	push	di
	les	di, es:[di+1]
	mov	dx, di
	add	dx, 20h
	mov	es:[di+0Ah], dx
	mov	es:[di+0Ch], es
	mov	dx, es
	pop	di
X45BC:	cmp	byte ptr es:[di],1	;BS_HOLLOW?
	jnz	X45CA
	mov	cs:im1024_fillmode, 0
	jmp	short X45D0

X45CA:	mov	cs:im1024_fillmode, 1
X45D0:
	mov	si,offset im1024_prmfil
	call	im1024_send
	push	ax
	cmp	cs:shape_type, SHAPE_STRING
	jz	X45E5
	cmp	byte ptr es:[di], 2
	jnz	X45EB
X45E5:	mov	al, ch
	mov	cs:xx_textcolor,al
X45EB:	mov	si, offset im1024_color
	mov	[si+3],al
	call	im1024_send
	pop	ax
	cmp	byte ptr es:[di], 1
	jnz	X45FE
	jmp	X46BB
;
X45FE:	cmp	byte ptr es:[di], 2
	jz	X4609
	mov	dx, cs
	mov	ax, offset X42CA
X4609:	push	ax
	push	cx
	push	di
	push	ds
	push	es
	mov	ds, dx
	mov	si, ax
	cmp	byte ptr es:[di], 0
	push	cs
	pop	es
	jz	X4662
	cmp	byte ptr [si].bmBitsPixel, 1
	jz	X4654
;
; Convert from a colour pattern at ds:si to a mono pattern at bmp_42F1
;
	mov	cs:X42DC, 0
	mov	cs:xx_bkcolor, cl
	mov	cs:colour_srcw, 8
	mov	cs:colour_srcy, 0
	mov	cs:mono_desty, 0
	mov	di,offset bmp_42F1
	mov	es:[di+0Ch], cs
	push	cx
	mov	cx, 8
	call	colourtomono
	pop	cx
	push	cs
	pop	ds
	mov	si, offset bmp_42F1
X4654:	lds	si,[si].bmBits
	cmp	cs:X42DC, 0FFh
	jnz	X4662
	call	invert_pattern
X4662:	mov	di,offset im1024_areapt+3
	mov	cx,2
	mov	cs:X42DA,0
X466E:	push	cx
	push	si
	mov	cx, 8
X4673:	mov	al, [si]
	cmp	al, es:[di]
	jz	X4680
	mov	cs:X42DA, 0FFh
X4680:	stosb
	movsb
	inc	si
	loop	X4673
	pop	si
	pop	cx
	loop	X466E
	cmp	cs:X42DC, 0FFh
	mov	cs:X42DC, 0
	jnz	X469A
	call	invert_pattern
X469A:	pop	es
	pop	ds
	pop	di
	pop	cx
	pop	ax
	cmp	cs:X42DB, 0FFh
	mov	cs:X42DB, 0
	jz	X46B5
	cmp	cs:X42DA, 0
	jz	X46BB
X46B5:	mov	si, offset im1024_areapt
	call	im1024_send
X46BB:	pop	ds
	pop	si
	pop	dx
	pop	ax
	ret
;
X458A	endp

invert_pattern	proc	near
	mov	cx, 8
	push	si
invert_pattern_1:
	lodsb
	not	al
	mov	[si-1],al
	inc	si
	loop	invert_pattern_1
	pop	si
	ret
invert_pattern	endp

map_red		db	0
map_green	db	0
map_rgb8	db	0

map_RGB_colors	proc	near
	push	bx
	push	cx
	push	dx
;
; Map a 24-bit RGB value to an 8-bit truecolour RGB value.
; Red and green go to 3 bits each:
;	levels <= 33h	-> 1
;	34h-55h		-> 2
;	54h-77h		-> 3
;	74h-99h		-> 4
;	94h-BBh		-> 5
;	B4h-DDh		-> 6
;	D4h-FFh		-> 7
;
	mov	dl, 1
	mov	bl, 0
	mov	bh, 33h
	cmp	al, bh
	jbe	map_rgb_2
	mov	cx, 6
map_rgb_1:
	inc	dl	
	mov	bl, bh
	add	bh, 22h
	cmp	al, bh
	jbe	map_rgb_2
	loop	map_rgb_1
map_rgb_2:
	push	bx		;DL =red level 1-7
	push	cx		;BL =clamped red 33h/55h/77h etc
	mov	cl, bh
	xor	ch, ch
	xor	bh, bh
	add	bx, cx
	shr	bx, 1
	mov	bh, cl
	pop	cx
	mov	cl, bh
	cmp	al, bl
	pop	bx
	ja	map_rgb_3
	mov	cl, bl
	dec	dl	
map_rgb_3:
	mov	cs:map_red,cl
	mov	cl,5		;Set bits 7-5 of RGB byte to red value
	shl	dl,cl
	mov	cs:map_rgb8,dl
	mov	dl,1		;Now repeat the process for green
	mov	bl,0
	mov	bh, 33h
	cmp	ah,bh
	jbe	map_rgb_5
	mov	cx, 6
map_rgb_4:
	inc	dl	
	mov	bl, bh
	add	bh, 22h
	cmp	ah, bh
	jbe	map_rgb_5
	loop	map_rgb_4
map_rgb_5:
	push	bx
	push	cx
	mov	cl, bh
	xor	ch, ch
	xor	bh, bh
	add	bx, cx
	shr	bx, 1
	mov	bh, cl
	pop	cx
	mov	cl, bh
	cmp	ah, bl
	pop	bx
	ja	map_rgb_6
	mov	cl, bl
	dec	dl
map_rgb_6:
	mov	cs:map_green, cl
	shl	dl, 1		;Set bits 4-2 of RGB map to green
	shl	dl, 1
	add	cs:map_rgb8, dl
;
; Now for blue, which is only 2 bits, so we map to 00/55/AA/FF
;
	pop	dx
	xor	bl,bl
	xor	cl,cl
	cmp	dl, 2Ah
	jbe	map_rgb_7
	mov	bl, 55h
	inc	cl
	cmp	dl, 7Fh
	jbe	map_rgb_7
	mov	bl, 0AAh
	inc	cl
	cmp	dl, 0D4h
	jbe	map_rgb_7
	mov	bl, 0FFh
	inc	cl
map_rgb_7:
	mov	dl,bl		;Blue level
	mov	dh,cs:map_rgb8	
	add	dh,cl		;All bits of RGB8 byte set
	mov	al,cs:map_red
	mov	ah,cs:map_green
	pop	cx
	pop	bx
	ret
	
map_RGB_colors	endp

rect_478E	dw	0, 0, SCREEN_WIDTH-1, SCREEN_HEIGHT-1
rect_4796	dw	0, -224, SCREEN_WIDTH-1, -1
y_origin	dw	SCREEN_HEIGHT - 1
im1024_window	dw	9
		db	IM1024_WINDOW
window_x1	dw	0
window_x2	dw	0
window_y1	dw	0
window_y2	dw	0
im1024_vwport	dw	9
		db	IM1024_VWPORT
		dw	0,0,0,0
im1024_linfun	dw	2
		db	IM1024_LINFUN, 0
im1024_moveto	dw	5
		db	IM1024_MOVE, 0, 0, 0, 0

im1024_setdrawmode	proc 	near
	mov	ds, cs:_cstods
	assumes ds,Data
	cmp	al, draw_mode
	mov	draw_mode, al
	push	cs
	pop	ds
	jz	skip		;Mode is already correct
	push	si
	mov	si,offset im1024_linfun
	mov	[si+3],al
	call	im1024_send
	pop	si
skip:	ret

im1024_setdrawmode	endp
;
	public	im1024_setclip
;
im1024_setclip	proc	near
	push	bp
	mov	bp,sp
	sub	sp,2
	push	es
	push	ds
	cld
	pusha
	mov	byte ptr [bp-1], 0
	mov	ax, es
	cmp	ax, 0FFFFh
	jnz	X47FD
	push	cs
	pop	es
	mov	di, offset rect_4796
	mov	byte ptr [bp-1], 0FFh
	jmp	short X4806

X47FD:	or	ax,di
	jnz	X4806
	push	cs
	pop	es
	mov	di, offset rect_478E
;
; ES:DI -> requested viewport. See if it matches the values already set
;
X4806:	push	di
	mov	cx, 4
	mov	ds, cs:_cstods
	assumes	ds,Data
	mov	si, offset last_vwport
	rep	cmpsw
	push	cs
	pop	ds
	assumes ds,Code
	pop	di
	jnz	X481C
	jmp	X489F
;
; Values are different. Save the new requested values
;
X481C:	push	di
	push	es
	mov	ax,es
	mov	es, _cstods
	mov	si, di
	mov	ds, ax
	mov	di, offset last_vwport
	mov	cx,4
	rep	movsw	
	pop	es
	pop	di
	push	cs
	pop	ds
	assumes ds,Code
	mov	si, offset im1024_vwport
	mov	ax,es:[di]
	mov	[si+3],ax
	mov	window_x1,ax
	mov	ax,es:[di+4]
	cmp	ax,SCREEN_WIDTH
	jb	X484C
	mov	ax,SCREEN_WIDTH-1
X484C:	mov	[si+5],ax
	mov	window_x2, ax
	mov	ax,es:[di+2]
	mov	cx,ax
	mov	bx,y_origin
	sub	bx,ax
	jns	X4863
	mov	bx, 0
X4863:	mov	[si+9],bx
	neg	cx
	mov	window_y2, cx
	mov	ax, es:[di+6]
	mov	cx,ax
	mov	bx,y_origin
	sub	bx,ax
	jns	X487D
	mov	bx, 0
X487D:	mov	[si+7],bx
	neg	cx
	mov	window_y1, cx
	call	im1024_send
	mov	si, offset im1024_window
	cmp	byte ptr [bp-1], 0FFh
	jnz	X489C
	mov	word ptr [si+7], -223
	mov	word ptr [si+9], 0
X489C:	call	im1024_send	
X489F:	popa
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp
	ret

im1024_setclip	endp



im1024_move	proc	near
	push	si
	mov	si, offset im1024_moveto
	mov	wptr im1024_moveto+3, ax	;X
	mov	wptr im1024_moveto+5, bx	;Y
	call	im1024_send
	pop	si
	ret
im1024_move	endp

im1024_exclude	proc	near

exclude_y2	equ	wptr [bp+10]
exclude_x2	equ	wptr [bp+8]
exclude_y1	equ	wptr [bp+6]
exclude_x1	equ	wptr [bp+4]

	push	bp
	mov	bp, sp
	pusha
	push	ds
	mov	ds, cs:_cstods
	assumes ds,Data
	EnterCrit
	mov	screen_busy, IS_BUSY
	LeaveCrit
	cmp	exclude_y2, -1
	jz	exclude_2
	cmp	exclude_y2, -2
	jz	exclude_1
	mov	cx, cursor_x
	sub	cx, cursor_xhot
	mov	dx, cursor_y
	sub	dx, cursor_yhot
	push	cs
	pop	ds
	assumes ds,Code
	mov	ax,exclude_y2
	mov	bl,byte ptr cursor_tdefin+4
	xor	bh,bh
	sub	ax,bx
	cmp	cx,ax
	jl	exclude_2
	mov	ax,exclude_x2
	mov	bl,byte ptr cursor_tdefin+5
	sub	ax,bx
	cmp	dx,ax
	jl	exclude_2
	cmp	cx,exclude_y1
	jg	exclude_2
	cmp	dx,exclude_x1
	jg	exclude_2
exclude_1:
	mov	ds,cs:_cstods
	assumes	ds,Data
	cmp	cur_needs_update, 0FFh
	jz	exclude_end
	mov	cur_needs_update, 0FFh
	push	cs
	pop	ds
	assumes ds,Code
	EnterCrit
	call	cursor_off
	LeaveCrit
	jmp	short exclude_end
exclude_2:
	mov	ds,cs:_cstods
	assumes	ds,Data
	mov	cur_needs_update,0
exclude_end:
	pop	ds
	popa	
	mov	sp,bp
	pop	bp
	retn	8

im1024_exclude	endp

	public	im1024_unexclude

im1024_unexclude	proc	near
	push	ds		
	mov	ds, _cstods
	cmp	cur_needs_update, 0FFh
	jnz	unexclude_1
	EnterCrit
	call	im1024_move_cursor
	LeaveCrit
	mov	cur_needs_update, 0
unexclude_1:
	EnterCrit
	mov	screen_busy, NOT_BUSY
	LeaveCrit
	pop	ds
	ret
im1024_unexclude	endp
;
sEnd	Code
page

	end
