        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	IMBITBLT.ASM
;
;   This module contains the code for the IM1024 display driver to blit
;   to/from the screen.
;
; Created: 9 January 2026
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	imagex_read
;			XXBitBlt
;
; Public Functions:	
;
; Public Data:
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;

;
; Ternary raster ops
;
SRCCOPY equ	0CCH	;Straight source -> destination copy
PATINVERT equ	05AH	;XOR with pattern

YSPLIT	equ	220
XSPLIT	equ	330
BUFY	equ	-224	;Y-coordinate of offscreen intermediate blit buffer?

incDevice = 1				;Include control for gdidefs.inc
incDrawMode = 1
	.xlist
	include cmacros.inc
	include gdidefs.inc
	include im1024.inc
	include display.inc
	include macros.mac
	include	cursor.inc
	.list



sBegin	Data


sEnd	Data

sBegin	Code
assumes cs,Code

	externB rops3
	externW	_cstods
	externD im1024_drawmode
	externD	im1024_brush
	externW im1024_linex
	externW im1024_liney
	externW im1024_x
	externW im1024_y
	externW im1024_rectw
	externW im1024_recth
	externW	y_origin
	externW im1024_seg
	externNP im1024_setdrawmode
	externNP im1024_send

	externNP X43D1
	externNP im1024_exclude
	externNP im1024_unexclude
	externNP im1024_setclip

	assumes ds,Data
	assumes es,nothing

	public	source_device, dest_device
	public	xx_bkcolor

source_device	dd	0
dest_device	dd	0
im1024_imagew	dw	0	;Length of command
		db	IM1024_IMAGEW
imagew_row	dw	0
imagew_col1	dw	0
imagew_col2	dw	0
imagew_buf	db	0
X194A		db	SCREEN_WIDTH dup(0)
		db	7 dup(0)
W1D51		dw	0
		dw	0
		dw	0

	public	im1024_blkmov
	public	X194A

im1024_blkmov	dw	0Dh	;Length of command
		db	IM1024_BLKMOV
blkmov_x0	dw	0
blkmov_y0	dw	0
		dw	0	;x1
		dw	0	;y1
		dw	0	;x2
		dw	0	;y2
im1024_imagex	dw	9	;Length of command
		db	IM1024_IMAGEX
		dw	0
		dw	0
		dw	0
		dw	0
		dw	0
xx_brush	db	0
		db	0
xx_pitch	dw	0
xx_white	dw	0FF00h
xx_black	dw	0

	public	xx_bkcolor
	public	xx_textcolor
	public	colour_srcw
	public	colour_srcx
	public	colour_srcy
	public	mono_desty

xx_bkcolor	db	0
xx_textcolor	db	0
colour_srcw	dw	0
colour_srcy	dw	0
mono_desty	dw	0
colour_srcx	dw	0
mono_destx	dw	0
X1D87		db	0
bits2mono_width	dw	0
bits2mono_buf	db	8 dup (0)
		dw	2
		db	7,0,0,0
dev_1d98	dw	2000h
im1024_xadj	dw	0
im1024_xorg	dw	0
im1024_yorg	dw	0
im1024_desty	dw	0
split_h		db	0
split_v		db	0

		public	XXBitBlt
		public	imagex_read

XXBitBlt	proc	near

	push	bp
	mov	bp,sp
	sub	sp,0Ah
;
; The parameters follow BitBlt fairly closely
;
lpDestDev	equ	[bp+20h]
destxOrg	equ	[bp+1Eh]
destyOrg	equ	[bp+1Ch]
lpSrcDev	equ	[bp+18h]
SrcxOrg		equ	[bp+16h]
SrcyOrg		equ	[bp+14h]
xExt		equ	[bp+12h]
yExt		equ	[bp+10h]
Rop		equ	[bp+0Ch]
lpPBrush	equ	[bp+08h]
lpDrawMode	equ	[bp+4]
bp01		equ	byte ptr [bp-1]
bp02		equ	byte ptr [bp-2]
bp04		equ	word ptr [bp-4]
bp06		equ	word ptr [bp-6]
gl_direction	equ	byte ptr [bp-7]
gl_pat_row	equ	byte ptr [bp-8]
gl_phase_h	equ	byte ptr [bp-9]

	mov	gl_direction, al
	mov	gl_pat_row,ah
	mov	gl_phase_h,bl
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	assumes	ds,Code
	assumes	es,Code
	cmp	wptr Rop+2, 0
	jz	xxbitblt_1
	cmp	wptr Rop+2, 0FFh
	jnz	xxbitblt_2
xxbitblt_1:
	mov	bp04, 0F0h
	mov	bp06, 21h
	mov	gl_phase_h, 1
	mov	gl_pat_row, 0
	jmp	short xxbitblt_3
;
xxbitblt_2:
	mov	ax,wptr Rop+2
	mov	bp04,ax
	mov	ax,wptr Rop
	mov	bp06,ax
xxbitblt_3:
	mov	bp01, 0
	cmp	gl_direction,0
	jz	xxbitblt_4
	push	es
	les	di,lpSrcDev
	mov	wptr source_device, di
	mov	wptr source_device+2, es
	pop	es
xxbitblt_4:
	cmp	gl_phase_h, 0
	jz	xxbitblt_8
	push	es
	les	di,lpPBrush
	cmp	wptr Rop+2, 0
	jnz	xxbitblt_5
	mov	di, offset xx_black
	jmp	short xxbitblt_6
;
xxbitblt_5:
	cmp	wptr Rop+2, 0FFh
	jnz	xxbitblt_7
	mov	di, offset xx_white
xxbitblt_6:
	push	cs
	pop	es		;ES:DI points at local white or black brush
xxbitblt_7:
	mov	wptr im1024_brush, di
	mov	wptr im1024_brush+2, es
	pop	es
xxbitblt_8:	
	push	es
	les	di,lpDestDev
	mov	wptr dest_device,di
	mov	wptr dest_device+2,es
	pop	es
	push	es
	les	di,lpDrawMode
	mov	wptr im1024_drawmode, di
	mov	wptr im1024_drawmode+2,es
	mov	al, bptr es:[di].bkColor	
	mov	xx_bkcolor,al
	mov	al, bptr es:[di].TextColor
	mov	xx_textcolor,al
	pop	es
	xor	ax,ax
	cmp	gl_direction, 0
	jz	xxbitblt_10
	mov	di,SrcxOrg
	or	di,di
	jns	xxbitblt_9
	sub	ax,di
	mov	di,0
xxbitblt_9:
	mov	im1024_linex,di
	mov	im1024_xadj,di
	mov	di,SrcyOrg
	mov	im1024_liney,di
	mov	im1024_yorg,di
xxbitblt_10:
	mov	di,destxOrg
	mov	im1024_x,di
	mov	im1024_xorg,di
	mov	di,destyOrg
	mov	im1024_y,di
	mov	im1024_desty,di
	mov	di, xExt
	sub	di, ax
	mov	im1024_rectw, di
	mov	di, yExt
	mov	im1024_recth, di
	mov	wptr split_h, 0
	mov	cl,gl_direction
	mov	ch,gl_pat_row
	jcxz	xxbitblt_13
	cmp	wptr Rop+2, SRCCOPY
	jz	xxbitblt_13
xxbitblt_11:
	xor	ax,ax
;
; Limit the size of a blit to 220 rows x 330 columns. The offscreen buffer 
; can hold 224 rows (1024 - 800) and 330 columns is just under 1/3 of the 
; screen width. So this size guarantees up to three offscreen buffers can
; be used in the copy (at 0,-224; 330,-224; and 660,-224).
;
	cmp	im1024_recth, YSPLIT
	jbe	xxbitblt_12
	mov	al, 0FFh
	mov	split_v,al
	push	im1024_recth
	mov	im1024_recth, YSPLIT
	push	im1024_rectw
	push	im1024_linex
	push	im1024_xadj
	push	im1024_x
	push	im1024_xorg
	push	wptr source_device
	push	wptr source_device+2
	push	wptr dest_device
	push	wptr dest_device+2
xxbitblt_12:
	cmp	im1024_rectw, XSPLIT
	jbe	xxbitblt_13
	mov	ah, 0FFh
	mov	split_h, ah		
	push	im1024_rectw
	mov	im1024_rectw, XSPLIT
	push	im1024_liney
	push	im1024_yorg
	push	im1024_y
	push	im1024_desty
	push	wptr source_device
	push	wptr source_device+2
	push	wptr dest_device
	push	wptr dest_device+2
xxbitblt_13:
	push	ds
	lds	si, lpDestDev
	lodsw
	pop	ds
	or	ax,ax
	jz	xxbitblt_14	;Destination is the screen
	call	X204A
	jmp	short xxbitblt_16
;
xxbitblt_14:
	push	es
	les	di, source_device
	mov	ax, es:[di]	
	pop	es
	or	ax,ax		;Source is the screen?
	jz	xxbitblt_15
	cmp	wptr Rop+2, SRCCOPY
	jnz	xxbitblt_15
	call	X203C
	jmp	xxbitblt_end
;
	assumes	ds,Code
xxbitblt_15:
	mov	bp01, 0FFh
	push	im1024_x
	push	im1024_y
	mov	im1024_x, 2*XSPLIT
	mov	im1024_y, BUFY
	call	X204A
	pop	im1024_y
	pop	im1024_x
	mov	im1024_linex, 2*XSPLIT
	mov	im1024_liney, BUFY
	call	X203C
xxbitblt_16:
	cmp	split_h,0
	jz	xxbitblt_18
	pop	wptr dest_device+2
	pop	wptr dest_device
	pop	wptr source_device+2
	pop	wptr source_device
	pop	im1024_desty
	pop	im1024_y
	pop	im1024_yorg
	pop	im1024_liney
	pop	im1024_rectw
	sub	im1024_rectw, XSPLIT
	cmp	gl_direction, 0
	jz	xxbitblt_17
	add	im1024_linex, XSPLIT
	add	im1024_xadj, XSPLIT
xxbitblt_17:
	add	im1024_x, XSPLIT	
	add	im1024_xorg, XSPLIT
	mov	split_h,0
	jmp	xxbitblt_12
;
xxbitblt_18:
	cmp	split_v,0
	jz	xxbitblt_end
	pop	wptr dest_device+2
	pop	wptr dest_device
	pop	wptr source_device+2
	pop	wptr source_device
	pop	im1024_xorg
	pop	im1024_x
	pop	im1024_xadj
	pop	im1024_linex
	pop	im1024_rectw
	pop	im1024_recth
	sub	im1024_recth, YSPLIT
	cmp	gl_direction, 0
	jz	xxbitblt_19
	add	im1024_liney, YSPLIT
	add	im1024_yorg, YSPLIT
xxbitblt_19:
	add	im1024_y, YSPLIT
	add	im1024_desty, YSPLIT
	mov	split_v, 0
	jmp	xxbitblt_11

xxbitblt_end:
	mov	ax, 1
	mov	sp, bp
	pop	bp
	ret	20h
XXBitBlt	endp

X203C	proc	near
	mov	bp02, 0FFh
	call	X23E5
	call	imagex_read	;Use IMAGEX to read out the bitmap
	call	im1024_unexclude
	ret
X203C	endp

X204A	proc	near
	mov	bp02, 0
	call	X23E5
	cmp	gl_direction, 0
	jz	X205A
	call	X2080
X205A:
	cmp	gl_pat_row, 0
	jz	X2069
	cmp	wptr Rop+2, PATINVERT
	jz	X2069
	call	X20C8
X2069:
	mov	al,bp01
	cbw
	mov	di, ax
	push	es
	mov	es, di
	call	im1024_setclip
	pop	es
	call	apply_rop
X2079:
	call	im1024_unexclude
	mov	ax, 1
	ret
X204A	endp

X2080	proc near
	push	ax
	mov	al, 0
	cmp	wptr Rop+2, SRCCOPY
	jnz	X2091
	call	X21AF
	pop	ax
	pop	ax
	jmp	short X2079
;
X2091:	push	im1024_x
	push	im1024_y
	mov	im1024_x, 0
	mov	im1024_y, BUFY
	call	X21AF
	pop	im1024_y
	pop	im1024_x
	mov	wptr source_device, offset dev_1d98
	mov	wptr source_device+2, es
	mov	im1024_linex, 0
	mov	im1024_liney, BUFY
	pop	ax
	ret
X2080	endp
;
X20C8	proc	near
	push	im1024_linex
	push	im1024_liney
	push	im1024_x
	push	im1024_y
	mov	im1024_x, XSPLIT
	mov	im1024_y, BUFY
	mov	ax,im1024_xorg
	mov	im1024_linex, ax
	mov	ax,im1024_desty
	mov	im1024_liney, ax
	push	ds
	lds	si,lpDestDev
	lodsw
	or	ax, ax
	jz	X2101
	pop	ds
	xor	al, al
	call	im1024_blkmove	;Accelerated screen to screen blit
	jmp	short X2121
;
X2101:	push	wptr cs:source_device
	push	wptr cs:source_device+2
	mov	wptr cs:source_device, si
	mov	wptr cs:source_device+2, ds
	pop	ds
	call	im1024_imagewrite
	pop	wptr source_device+2
	pop	wptr source_device
X2121:	pop	im1024_y
	pop	im1024_x
	pop	im1024_liney
	pop	im1024_linex
	ret
;
X20C8	endp

apply_rop	proc near
	push	ax
	push	cx
	push	dx
	push	si
	mov	ax,bp04
	cmp	ax,80h
	jc	X2142
	neg	al
	dec	al
X2142:	mov	si, ax
	mov	ax, 12
	mul	si
	mov	si, ax
	add	si, offset rops3
	mov	cx, 6
X2152:	lodsw
	or	al,al
	jz	X21A0
	push	cx
	push	si
	cmp	al,1
	jnz	X2172
	dec	si
	or	ah,ah
	jnz	X216D
	cmp	bp04, 80h
	jc	X216D
	pop	si
	pop	cx
	jmp	short apply_rop_end
;
X216D:	call	X21E5
	jmp	short X219C
;
X2172:	xchg	ah,al
	cmp	ah, 'S'
	jnz	X217E
	call	X21AF
	jmp	short X219C
;
X217E:	cmp	ah, 'P'
	jnz	X2194
	cmp	bp01, 0FFh
	jnz	X218F
	mov	im1024_y, 0
X218F:	call	X43D1
	jmp	short X219C
;
X2194:	cmp	ah, 'D'
	jnz	X219C
	call	X21C5
X219C:	pop	si
	pop	cx
	loop	X2152
;
X21A0:	cmp	bp04, 80h
	jc	apply_rop_end
	call	X21E5
;
apply_rop_end:	pop	si
	pop	dx
	pop	cx
	pop	ax
	ret

apply_rop	endp

X21AF	proc	near
	push	es
	les	di,source_device
	mov	di,es:[di]
	or	di,di
	pop	es
	jz	X21C1
	call	im1024_blkmove
	jmp	short	X21C4
;
X21C1:	call	im1024_imagewrite
X21C4:	ret
X21AF	endp

X21C5	proc	near
	push	im1024_linex
	push	im1024_liney
	mov	im1024_linex, XSPLIT
	mov	im1024_liney, BUFY
	call	im1024_blkmove
	pop	im1024_liney
	pop	im1024_linex
	ret
X21C5	endp

X21E5	proc	near
	push	wptr im1024_brush
	push	wptr im1024_brush+2
	mov	xx_brush, 0
	mov	wptr im1024_brush, offset xx_brush
	mov	ax,cs
	mov	wptr im1024_brush+2, ax
	mov	al,1
	call	X43D1
	pop	wptr im1024_brush+2
	pop	wptr im1024_brush
	ret
X21E5	endp

im1024_blkmove	proc near
	call	im1024_setdrawmode
	mov	bp02, 0FFh
	call	X23E5
	mov	di, offset blkmov_x0
	mov	ax, im1024_linex
	mov	bx, ax
	stosw
	mov	si, im1024_liney
	mov	ax, y_origin
	sub	ax, si
	mov	cx,ax
	add	di, 2
	mov	ax,bx
	add	ax,im1024_rectw
	dec	ax
	stosw
	add	si,im1024_recth
	mov	ax, y_origin
	sub	ax,si
	xchg	ax,cx
	stosw
	inc	cx
	mov	blkmov_y0,cx
	mov	ax,im1024_x
	stosw
	mov	si,im1024_y
	mov	ax, y_origin
	sub	ax, si
	sub	ax, im1024_recth
	inc	ax
	stosw
	mov	si,offset im1024_blkmov
	call	im1024_send
	ret

im1024_blkmove	endp

	public	im1024_imagewrite

im1024_imagewrite	proc	near
	push	ds
	lds	si, im1024_drawmode
	mov	al, bptr [si].bkColor	
	mov	ah, bptr [si].TextColor
	pop	ds
	mov	xx_bkcolor,al
	mov	xx_textcolor,ah
	mov	cx,im1024_x
	mov	imagew_col1,cx
	mov	ax, im1024_rectw	;Number of bytes to write
	add	cx,ax
	dec	cx
	mov	imagew_col2, cx
	mov	im1024_imagew, ax	;Length of command
	add	im1024_imagew, 7	;+ 7 fixed bytes
	mov	bx, 80h
	xor	dx, dx
	div	bx
	add	im1024_imagew, ax
	mov	di, offset imagew_buf
	mov	cx,ax
	or	ax,ax
	jz	X22AA
	push	cx
	mov	al,-1
X22A2:	stosb
	add	di,80h
	loop	X22A2
	pop	cx
X22AA:	or	dx,dx
	jz	X22B8
	inc	im1024_imagew
	mov	al,dl
	add	al,7Fh
	stosb
	inc	cx
X22B8:	mov	dx,cx
	mov	cx,im1024_recth
	mov	ax,y_origin
	sub	ax,im1024_y
	mov	imagew_row,ax
	mov	W1D51, 0
X22CE:	call	X22E2
	mov	si, offset im1024_imagew
	call	im1024_send
	dec	imagew_row
	inc	W1D51
	loop	X22CE
	ret
;
im1024_imagewrite	endp
;
; Copy from memory form into imagew_buf
;
X22E2	proc	near
	pusha
	push	ds
	lds	si,source_device
	cmp	byte ptr [si].bmBitsPixel, 8
	jnz	X2324		;Mono bitmap
	mov	ax, cs:im1024_liney
	add	ax, cs:W1D51
	push	dx
	mul	word ptr [si].bmWidthBytes
	add	ax, cs:im1024_linex
	pop	dx
	lds	si, [si].bmBits
	add	si, ax
	mov	di, offset imagew_buf + 1
	mov	al,cs:imagew_buf
	sub	al,7Fh
	xor	ah,ah
	mov	cx,dx
X2313:	push	cx
	mov	cx,ax
	rep	movsb
	pop	cx
	mov	al, es:[di]
	sub	al,7Fh
	inc	di
	loop	X2313
	jmp	X23E2
;
X2324:	mov	ax,cs:im1024_liney
	add	ax,cs:W1D51
	push	dx
	mul	word ptr [si].bmWidthBytes
	pop	dx
	lds	si, [si].bmBits
	add	si,ax		;-> start of line
	mov	ax, cs:im1024_linex
	mov	cs:mono_destx, 0
	or	ax,ax
	jz	X2356
	push	dx
	mov	cx,8
	xor	dx,dx
	div	cx	;X-coord to byte
	add	si,ax
	mov	cs:mono_destx, dx
	pop	dx
X2356:	mov	di,offset imagew_buf+1
	mov	al,cs:imagew_buf
	sub	al,7Fh
	xor	ah,ah
	mov	cx,dx
	mov	cs:X1D87, 0FFh
X2369:	push	cx
	mov	dx,ax
	xor	bx,bx
X236E:	lodsb	
	cmp	cs:X1D87, 0FFh
	mov	cs:X1D87, 0
	jnz	X238E
	mov	cx,cs:mono_destx
	shl	al,cl
	mov	cx,8
	sub	cx,cs:mono_destx
	jmp	short	X2391

X238E:	mov	cx,8
X2391:	rcl	al,1
	push	ax
	jnc	X239C	;background pixel?
	mov	al,cs:xx_bkcolor
	jmp	short X23A0
X239C:	mov	al,cs:xx_textcolor
X23A0:	stosb
	pop	ax
	inc	bx
	cmp	bx,dx
	jnc	X23AB
	loop	X2391
	jmp	short X236E
;
X23AB:	jcxz	X23D9
	dec	cx
	jcxz	X23D9
	mov	bx,cx
	pop	cx
	cmp	cx,1
	jz	X23E2
	mov	dl,es:[di]
	sub	dl,bl
	inc	di
	xchg	cx,bx
X23C0:	rcl	al,1
	push	ax
	jnc	X23CB
	mov	al,cs:xx_bkcolor
	jmp	short X23CF
;
X23CB:	mov	al,cs:xx_textcolor
X23CF:	stosb
	pop	ax
	loop	X23C0
	mov	cx,bx
	mov	al,dl
	jmp	short X23DE
;
X23D9:	pop	cx
	mov	al,es:[di]
	inc	di
X23DE:	sub	al,7Fh
	loop	X2369
X23E2:	pop	ds
	popa
	ret

X22E2	endp

X23E5	proc	near
	push	ax
	cmp	bp02, 0FFh
	jz	X2406
	push	im1024_x
	push	im1024_y
	mov	ax, im1024_x
	add	ax, im1024_rectw
	push	ax
	mov	ax, im1024_y
	add	ax, im1024_recth
	push	ax
	jmp	short X241E
;
X2406:	push	im1024_linex
	push	im1024_liney
	mov	ax, im1024_linex
	add	ax, im1024_rectw
	push	ax
	mov	ax, im1024_liney
	add	ax, im1024_recth
	push	ax
X241E:	call	im1024_exclude
	pop	ax
	ret
X23E5	endp

imagex_read	proc	near
	pusha
	push	es
	les	di, dest_device
	mov	bl, es:[di].bmBitsPixel
	push	bx
	mov	bx, es:[di].bmWidthBytes
	mov	xx_pitch, bx
	mov	ax, im1024_recth
	dec	ax
	mul	bx
	push	ax
	les	di, es:[di].bmBits
	mov	ax, im1024_y
	mul	bx
	add	di, ax	;Y * pitch + X
	pop	ax
	add	di, ax
	mov	cx, im1024_recth
	mov	dx, im1024_liney
	mov	ax, y_origin
	push	ax
	sub	ax, dx
	mov	si, offset im1024_imagex ; IMAGEX command
	mov	[si+9],ax		; Last Y
	add	dx,cx
	dec	dx
	pop	ax
	sub	ax, dx
	mov	[si+5], ax		;First Y
	mov	bx, im1024_linex
	mov	[si+3], bx		;First X
	push	cx
	mov	cx, im1024_rectw
	add	bx, cx
	dec	bx
	cmp	bx, SCREEN_WIDTH
	pop	cx
	jc	imagex_read_1
	mov	bx, SCREEN_WIDTH - 1
	push	bx
	inc	bx
	sub	bx, im1024_linex
	mov	im1024_rectw, bx
	pop	bx
imagex_read_1:	
	mov	[si+7], bx	;Second X
	call	im1024_send
	pop	bx
imagex_read_2:	
	push	cx
	push	di
	xor	dx,dx
	mov	ax, im1024_x
	cmp	bl, 8
	jz	imagex_read_3
	mov	cx, 8
	div	cx
imagex_read_3:	
	add	di, ax
	mov	mono_destx, dx
	call	receive_row
	pop	di
	sub	di, xx_pitch
	pop	cx
	loop	imagex_read_2
	pop	es
	popa	
	ret

imagex_read	endp
;
; Receive a row of data from the IM1024.
; Enter with bl=8 if destination bitmap is in native format, else mono is 
; assumed.
;
receive_row	proc	near
	mov	cx, im1024_rectw	;If receive rectangle width = 0
	or	cx,cx			;then there is nothing to do.
	jnz	receive_row_1
	jmp	recive_row_ret
;
; Receive im1024_rectw bytes from the video card (ie, one line's worth of 
; pixels). Take as much from the buffer as we can and rep movsb it into 
; memory
;
receive_row_1:	
	cmp	bl, 8			;In native format?
	jnz	receive_row_mono
	xor	dx, dx
receive_row_2:
	push	ds
	mov	ds, im1024_seg
receive_row_3:	
	mov	al, ds:bptr IM1024_RECV_R
	xor	ah, ah
	mov	si, ax	;Read pointer
	mov	al, ds:bptr IM1024_RECV_W
	sub	ax, si
	ja	receive_row_6
	jb	receive_row_5
	push	cx	;Wait for returned data
	mov	cx, 24h	;So briefly spin the CPU
receive_row_4:
	push	cx
	pop	cx
	loop	receive_row_4
	pop	cx
	jmp	receive_row_3

receive_row_5:
	mov	ax, 100h
	sub	ax, si
receive_row_6:
	cmp	cx, ax
	jbe	receive_row_7
	mov	cx,ax
receive_row_7:
	add	si,100h	;-> receive buffer
	add	dx,cx
	rep	movsb
	sub	si, 100h
	and	si, 0FFh
	mov	ax, si
	mov	ds:bptr IM1024_RECV_R, al	;Update receive counter
	pop	ds
	mov	cx, im1024_rectw
	sub	cx, dx
	jnz	receive_row_2		;More to come
	jmp	short recive_row_ret
	nop
;
; Mono receive. Read a byte at a time and spit it into the mono form
;
receive_row_mono:
	push	ds
	mov	ds, im1024_seg
receive_row_mono_1:
	mov	al, ds:bptr IM1024_RECV_W	;Wait for a byte 
	cmp	al, ds:bptr IM1024_RECV_R	;to become available
	jz	receive_row_mono_1
	mov	si, 100h
	mov	al, ds:bptr IM1024_RECV_R
	xor	ah, ah
	add	si, ax
	xchg	al, ah
	lodsb					;Get the byte (into AL)
	inc	ah
	mov	ds:bptr IM1024_RECV_R, ah	;Store the new read pointer
	pop	ds
	mov	si, bits2mono_width		;Add new value into the 
	mov	bits2mono_buf[si], al		;8-byte-buffer
	inc	si
	cmp	si, 8
	jc	receive_row_mono_2
	mov	bits2mono_width, si		;If we have 8, flush the buffer
	call	colour_to_mono
receive_row_mono_2:
	mov	bits2mono_width, si
	loop	receive_row_mono		;Read the next byte and so on
	cmp	bits2mono_width, 0
	jz	recive_row_ret			;If there's anything left in
	call	colour_to_mono			;the buffer at the end, flush it
	mov	bits2mono_width, si

recive_row_ret:	
	ret
receive_row	endp
;
; Convert colour to mono (colour pattern at bits2mono_buf, destination at DI)
;
colour_to_mono	proc	near
	push	ax
	push	cx
	mov	si, offset bits2mono_buf
	mov	al, es:[di]		;Destination byte
	mov	ah, 80h			;Bitmask for current pixel
	mov	cx, mono_destx
	shr	ah, cl
	mov	cx, bits2mono_width
colour_to_mono_1:
	push	ax
	lodsb
	cmp	al, xx_bkcolor
	jz	colour_to_mono_2
	mov	xx_textcolor, al	;Foreground bit
	pop	ax
	not	ah			;Toggle mask
	and	al, ah			;Clear bit in target bitmap
	not	ah			;Toggle mask back
	jmp	short colour_to_mono_3
;
colour_to_mono_2:
	pop	ax			;Background bit
	or	al, ah
colour_to_mono_3:
	ror	ah, 1			;Next bit in byte
	cmp	ah, 80h			;Has it wrapped?
	jnz	colour_to_mono_4
	stosb				;Move to next byte in mono bitmap
	mov	al, es:[di]
colour_to_mono_4:
	loop	colour_to_mono_1
	mov	es:[di],al
	xor	si,si
	pop	cx
	pop	ax
	ret
colour_to_mono	endp
;
; This code does not appear to be used at all -- at least, I can't see any
; code that calls it or makes reference to it in other ways.
;
; It appears to be designed to blit from a mono bitmap to a colour one
;
; DS:SI->source bitmap
; ES:DI->dest bitmap
;
monotocolour	proc	near
	push	ds
	push	si
	lds	si,lpDrawMode
	mov	al, bptr [si].bkColor	
	mov	ah, bptr [si].TextColor
	pop	si
	pop	ds
	mov	cs:xx_bkcolor,al
	mov	cs:xx_textcolor,ah
	mov	bx, [si].bmWidthBytes
	mov	cs:xx_pitch,bx
	mov	ax, im1024_yorg
	mul	bx
	lds	si, [si].bmBits
	add	si, ax
	mov	bx, es:[di].bmWidthBytes
	mov	ax, ds:im1024_desty	;BUG: But DS still pointing at the
					;source bitmap. Should be:
;	mov	ax, cs:im1024_desty	
	mul	bx
	les	di, es:[di].bmBits
	add	di, ax
monotocolour_1:
	push	cx
	push	si
	push	di
	xor	dx,dx
monotocolour_2:
	lodsb
	mov	cx,8
monotocolour_3:
	rcl	al,1
	push	ax
	jnc	monotocolour_4
	mov	al,cs:xx_bkcolor
	jmp	short monotocolour_5
monotocolour_4:
	mov	al,cs:xx_textcolor
monotocolour_5:
	stosb
	pop	ax
	inc	dx
	cmp	dx, xExt
	jnc	monotocolour_6
	loop	monotocolour_3
	jmp	short monotocolour_2
;
monotocolour_6:
	pop	di
	add	di, bx
	pop	si
	add	si, cs:xx_pitch
	pop	cx
	loop	monotocolour_1
	ret
;
monotocolour	endp
;
; DS:SI->source bitmap
; ES:DI->dest bitmap
;
	public	colourtomono

colourtomono	proc	near
	pusha
	push	ds
	push	es
	mov	bx,[si].bmWidthBytes
	mov	cs:xx_pitch, bx
	mov	ax, cs:colour_srcy
	mul	bx
	lds	si,[si].bmBits
	add	si,ax
	mov	bx,es:[di].bmWidthBytes
	mov	ax, cs:mono_desty
	mul	bx
	les	di,es:[di].bmBits
	add	di,ax
colourtomono_1:
	push	cx
	push	si
	push	di
	xor	dx, dx
colourtomono_2:	
	xor	al, al
	mov	ah, 80h
	mov	cx, 8
colourtomono_3:
	push	ax
	lodsb
	cmp	al,cs:xx_bkcolor
	jz	colourtomono_4
	pop	ax
	or	al,ah
	jmp	short colourtomono_5
;
colourtomono_4:
	pop	ax
colourtomono_5:
	shr	ah,1
	or	ah,ah
	jnz	colourtomono_6
	stosb
colourtomono_6:
	inc	dx
	cmp	dx, cs:colour_srcw
	jnc	colourtomono_7
	loop	colourtomono_3
	loop	colourtomono_2
colourtomono_7:
	pop	di
	add	di,bx
	pop	si	
	add	si,cs:xx_pitch
	pop	cx
	loop	colourtomono_1
	pop	es
	pop	ds
	popa
	ret
colourtomono	endp
;
sEnd	Code
page

	end
