        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CURSORS.ASM
;
; This module contains the routines which are required to manage
; the cursor image.  The actual cursor drawing primitive reside
; elsewhere.
;
; Create   15-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1987  Microsoft Corporation
;
; Exported Functions:	SetCursor
;			CheckCursor
;			MoveCursor
;
; Public Functions:	exclude
;			unexclude
;
; Public Data:		screen_busy
;
; General Description:
;
;   All display drivers must support a "cursor" for the pointing
;   device.  The cursor is a small graphics image which is allowed
;   to move around the screen independantly of all other operations
;   to the screen, and is normally bound to the location of the
;   pointing device.  The cursor is non-destructive in nature, i.e.
;   the bits underneath the cursor image are not destroyed by the
;   presence of the cursor image.
;
;   Logically, the cursor image isn't part of the physical display
;   surface.  When a drawing operation coincides with the cursor
;   image, the result is the same as if the cursor image wasn't
;   there.  In reality, if the cursor image is part of the display
;   surface it must be removed from memory before the drawing
;   operation may occur, and redrawn at a later time.
;
;   This exclusion of the cursor image is the responsibility of
;   the display driver.  If the cursor image is part of physical
;   display memory, then all output operations must perform a hit
;   test to determine if the cursor must be removed from display
;   memory, and set a protection rectangle wherein the cursor must
;   not be displayed.  The actual cursor image drawing routine
;   must honor this protection rectangle by never drawing the
;   cursor image within its boundary.
;
;
; Restrictions:
;
;   The Window Manager is responsible for mapping generic cursors
;   into the correct size for the driver, as specified in the
;   display driver's resources.
;
;   The segments containing these routines and their data must be fixed
;   in memory since they are called at interrupt time.
;
;   The exclusion rectangle is a serially reusabel resource.  Only
;   one may be defined at any given moment.  There is no check for
;   this.  It is assumed that there will never be contention for it
;   since Windows is non-preemptive.
;
;-----------------------------------------------------------------------;

CURSOR_SAVE_X	equ	991
CURSOR_SAVE_Y	equ	991

incDevice	= 1

	.xlist
	include cmacros.inc
	include windefs.inc
	include gdidefs.inc
	include im1024.inc
	.list

	??_out	Cursors

	externNP im1024_send		;Send a command to the IM1024
	externNP im1024_w_byte		;Send a single byte to the IM1024
	externNP im1024_setclip
	externNP im1024_move
	externNP im1024_setdrawmode
	externNP im1024_color

sBegin	Data

	public cur_flags
	public cursor_width
	public cursor_height
	public cursor_xhot
	public cursor_yhot
	public cursor_tdefin

CUR_OFF 	equ	10000000b	;  Null cursor has been specified
CUR_EXCLUDED	equ	01000000b	;  Cursor has been excluded
cur_flags	db	0FFh	 	;Cursor status, initially hidden

IS_BUSY 	equ	0FFh		;  Cursor operation in progress
NOT_BUSY	equ	0		;  No cursor operation in progress

cursor_width	dw	0
cursor_height	dw	0
cursor_xhot	dw	0
cursor_yhot	dw	0

;	The following words contain the bounding rectangle wherein the
;	cursor is not allowed to be displayed.	The values for left and
;	right will always be rounded to contain the entire byte (or
;	word or dword if working to those boundaries).
;
;	These values will only be valid if exclude_count is non-zero.
;
;	NOTE: Only one rectangle at a time may be set.

exclude_count	db	0		;Set non-zero if rectangle is valid
RECT_PRES	equ	1		;  Exclusion rectangle set
RECT_NOT_PRES	equ	0		;  No exclusion rectangle set

exclude_left	dw	0		;left side  of exclusion rectangle
exclude_top	dw	0		;top	    of exclusion rectangle
exclude_right	dw	0		;right side of exclusion rectangle
exclude_bottom	dw	0		;bottom     of exclusion rectangle


;	(x_cell,y_cell) is the location of the cursor on the screen.
;	These locations are only updated whenever a cursor is drawn.
;
;	(real_x,real_y) is the location of the cursor as specified
;	by the user.  These locations are always kept current.
;
;	These cells may not be the same if the cursor drawing takes
;	a lot of time and the mouse is moving quickly.	Therefore,
;	after a cursor has been drawn, a check must be made to see
;	if the cursor has moved, and if so the cursor must be drawn
;	again.





;	hot_x and hot_y contain the hot spot adjustment for the cursor.
;
;	These locations should be zeroed whenever a cursor is changing
;	or has been turned off, and should be set once a cursor has
;	been defined.  When the cursor is turned off, the hot spot
;	adjustment should be added back to the real cursor coordinates
;	(real_x, real_y).  When a cursor is set, they should be
;	subtracted off.  This will keep the cursor based at the hot
;	spot during a change instead of the upper left corner.

	db	40h dup(0)

hot_x	 dw	 0			 ;X hot spot adjustment
hot_y	 dw	 0			 ;Y hot spot adjustment

	public	cursor_x
	public	cursor_y
cursor_x	dw	0
cursor_y	dw	0


;	screen_busy is a flag used for critical section code to
;	indicate that the screen is busy.  Since cursor operations
;	take a very long time (e.g. drawing a cursor), the screen_busy
;	flag is set to 0 to show that the screen is busy, and then
;	interrupts are enabled to allow other interrupts.  The basic
;	operation for the semephore is:
;
;		xor	cx,cx
;		xchg	screen_busy,cx
;		jcxz	operation_in_progress

	public	screen_busy
screen_busy	db	NOT_BUSY, 0	;Show screen not busy

	public	cur_needs_update
cur_needs_update db	0FFh,0

		externB	draw_mode

;	cur_flags contains control flags indicating the cursor status.
;	Flags are defined for the cursor being off, and the cursor being
;	excluded.


sEnd	Data


sBegin	Code
       		externNP physical_enable        ;Enable routine
       		externNP physical_disable       ;Disable routine
	        externB  physical_device        ;Device physical data   
		externB	info_table_base		;GDIInfo table
		externA	PHYS_DEVICE_SIZE	;Size of physical device
		externW im1024_blkmov
		externW y_origin
		externW _cstods

assumes cs,Code

page
;--------------------------Exported-Routine-----------------------------;
; WORD Inquire(lpCURSORINFO)
; CURSORINFO far *lpCURSORINFO; //pointer where cursor info goes
; 
; Information about the pointer is returned to the caller in the
; given buffer.  The number of bytes copied into lpCURSORINFO
; is returned.
;
; Warnings:
;	Destroys AX,CX,ES,FLAGS
; Effects:
;	none
; Calls:
;	none
; History:
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	Made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; WORD Inquire(lpCURSORINFO)
; CURSORINFO far *lpCURSORINFO; 	//pointer where cursor info goes
; {
;   *lpCURSORINFO = inquire_data;	//copy entire structure
;   return (sizeof(CURSORINFO));
; }
;-----------------------------------------------------------------------;
cProc	Inquire,<PUBLIC,FAR,WIN,PASCAL>,<si,di,es>

	parmD	lp_cursor_info		;Where to put the data

cBegin
	cld
	les	di,lp_cursor_info	;--> destination area
	assumes es,nothing
	
	mov	ax, 1	;dpXRate
	stosw
	mov	ax, 2	;dpYRate
	stosw
	mov	ax, 4	;Length of cursor info
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4
cEnd	<nogen>

page
;--------------------------Exported-Routine-----------------------------;
; SetCursor - Set Current Cursor Shape
;
;   This is a private entry point within the display driver for the
;   Window Manager.
;
;   The given cursor shape is saved in local storage to be used as
;   the current cursor shape.  If the pointer to the cursor shape is
;   NULL, then no cursor is to be drawn.
;
;   The given cursor shape will have been converted from generic form
;   into the dimensions requested by this driver.
;
;   Any cursor on the screen will be removed before the new cursor
;   shape is set.  The drawing of the new cursor will be delayed
;   until the check_cursor routine is called (check_cursor is the
;   only routine that can make the cursor become visible).
;
;   If this routine is reentered, the request will be ignored.
;
; Entry:
;	None
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	cursor_off
;	move_cursor
; History:
;	Sun 15-Feb-1987 16:47:15 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; void SetCursor(lp_cursor)
; CURSOR far *lp_cursor
; {
;   WORD    old_busy;
;
;   old_busy = IS_BUSY; 		// Try for screen semephore
;   if (swap(screen_busy, old_busy) == IS_BUSY)
;	return();
;
;   // We control the vertical.  We control the horizontal.
;   // We control the screen semephore.  Since we do, we can
;   // enable and disable interrupts at our will without
;   // worry that somebody will do something to the cursor image.
;
;   disable_interrupts; 		// Treat as a critical section
;   cur_flags = CUR_OFF;		// Assume a null cursor;
;   real_x += hot_x;			// Remove hot spot adjustment
;   real_y += hot_y;			//   from real (X,Y) position
;   hot_x = hot_y = 0;			// Don't want hot spot adjustments
;   enable_interrupts;			// Interrupt can play with real x & y
;   cursor_off();			// Remove old cursor from screen
;   if (lp_cursor)			// If there is a new cursor shape
;   {
;	copy(cur_cursor,lp_cursor);	// Copy cursor header information
;	move_cursors(); 		// Move the patterns, adj. hot spot
;	disable_interrupts;		// Treat as a critical section
;	hot_x = cur_cursor.csHotX	// Save X hot spot adjustment
;	hot_y = cur_cursor.csHotY	// Save Y hot spot adjustment
;	real_x -= hot_x;		// Adjust real (X,Y) for the
;	real_y -= hot_y;		//   hot spot
;	cur_flags = CUR_EXCLUDED;	// Show excluded, but not hidden
;	enable_interrupts;
;   }
;   screen_busy = NOT_BUSY;		// Others can have the screen now
; }
;-----------------------------------------------------------------------;

im1024_twrite	dw	3
		db	IM1024_TWRITE, 1, 0
cursor_tdefin	dw	4
		db	IM1024_TDEFIN, 0, 0, 0


cProc	SetCursor,<FAR,PUBLIC,WIN,PASCAL>,<si,di,es>

	parmD	lp_cursor		;Far pointer to new cursor shape

cBegin
	assumes ds,Data 		;Set up by prologue
	assumes es,nothing		;Have no idea what's in it

	push	ds
	mov	ds, cs:_cstods
	mov	screen_busy, IS_BUSY
	push	cs
	pop	ds
	assumes ds,Code
	call	cursor_off		;Remove old cursor from screen
; XXX	cld				;Just in case

	les	di,lp_cursor		;--> cursor shape

	mov	ax,es			;If the cursor pointer is null,
	or	ax,di			;  then no cursor is to be drawn
	jz	set_cursor_10		;They don't want a cursor

	mov	ax,es:[di].csWidth
	mov	bx,es:[di].csHeight
	mov	cx,es:[di].csHotX
	mov	dx,es:[di].csHotY
	mov	byte ptr cursor_tdefin+4, al
	mov	byte ptr cursor_tdefin+5, bl
	push	ds
	mov	ds, _cstods
	assumes ds,Data
	mov	cursor_width, ax
	mov	cursor_height, bx
	mov	cursor_xhot, cx
	mov	cursor_yhot, dx	
	pop	ds
	assumes ds,Code
	mov	ax,es:[di].csWidthBytes
	mul	bx			;Length of shape
	mov	cx,ax
	mov	si, offset cursor_tdefin
	mov	byte ptr [si+3], 0
	call	im1024_send		;Start defining cursor bitmap
	push	ds
	lds	si,lp_cursor
	add	si,0Ch			;offset to cursorShape
	push	cx
wcursor:
	lodsb				;Define character 0 as the first mask
	not	al
	call	im1024_w_byte
	loop	wcursor
	pop	cx
	pop	ds
	push	si
	mov	si, offset cursor_tdefin
	mov	byte ptr [si+3], 0FFh
	call	im1024_send
	pop	si
	push	ds
	mov	ds,seg_lp_cursor
wcursor2:
	lodsb				;Define character 0xFF as the second
	call	im1024_w_byte
	loop	wcursor2
	pop	ds
	call	im1024_move_cursor

set_cursor_10:
	assumes es,Data 		;Can only guarantee that ES has
	assumes ds,nothing		;  the data segment selector

	pop	ds
	assumes ds,Data
	mov	screen_busy,NOT_BUSY
	mov	ax, 1
	assumes es,nothing

set_cursor_20:
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4

cEnd	<nogen>

	public	im1024_move_cursor

im1024_move_cursor	proc	near
	pusha
	push	ds
	push	es
	mov	ds,cs:_cstods
	assumes ds,Data
	cmp	cur_flags, 0FFh
	jz	movecur_ret
	mov	al,0
	call	cursor_blit
	mov	cur_flags, 0FFh
	mov	ax,cursor_x
	sub	ax,cursor_xhot
	mov	bx,cursor_y
	sub	bx,cursor_yhot
	mov	cx,cursor_width
	mov	dx, cursor_height
	push	cs
	pop	ds
	assumes ds,Code
	xor	di,di
	mov	es,di
	call	im1024_setclip		;Disable clipping
	neg	bx
	call	im1024_move
	mov	al,3			;AND mode
	call	im1024_setdrawmode
	mov	si, offset im1024_color
	mov	byte ptr [si+3], 0	;Draw in colour 0
	call	im1024_send
	mov	si, offset im1024_twrite
	mov	byte ptr [si+4], 0
	call	im1024_send		;Draw AND mask
	mov	al,2			;XOR mode
	call	im1024_setdrawmode
	mov	si, offset im1024_color
	mov	byte ptr [si+3], 0FFh	;Draw in colour 0FFh
	call	im1024_send
	mov	si, offset im1024_twrite
	mov	byte ptr [si+4], 0FFh
	call	im1024_send		;Draw XOR mask
movecur_ret:
	pop	es
	pop	ds
	popa
	retn	
im1024_move_cursor	endp

	public	cursor_off

cursor_off	proc	near
	pusha
	push	ds
	push	es
	mov	ds, cs:_cstods
	assumes ds, Data
	cmp	cur_flags, 0	;Cursor already off?
	jz	cursor_off_1
	mov	al, 1
	call	cursor_blit	;Undraw it if drawn
	mov	cur_flags, 0
cursor_off_1:
	pop	es
	pop	ds
	popa	
	ret
cursor_off	endp
;
	assumes ds,Data
cursor_blit	proc	near	
	push	bp
	mov	bp,sp
	sub	sp,2
	mov	bl,draw_mode	;Save current draw mode, we're going to be
	mov	[bp-1],bl	;changing it
	mov	bx,cursor_width
	mov	cx, cursor_height
	or	bx,bx
	jnz	cursor_blit_1
	jmp	short cursor_blit_ret
	nop
;
cursor_blit_1:
	or	cx,cx
	jz	cursor_blit_ret
	mov	dx, cursor_x
	sub	dx, cursor_xhot
	mov	di, cursor_y
	sub	di, cursor_yhot
	push	ds
	push	cs
	pop	ds
	assumes ds,Code
	push	ax
	mov	al,0
	call	im1024_setdrawmode
	pop	ax
	mov	si, offset im1024_blkmov
	or	al,al
	jz	cursor_blit_2
;
; Copying from save area to cursor position
;
	mov	ax, CURSOR_SAVE_X
	mov	[si+3],ax
	add	ax,bx
	mov	[si+7],ax
	mov	ax, CURSOR_SAVE_Y
	mov	[si+5],ax
	add	ax,cx
	mov	[si+9],ax
	mov	[si+11],dx
	mov	ax, y_origin
	sub	ax, di
	sub	ax, cx
	mov	[si+13], ax
	jmp	short cursor_blit_3
;
; Copying from cursor position to save area
;
cursor_blit_2:
	mov	[si+3],dx
	mov	ax, y_origin
	sub	ax,di
	mov	[si+9],ax
	add	dx,bx
	mov	[si+7],dx
	add	di,cx
	mov	ax,y_origin
	sub	ax,di
	mov	[si+5],ax
	mov	word ptr [si+11], CURSOR_SAVE_X
	mov	word ptr [si+13], CURSOR_SAVE_Y
cursor_blit_3:
	call	im1024_send
	mov	al,[bp-1]
	call	im1024_setdrawmode
	pop	ds
cursor_blit_ret:
	mov	sp, bp
	pop	bp
	ret

cursor_blit	endp

sEnd	code


end
