	
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	STRBLT.ASM
;
;   This module contains the strblt function and the ExtendedTextOut
;   function.
;
; Created: 17-Mar-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Strblt
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


FIXED_PITCH_ON = 1			;en/disables smartfix code


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.	?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.


?CHKSTK = 1
?CHKSTKPROC	macro
		endm


	.xlist
	include cmacros.inc
incFont 	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include control for gdidefs.inc
	include gdidefs.inc
	include display.inc
	include apricot.inc
	include macros.mac
	include strblt.inc
	include fontseg.inc
	.list


	??_out	strblt


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_WIDTH		;Screen width in pixels
	externA COLOR_FORMAT		;Color format (0103h or 0104h)


;	Other functions required for strblt.

ifdef	 EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


sBegin	Code
assumes cs,Code


page
;--------------------------Exported-Routine-----------------------------;
; Strblt
;
; This is the old strblt entry point.  Null parameters are pushed
; for the ExtTextOut's extra parameters, and control given to
; ExtTextOut.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX = Y extent of string if extent call
;	AX = X extent of string if extent call
;	EGA registers in default state
; Error Returns:
;	DX:AX = 8000:0000H
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	See ExtTextOut
; History:
;	Thu 09-Apr-1987 13:36:08 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing
;
; WIN1 In Windows 1, STRBLT now becomes live!
;
cProc	Strblt,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;[bp+20h] Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

;	ExtTextOut parameters we have to dummy up.
;
;	parmD	lp_dx			;Widths for the characters
;	parmD	lp_opaque_rect		;Opaquing rectangle
;	parmW	eto_options		;ExtTextOut options

	localW	bp4
	localW	abs_count		;[bp-6] WIN1
	localW 	local_str		;[bp-8] WIN1
	localW	next_scan		;[bp-0a] Index to get to next scan line
	localW	y_step			;[bp-0c] Y step
	localW	back_step		;[bp-0e] Y backstep
	localW	draw_func		;[bp-10]
	localB	num_planes		;Number of planes in a bitmap
	localB	opaque_routine		;Routine which does actual opaquing
	localW	colors			;Text/background colors
;		^--- this is probably actually opaque_routine
	localW	next_plane		;Index to get to next plane
	localW	fontw_bytes		;*[bp-18h] Source font width (bytes)
	localW	opaque_height		;Height of opaque box (sometimes)
	localW	clip_left		;*[bp-1c] WIN1
	localW	clip_right		; [bp-1e] WIN1
;;;	localD	lp_surface		;Pointer to first byte of destination
	localW	temp_off_lp_bits	;Intermediate pointer to dev surface
	localW	scan_start		;Delta from start of scan
	localW	clipped_font_height	;Actual height of bits to be drawn
;
; BP-24h
;
;;;	localW	tot_brk_extra		;Total break extra
	localW	df_pixel_w		; WIN1 font pixel width
	localW	brk_extra		;*# extra pixels to add each break char
	localW	brk_err 		;*Justification DDA error term
	localW	brk_rem 		;*  extra pixels are distributed
	localW	brk_count		;*DDA - # breaks into which BrkRem
	localW	char_xtra		;*# extra pixels to add each char
	localW	dst_dev_type		;Bitmap or screen?
	localW	str_pointer		;Current position in local_str

cBegin
	if	???			;Do test only if locals
	jc	j_exit_strblt		;No room for locals, return now
	endif

	mov	ax, count
	cwd
	xor	ax,dx			;Force positive
	shl	ax, 1			;Check that there's room on the stack
	shl	ax, 1			;for the string
	add	ax, 20h			;at 4 bytes / character + 32 overhead
	mov	cx, ax
	call	my_check_stack
	jnc	strblt_01
j_exit_strblt:
	jmp	exit_strblt
;
strblt_01:
	add	sp, cx
	mov	local_str, sp	
	lds	si, lp_clip_rect
	les	di, lp_font
	
;;;	mov	al,enabled_flag 	;Save enabled_flag incase we need it
;;;	mov	local_enabled_flag,al

;;;	call	get_mode		;Get data from drawmode, set flags
;;;	call	get_font		;Get font data (aborts if invalid)


;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	mov	ax,count
	or	ax,ax
	jz	j_only_draw		;No chars, might have opaque rect
	jg	strblt_02		;Positive count, output string
	neg	ax
	xor	bx, bx
	mov	word ptr lp_clip_rect, bx
strblt_02:
	mov	abs_count, ax
	mov	cx, es:[di].dfWidthBytes
	mov	fontw_bytes, cx
	mov	ax, es:[di].dfPixWidth
	mov	df_pixel_w, ax
	or	si, si			;Clip rectangle present?
	jz	strblt_05
	mov	ax, [si].top
	mov	dx, ax
	sub	ax, y
	mov	bx, ax
	jge	strblt_03
	sub	dx, bx
	xor	bx, bx
strblt_03:
	mov	temp_off_lp_bits,dx
	mov	scan_start,dx
	mov	dx, es:[di].dfPixHeight
	cmp	bx, dx
	jge	j_only_draw
	mov	ax, [si].bottom
	sub	ax, y
	cmp	ax, dx
	jl	strblt_04
	mov	ax, dx
strblt_04:
	or	ax, ax
	jle	j_only_draw
	cmp	ax, bx
	jle	j_only_draw
	jmp	short strblt_06
	nop

j_only_draw:
	jmp	only_draw


strblt_05:
	mov	bx, y
	mov	temp_off_lp_bits,bx
	mov	scan_start,bx
	xor	bx, bx
	mov	ax, es:[di].dfPixHeight
strblt_06:
	sub	ax, bx
	mov	clipped_font_height,ax
	add	scan_start, ax
	add	ax, bx
	mul	cx
	mov	dx,es:[di].dfBitsPointer
	add	ax, dx
	dec	ax
	mov	opaque_height, ax
	mov	ax, bx
	mov	si, bx
	mov	bx, dx
	mul	cx
	add	ax, bx
	dec	ax
	mov	next_plane,ax
	mov	ax, si
	lds	si, lp_draw_mode
	mov	brk_err, 0
	cmp	word ptr es:[di].dfPixWidth, 0
	jz	strblt_08
	mov	dx, offset X152D
	mov	opaque_routine,dx		
	cmp	[si].TBreakExtra,0
	jz	strblt_07
	mov	dx, offset X1553
	mov	opaque_routine,dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_07:
	mov	dx, [si].CharExtra
	mov	si, offset X1511
	or	dx, dx
	jz	strblt_10
	mov	si, offset X150B
	mov	char_xtra,dx
	xor	dx, dx
	mov	df_pixel_w, dx
	jmp	short strblt_10
	nop
;
strblt_08:
	mov	dx, offset X158E
	mov	opaque_routine, dx
	cmp	[si].TBreakExtra, 0
	jz	strblt_09
	mov	dx, offset X153F
	mov	opaque_routine, dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_09:	
	mov	dx, [si].CharExtra
	mov	si, offset X1576
	or	dx, dx
	jz	strblt_10
	mov	si, offset X1570
	mov	char_xtra, dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_10:
	mov	draw_func, si
	xor	si, offset X15AF
	mov	colors, si		;XXX
	lds	si, lp_device
	mov	dx, [si].bmWidthBytes
	add	ax, y
	mov	cx,[si].bmType
	mov	dst_dev_type, cx	
	xor	cx, cx
	mov	bx, dx
	xor	di, di
	cmp	[si].bmType, cx		;Main memory bitmap?
	jz	strblt_10b		;If so, no funny step between lines
	mov	bx, 2
	xor	cx, cx
strblt_10b:
	mul	dx
	add	ax, di
	mov	y_step, bx		; XXX y_step and back_step are 
	mov	back_step, cx		; correct here... which means 
	lds	si, lp_clip_rect	; previous references are incorrect
	mov	bx, x
	or	si, si
	jnz	strblt_10c
	jmp	strblt_15
strblt_10c:
	mov	cx, [si].left
	mov	clip_left, cx
	mov	di, bx
	mov	dx, [si].right
	mov	clip_right, dx
	sub	dx, cx
	sub	bx, cx
	jl	strblt_11
	mov	clip_left, di
	mov	cx, di
	sub	dx, bx
	xor	bx, bx
strblt_11:
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di		;XXX
	cmp	dst_dev_type, 0
	jnz	strblt_11a
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	jmp	short strblt_11c
strblt_11a:
	push	bx
	push	dx
	push	ax
	mov	ax, cx
	and	ax, 0FFF0h
	mov	bx, CELLS_X
	mul	bx
	and	cx, wptr 0Fh	
	cmp	cx, 7
	jle	strblt_11b
	inc	ax
strblt_11b:
	mov	cx, ax
	pop	ax
	pop	dx
	pop	bx
strblt_11c:
	add	ax, cx
	mov	next_scan, ax	;XXX
	cmp	bx, dx
	jl	strblt_11d
	jmp	only_draw
strblt_11d:
	lds	si, lp_string
	les	di, lp_font
strblt_12:
	call	word ptr draw_func
	jle	strblt_12
	or	ax, ax
	jz	strblt_14
	add	ax, cx
	sub	ax, bx
	mov	cx, bx
	sub	bx, dx
strblt_13:
	jl	strblt_13a
	jmp	strblt_21
strblt_13a:
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	call	word ptr draw_func
	jmp	short strblt_13
;
strblt_14:
	add	ax, cx
	sub	ax, bx
	and	ax, 7
	mov	cx, bx
	sub	bx, dx
	jmp	short strblt_13
;
strblt_15:
	mov	clip_left, bx
	mov	clip_right, bx
	mov	cx, bx
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	;XXX
	cmp	dst_dev_type, 0
	jnz	strblt_15a
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	jmp	short strblt_15c
	nop
;
strblt_15a:
	push	ax
	push	dx
	push	cx
	mov	ax, bx
	and	ax, 0FFF0h
	mov	cx, CELLS_X
	mul	cx
	and	bx, wptr 0Fh
	cmp	bx, 7
	jle	strblt_15b
	inc	ax
strblt_15b:
	mov	bx, ax
	pop	cx
	pop	dx
	pop	ax	
strblt_15c:	
	add	ax, bx
	mov	next_scan, ax	;XXX
	lds	si, lp_string
	les	di, lp_font
	xor	bx, bx
strblt_16:
	call	word ptr draw_func
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	jmp	short strblt_16
;
j2_only_draw:	
	jmp	only_draw

strblt_20:
	pop	dx
	pop	si
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	push	si
	push	dx
	jmp	short strblt_23
	nop
;
strblt_21:
	sub	cx, bx
	jle	strblt_22
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
strblt_22:
	cmp	sp, local_str
	jz	j2_only_draw
strblt_23:
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
;;;	mov	cx, count
;;;	or	cx, cx
;;;	jg	strblt_25
;;;	mov	cx, brk_err
;;;	jcxz	strblt_24
;;;	lds	si, lp_draw_mode
;;;	mov	[si].BreakErr, ax
strblt_24:
;;;	mov	ax, clip_right
;;;	sub	ax, clip_left
;;;	mov	dx, scan_start
;;;	sub	dx, temp_off_lp_bits
;;;	jmp	only_draw
;
strblt_25:
	lds	si, lp_device
	cmp	[si].bmType,0
	jz	strblt_27
	mov	cx, count
	or	cx, cx
	jl	strblt_27
	mov	cx, clip_left
	mov	dx, temp_off_lp_bits
	mov	si, clip_right
	mov	di, scan_start
	call	exclude
strblt_26:	
strblt_27:
;;;	mov	ax, [si].BreakExtra
;;;	cmp	word ptr [si].TextColor, 103h
	lds	si, lp_draw_mode
	mov	ax, count
	or	ax, ax
	jg	strblt_29
	mov	ax, brk_err
	or	ax, ax
	jz	strblt_28
	mov	[si].BreakErr, ax
;
strblt_28:
	mov	ax, clip_right
	sub	ax, clip_left
	mov	dx, scan_start
	sub	dx, temp_off_lp_bits
	jmp	only_draw

strblt_29:
	cmp	word ptr [si].bkMode, 1
	jnz	strblt_30
	jmp	strblt_38
strblt_30:
	mov	al,[si].bkColor
	xor	ah,ah
	mov	si,ax
	mov	cx, clip_left
	mov	ax, cx
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	dl, 0FFh
	and	cx, word ptr 7
	shr	dl, cl		;Left fringe
	mov	cx, clip_right
	dec	cx
	mov	bx, cx
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	mov	dh, 0FFh
	and	cx, word ptr 7
	sub	cx, 7
	neg	cx
	shl	dh, cl		;Right fringe
	inc	ax
	sub	bx, ax
	jge	strblt_31
	and	dl, dh	;Left fringe = right fringe
strblt_31:	
	mov	cx, bx
	mov	clip_left, cx
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan	
	mov	bx, y_step
	cmp	dst_dev_type, 0
	jz	strblt_31a
	jmp	strblt_370
strblt_31a:
	mov	al, 0FFh
	or	si, si
	jnz	strblt_35
	not	al
	not	dx
strblt_32:
	mov	si, di
	and	es:[di], dl
	inc	di
	or	cx, cx
	jl	strblt_34
	jz	strblt_33
	rep	stosb
strblt_33:
	and	es:[di],dh
strblt_34:
	mov	di,si
	add	di,bx
	mov	cx, clip_left
	dec	wptr clipped_font_height
	jg	strblt_32
	jmp 	strblt_38
;
strblt_35:
	mov	si, di
	or	es:[di], dl
	inc	di
	or	cx,cx
	jl	strblt_37
	jz	strblt_36
	rep	stosb
strblt_36:
	or	es:[di],dh
strblt_37:
	mov	di,si
	add	di,bx
	mov	cx,clip_left
	dec	wptr clipped_font_height
	jg	strblt_35
	jmp	strblt_38

strblt_370:
	mov	bx, offset flip_byte
	xchg	dl, al
	xlat	byte ptr cs:[bx]
	xchg	dl, al
	xchg	dh, al
	xlat	byte ptr cs:[bx]
	xchg	dh, al
	mov	al, 0FFh
	or	si, si
	jnz	strblt_378
	not	al
	not	dx
strblt_371:
	mov	si, di
	and	es:[di],dl
	inc	di
	test	di,wptr 1
	jnz	strblt_372
	add	di,TILE_STEP
strblt_372:
	or	cx,cx
	jl	strblt_377
	jz	strblt_375
strblt_373:
	stosb
	test	di, 1
	jnz	strblt_374
	add	di, TILE_STEP
strblt_374:
	loop	strblt_373
strblt_375:
	and	es:[di],dh
strblt_377:
	mov	di, si	
	add	di, 2
	mov	cx, clip_left
	dec	wptr clipped_font_height
	jg	strblt_371
	jmp	short strblt_38
	nop

strblt_378:
	mov	si, di
	or	es:[di],dl
	inc	di
	test	di, 1
	jnz	strblt_379
	add	di, TILE_STEP
strblt_379:
	or	cx,cx
	jl	strblt_37d
	jz	strblt_37c
strblt_37a:
	stosb
	test	di, 1
	jnz	strblt_37b
	add	di, TILE_STEP
strblt_37b:
	loop	strblt_37a
strblt_37c:
	or	es:[di],dh
strblt_37d:
	mov	di, si
	add	di, 2
	mov	cx,clip_left
	dec	wptr clipped_font_height
	jg	strblt_378

strblt_38:
	xor	dx,dx
	lds	si, lp_draw_mode
	cmp	bptr [si].TextColor,1
	sbb	dl, dl
	lds	si, lp_font
	lds	si, [si].dfBitsPointer
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan
	mov	next_scan, di
	cmp	dst_dev_type, 0
	jz	j_strblt_52
	jmp	strblt_152	

j_strblt_52:
	jmp	strblt_52
;
strblt_39:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	mov	dh, es:[di]
	xor	dh, dl
	or	ah, dh
	xor	ah, dl
	xchg	ah, al
	stosb
	xchg	ah, al
	mov	dh, 8
	neg	cl
	jz	strblt_45
strblt_44:
	sub	dh, cl
	jle	strblt_39
	shl	ax, cl
strblt_45:
	cmp	ch, 8
	ja	strblt_47
	or	ch, ch
	jz	strblt_49
	xor	al, al
	or	si, si
	jz	strblt_46
	lodsb
strblt_46:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_47:
	xor	al, al
	or	si, si
	jz	strblt_48
	lodsb
strblt_48:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_44
strblt_49:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al, al
	or	si, si
	jz	strblt_50
	add	si, next_plane
	lodsb
strblt_50:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_44
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_51:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	mov	al, es:[di]
	xor	al, dl
	or	al, ah
	xor	al, dl
	stosb
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_53
	mov	next_plane, si
	mov	bx, y_step
	mov	di, bx
	add	di, next_scan
	mov	next_scan, di
	mov	y_step, bx	;BX has not changed - holdover from Herc
strblt_52:
	mov	bx, local_str
	xor	ax, ax
	mov	dh, bptr bp4	;XXX
	jmp	short strblt_49
;
strblt_53:
	jmp	only_draw

strblt_54:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	mov	dh, es:[di]
	xchg	dh, al
	xlat	byte ptr cs:[bx]
	xchg	dh, al
	xor	dh, dl
	or	ah, dh
	xor	ah, dl
	xchg	ah, al
	xlat	byte ptr cs:[bx]
	stosb
	test	di, 1
	jnz	strblt_54a
	add	di, TILE_STEP
strblt_54a:
	xlat	byte ptr cs:[bx]
	xchg	ah, al
	mov	dh, 8
	neg	cl
	jz	strblt_56
strblt_55:
	sub	dh, cl
	jle	strblt_54
	shl	ax, cl
;
strblt_56:
	cmp	ch, 8
	ja	strblt_58
	or	ch, ch
	jz	strblt_60
	xor	al, al
	or	si, si
	jz	strblt_57
	lodsb
strblt_57:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_55
;
strblt_58:
	xor	al, al
	or	si, si
	jz	strblt_59
	lodsb
;
strblt_59:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_55
;
strblt_60:
	mov	bx, str_pointer
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	str_pointer, bx
	mov	cx, ss:[bx]
	mov	bx, offset flip_byte
	or	cl, cl
	js	strblt_150
	xor	al, al
	or	si, si
	jz	strblt_61
	add	si, next_plane
	lodsb
strblt_61:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_55
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_55
;
strblt_150:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	mov	al, es:[di]
	xlat	byte ptr cs:[bx]
	xor	al, dl
	or	al, ah
	xor	al, dl
	xlat	byte ptr cs:[bx]
	stosb
	test	di, 1
	jnz	strblt_151
	add	di, TILE_STEP
strblt_151:
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_153
	mov	next_plane, si
	mov	bx, y_step
	mov	di, bx
	add	di, next_scan
	mov	next_scan, di
	mov	y_step, bx	;BX has not changed...
;
strblt_152:
	mov	bx, local_str
	mov	str_pointer, bx
	xor	ax, ax
	mov	dh, bptr bp4	;XXX
	jmp	short strblt_60
;
strblt_153:
	jmp	only_draw

strblt_154:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_161
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl		;Right fringe
	cmp	dh, cl
	jg	strblt_155
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_159
	mov	cl, 8
	jmp	short strblt_157
	nop
;
strblt_155:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_160
	nop

strblt_156:
;;	add	si, next_plane
	lodsb
strblt_157:
	mov	dh, es:[di]
	xor	dh, dl
	or	al, dh
	xor	al, dl
	stosb
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_161
	add	si, next_plane
	jmp	short strblt_156
;
strblt_158:
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_159:
	neg	cl
	mov	dh, es:[di]
	xor	dh, dl
	or	al, dh
	xor	al, dl
	stosb
	rol	ax, cl
	sub	cl, 8
strblt_160:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_161
	add	si,next_plane
	jmp	short strblt_158

strblt_161:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_49


;
only_draw:
	mov	sp, local_str
	call	unexclude
exit_strblt:

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Eh
	page
;

X1505:	mov	al, es:[di].dfDefaultChar
	jmp	short X1523
	nop
;
X150B:	mov	cx,colors
	xor	draw_func,cx
X1511:	lodsb
	dec	abs_count
	jl	X1535
	cmp	al, es:[di].dfLastChar
	ja	X1505
	sub	al, es:[di].dfFirstChar
	jb	X1505
X1523:	mov	cx, es:[di].dfPixWidth
	cmp	al, es:[di].dfBreakChar
	jz	X153C
X152D:	mul	cl
	add	ax, 8
	add	bx, cx
	ret
;
X1535:	add	clip_right, bx
	pop	ax
	jmp	strblt_22
;
X153C:	jmp	wptr opaque_routine
;
X153F:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	pop	bx
	jz	X1576
X1553:	add	cx, brk_extra
	mov	ax, brk_err
	sub	ax, brk_rem
	jg	X1562
	add	ax, brk_count
	inc	cx
X1562:	mov	brk_err, ax
	xor	ax, ax
	add	bx, cx
	ret
;
X156A:	mov	al, es:[di].dfDefaultChar
	jmp	short X1588
	nop

X1570:	mov	cx, colors
	xor	draw_func, cx
X1576:	lodsb
	dec	abs_count
	jl	X15A8
	cmp	al, es:[di].dfLastChar
	ja	X156A
	sub	al, es:[di].dfFirstChar
	jc	X156A
X1588:	cmp	al, es:[di].dfBreakChar
	jz	X153C
X158E:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	add	ax, 8
	pop	bx
	jz	X1576
	add	bx, cx
	ret

X15A8:
	add	clip_right, bx
	pop	ax
	jmp	strblt_22

X15AF:
	mov	cx, colors
	xor	draw_func, cx
	mov	cx, char_xtra
	xor	ax, ax
	add	bx, cx
	ret

flip_byte	label	byte
	db	00h, 80h, 40h, 0C0h, 20h, 0A0h, 60h, 0E0h
	db	10h, 90h, 50h, 0D0h, 30h, 0B0h, 70h, 0F0h
	db	08h, 88h, 48h, 0C8h, 28h, 0A8h, 68h, 0E8h
	db	18h, 98h, 58h, 0D8h, 38h, 0B8h, 78h, 0F8h
	db	04h, 84h, 44h, 0C4h, 24h, 0A4h, 64h, 0E4h
	db	14h, 94h, 54h, 0D4h, 34h, 0B4h, 74h, 0F4h
	db	0Ch, 8Ch, 4Ch, 0CCh, 2Ch, 0ACh, 6Ch, 0ECh
	db	1Ch, 9Ch, 5Ch, 0DCh, 3Ch, 0BCh, 7Ch, 0FCh
	db	02h, 82h, 42h, 0C2h, 22h, 0A2h, 62h, 0E2h
	db	12h, 92h, 52h, 0D2h, 32h, 0B2h, 72h, 0F2h
	db	0Ah, 8Ah, 4Ah, 0CAh, 2Ah, 0AAh, 6Ah, 0EAh
	db	1Ah, 9Ah, 5Ah, 0DAh, 3Ah, 0BAh, 7Ah, 0FAh
	db	06h, 86h, 46h, 0C6h, 26h, 0A6h, 66h, 0E6h
	db	16h, 96h, 56h, 0D6h, 36h, 0B6h, 76h, 0F6h
	db	0Eh, 8Eh, 4Eh, 0CEh, 2Eh, 0AEh, 6Eh, 0EEh
	db	1Eh, 9Eh, 5Eh, 0DEh, 3Eh, 0BEh, 7Eh, 0FEh
	db	01h, 81h, 41h, 0C1h, 21h, 0A1h, 61h, 0E1h
	db	11h, 91h, 51h, 0D1h, 31h, 0B1h, 71h, 0F1h
	db	09h, 89h, 49h, 0C9h, 29h, 0A9h, 69h, 0E9h
	db	19h, 99h, 59h, 0D9h, 39h, 0B9h, 79h, 0F9h
	db	05h, 85h, 45h, 0C5h, 25h, 0A5h, 65h, 0E5h
	db	15h, 95h, 55h, 0D5h, 35h, 0B5h, 75h, 0F5h
	db	0Dh, 8Dh, 4Dh, 0CDh, 2Dh, 0ADh, 6Dh, 0EDh
	db	1Dh, 9Dh, 5Dh, 0DDh, 3Dh, 0BDh, 7Dh, 0FDh
	db	03h, 83h, 43h, 0C3h, 23h, 0A3h, 63h, 0E3h
	db	13h, 93h, 53h, 0D3h, 33h, 0B3h, 73h, 0F3h
	db	0Bh, 8Bh, 4Bh, 0CBh, 2Bh, 0ABh, 6Bh, 0EBh
	db	1Bh, 9Bh, 5Bh, 0DBh, 3Bh, 0BBh, 7Bh, 0FBh
	db	07h, 87h, 47h, 0C7h, 27h, 0A7h, 67h, 0E7h
	db	17h, 97h, 57h, 0D7h, 37h, 0B7h, 77h, 0F7h
	db	0Fh, 8Fh, 4Fh, 0CFh, 2Fh, 0AFh, 6Fh, 0EFh
	db	1Fh, 9Fh, 5Fh, 0DFh, 3Fh, 0BFh, 7Fh, 0FFh


sEnd	Code
	end
