;-----------------------------Module-Header-----------------------------;
; Module Name:	DRAWMOD2.ASM
;
;   This module contains tables for using the special EGA
;   hardware for the bianry raster operations.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	none
;
; Public Data:		SINGLE_OK
;			dm_flags
;			dm_data_r
;			dm_pen_and
;			dm_pen_xor
;
; General Description:
;
;   The EGA card has special drawing logic where a logical
;   operation may be performed between the display memory
;   and data from the processor.  There is also drawing
;   logic that allows a byte from the processor to be
;   taken as a color to be written into all enabled bits
;   and enabled planes of a particular byte.  By combining
;   these operations, most of the binary drawing modes
;   specified by GDI can be implemented in one pass over
;   EGA memory.
;
;   12 of the 16 GDI binary drawing modes can be done in one pass
;   if writing a solid color using the EGA color write mode.
;
;   Scanline must also deal with background modes.  Brushes
;   implicitly handle opaque mode by the colors they are realized
;   in.  For transparent mode, a mask is computed from the
;   brush for background and NOT background.  By using this mask
;   in the EGA's Bit Mask register, only those bits that are
;   forground will be changed.	Scanline can use the same 12
;   EGA drawing modes as lines if the color is solid.
;
;   Dithered patterns cannot be performed in one pass since
;   they are not solid.
;
;
;   EGA special support possible:
;
;	    Operation	  Single Pass
;	       DDx	       y
;	       DPon
;	       DPna	       y
;	       Pn	       y
;	       PDna
;	       Dn	       y
;	       DPx	       y
;	       DPan
;	       DPa	       y
;	       DPxn	       y
;	       D	       y
;	       DPno	       y
;	       P	       y
;	       PDno
;	       DPo	       y
;	       DDxn	       y
;
;
;
;
;   The following cannot be performed in one pass using the
;   EGA hardware.  They can be performed in two seperate
;   operations to the EGA.  This will be done in the following
;   manner:
;
;	The color will be used for the Write Plane Enable Mask
;	after it has possibly been inverted to sync for the
;	output mode being used (xor or set)
;
;	A write with 0's or 1's in drSet mode will occur.
;	This will set bits to either 1's or 0's as needed.
;
;	After this write occurs, the color will be inverted
;	for use as the Write Plane Enable Mask for those
;	planes which must be XORed to get ~dest.  An XOR
;	will occur to toggle those bits which must be toggled.
;
;
;	      Color  Result
;
;	DPon	0    ~dest   for color bits which are 0, xor with 1
;		1      0     for color bits which are 1, set to   0
;
;	PDna	0      0     for color bits which are 0, set to   0
;		1    ~dest   for color bits which are 1, xor with 1
;
;	DPan	0      1     for color bits which are 0, set to   1
;		1    ~dest   for color bits which are 1, xor with 1
;
;	PDno	0    ~dest   for color bits which are 0, xor with 1
;		1      1     for color bits which are 1, set to   1
;
; Restrictions:
;
;-----------------------------------------------------------------------;

	include	cmacros.inc
	include apricot.inc

sBegin	Code
	include drawmod2.inc
sEnd	Code

	end
